/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockMapper;
import org.apache.kafka.test.MockTimestampExtractor;
import org.apache.kafka.test.MockValueJoiner;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InternalStreamsBuilderTest {
    private static final String APP_ID = "app-id";
    private final InternalStreamsBuilder builder = new InternalStreamsBuilder(new InternalTopologyBuilder());
    private KStreamTestDriver driver = null;
    private final ConsumedInternal<String, String> consumed = new ConsumedInternal();
    private final String storePrefix = "prefix-";
    private MaterializedInternal<String, String, KeyValueStore<Bytes, byte[]>> materialized = new MaterializedInternal(Materialized.as("test-store"), this.builder, "prefix-");

    @Before
    public void setUp() {
        this.builder.internalTopologyBuilder.setApplicationId(APP_ID);
    }

    @After
    public void cleanup() {
        if (this.driver != null) {
            this.driver.close();
        }
        this.driver = null;
    }

    @Test
    public void testNewName() {
        Assert.assertEquals((Object)"X-0000000000", (Object)this.builder.newProcessorName("X-"));
        Assert.assertEquals((Object)"Y-0000000001", (Object)this.builder.newProcessorName("Y-"));
        Assert.assertEquals((Object)"Z-0000000002", (Object)this.builder.newProcessorName("Z-"));
        InternalStreamsBuilder newBuilder = new InternalStreamsBuilder(new InternalTopologyBuilder());
        Assert.assertEquals((Object)"X-0000000000", (Object)newBuilder.newProcessorName("X-"));
        Assert.assertEquals((Object)"Y-0000000001", (Object)newBuilder.newProcessorName("Y-"));
        Assert.assertEquals((Object)"Z-0000000002", (Object)newBuilder.newProcessorName("Z-"));
    }

    @Test
    public void testNewStoreName() {
        Assert.assertEquals((Object)"X-STATE-STORE-0000000000", (Object)this.builder.newStoreName("X-"));
        Assert.assertEquals((Object)"Y-STATE-STORE-0000000001", (Object)this.builder.newStoreName("Y-"));
        Assert.assertEquals((Object)"Z-STATE-STORE-0000000002", (Object)this.builder.newStoreName("Z-"));
        InternalStreamsBuilder newBuilder = new InternalStreamsBuilder(new InternalTopologyBuilder());
        Assert.assertEquals((Object)"X-STATE-STORE-0000000000", (Object)newBuilder.newStoreName("X-"));
        Assert.assertEquals((Object)"Y-STATE-STORE-0000000001", (Object)newBuilder.newStoreName("Y-"));
        Assert.assertEquals((Object)"Z-STATE-STORE-0000000002", (Object)newBuilder.newStoreName("Z-"));
    }

    @Test
    public void shouldHaveCorrectSourceTopicsForTableFromMergedStream() throws Exception {
        String topic1 = "topic-1";
        String topic2 = "topic-2";
        String topic3 = "topic-3";
        KStream<String, String> source1 = this.builder.stream(Collections.singleton("topic-1"), this.consumed);
        KStream<String, String> source2 = this.builder.stream(Collections.singleton("topic-2"), this.consumed);
        KStream<String, String> source3 = this.builder.stream(Collections.singleton("topic-3"), this.consumed);
        KStream<String, String> processedSource1 = source1.mapValues(new ValueMapper<String, String>(){

            @Override
            public String apply(String value) {
                return value;
            }
        }).filter(new Predicate<String, String>(){

            @Override
            public boolean test(String key, String value) {
                return true;
            }
        });
        KStream<String, String> processedSource2 = source2.filter(new Predicate<String, String>(){

            @Override
            public boolean test(String key, String value) {
                return true;
            }
        });
        KStream<String, String> merged = processedSource1.merge(processedSource2).merge(source3);
        merged.groupByKey().count("my-table");
        Map<String, List<String>> actual = this.builder.internalTopologyBuilder.stateStoreNameToSourceTopics();
        Assert.assertEquals(Utils.mkList("topic-1", "topic-2", "topic-3"), actual.get("my-table"));
    }

    @Test
    public void shouldStillMaterializeSourceKTableIfMaterializedIsntQueryable() throws Exception {
        KTable<String, String> table1 = this.builder.table("topic2", this.consumed, new MaterializedInternal(Materialized.with(null, null), this.builder, "prefix-"));
        ProcessorTopology topology = this.builder.internalTopologyBuilder.build((Integer)null);
        Assert.assertEquals((long)1L, (long)topology.stateStores().size());
        String storeName = "prefix-STATE-STORE-0000000000";
        Assert.assertEquals((Object)"prefix-STATE-STORE-0000000000", (Object)topology.stateStores().get(0).name());
        Assert.assertEquals((long)1L, (long)topology.storeToChangelogTopic().size());
        Assert.assertEquals((Object)"topic2", (Object)topology.storeToChangelogTopic().get("prefix-STATE-STORE-0000000000"));
        Assert.assertNull((Object)table1.queryableStoreName());
    }

    @Test
    public void shouldBuildGlobalTableWithNonQueryableStoreName() throws Exception {
        GlobalKTable<String, String> table1 = this.builder.globalTable("topic2", this.consumed, new MaterializedInternal(Materialized.with(null, null), this.builder, "prefix-"));
        Assert.assertNull((Object)table1.queryableStoreName());
    }

    @Test
    public void shouldBuildGlobalTableWithQueryaIbleStoreName() throws Exception {
        GlobalKTable<String, String> table1 = this.builder.globalTable("topic2", this.consumed, new MaterializedInternal(Materialized.as("globalTable"), this.builder, "prefix-"));
        Assert.assertEquals((Object)"globalTable", (Object)table1.queryableStoreName());
    }

    @Test
    public void shouldBuildSimpleGlobalTableTopology() throws Exception {
        this.builder.globalTable("table", this.consumed, new MaterializedInternal(Materialized.as("globalTable"), this.builder, "prefix-"));
        ProcessorTopology topology = this.builder.internalTopologyBuilder.buildGlobalStateTopology();
        List<StateStore> stateStores = topology.globalStateStores();
        Assert.assertEquals((long)1L, (long)stateStores.size());
        Assert.assertEquals((Object)"globalTable", (Object)stateStores.get(0).name());
    }

    private void doBuildGlobalTopologyWithAllGlobalTables() throws Exception {
        ProcessorTopology topology = this.builder.internalTopologyBuilder.buildGlobalStateTopology();
        List<StateStore> stateStores = topology.globalStateStores();
        Set<String> sourceTopics = topology.sourceTopics();
        Assert.assertEquals(Utils.mkSet("table", "table2"), sourceTopics);
        Assert.assertEquals((long)2L, (long)stateStores.size());
    }

    @Test
    public void shouldBuildGlobalTopologyWithAllGlobalTables() throws Exception {
        this.builder.globalTable("table", this.consumed, new MaterializedInternal(Materialized.as("global1"), this.builder, "prefix-"));
        this.builder.globalTable("table2", this.consumed, new MaterializedInternal(Materialized.as("global2"), this.builder, "prefix-"));
        this.doBuildGlobalTopologyWithAllGlobalTables();
    }

    @Test
    public void shouldAddGlobalTablesToEachGroup() throws Exception {
        String one = "globalTable";
        String two = "globalTable2";
        GlobalKTable<String, String> globalTable = this.builder.globalTable("table", this.consumed, new MaterializedInternal(Materialized.as("globalTable"), this.builder, "prefix-"));
        GlobalKTable<String, String> globalTable2 = this.builder.globalTable("table2", this.consumed, new MaterializedInternal(Materialized.as("globalTable2"), this.builder, "prefix-"));
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as("not-global"), this.builder, "prefix-");
        this.builder.table("not-global", this.consumed, materialized);
        KeyValueMapper<String, String, String> kvMapper = new KeyValueMapper<String, String, String>(){

            @Override
            public String apply(String key, String value) {
                return value;
            }
        };
        KStream<String, String> stream = this.builder.stream(Collections.singleton("t1"), this.consumed);
        stream.leftJoin(globalTable, kvMapper, MockValueJoiner.TOSTRING_JOINER);
        KStream<String, String> stream2 = this.builder.stream(Collections.singleton("t2"), this.consumed);
        stream2.leftJoin(globalTable2, kvMapper, MockValueJoiner.TOSTRING_JOINER);
        Map<Integer, Set<String>> nodeGroups = this.builder.internalTopologyBuilder.nodeGroups();
        for (Integer groupId : nodeGroups.keySet()) {
            ProcessorTopology topology = this.builder.internalTopologyBuilder.build(groupId);
            List<StateStore> stateStores = topology.globalStateStores();
            HashSet<String> names = new HashSet<String>();
            for (StateStore stateStore : stateStores) {
                names.add(stateStore.name());
            }
            Assert.assertEquals((long)2L, (long)stateStores.size());
            Assert.assertTrue((boolean)names.contains("globalTable"));
            Assert.assertTrue((boolean)names.contains("globalTable2"));
        }
    }

    @Test
    public void shouldMapStateStoresToCorrectSourceTopics() throws Exception {
        KStream<String, String> playEvents = this.builder.stream(Collections.singleton("events"), this.consumed);
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as("table-store"), this.builder, "prefix-");
        KTable<String, String> table = this.builder.table("table-topic", this.consumed, materialized);
        Assert.assertEquals(Collections.singletonList("table-topic"), this.builder.internalTopologyBuilder.stateStoreNameToSourceTopics().get("table-store"));
        KStream<Object, Object> mapped = playEvents.map(MockMapper.selectValueKeyValueMapper());
        mapped.leftJoin(table, MockValueJoiner.TOSTRING_JOINER).groupByKey().count("count");
        Assert.assertEquals(Collections.singletonList("table-topic"), this.builder.internalTopologyBuilder.stateStoreNameToSourceTopics().get("table-store"));
        Assert.assertEquals(Collections.singletonList("app-id-KSTREAM-MAP-0000000003-repartition"), this.builder.internalTopologyBuilder.stateStoreNameToSourceTopics().get("count"));
    }

    @Test
    public void shouldAddTopicToEarliestAutoOffsetResetList() {
        String topicName = "topic-1";
        ConsumedInternal consumed = new ConsumedInternal(Consumed.with(Topology.AutoOffsetReset.EARLIEST));
        this.builder.stream(Collections.singleton("topic-1"), consumed);
        Assert.assertTrue((boolean)this.builder.internalTopologyBuilder.earliestResetTopicsPattern().matcher("topic-1").matches());
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.latestResetTopicsPattern().matcher("topic-1").matches());
    }

    @Test
    public void shouldAddTopicToLatestAutoOffsetResetList() {
        String topicName = "topic-1";
        ConsumedInternal consumed = new ConsumedInternal(Consumed.with(Topology.AutoOffsetReset.LATEST));
        this.builder.stream(Collections.singleton("topic-1"), consumed);
        Assert.assertTrue((boolean)this.builder.internalTopologyBuilder.latestResetTopicsPattern().matcher("topic-1").matches());
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.earliestResetTopicsPattern().matcher("topic-1").matches());
    }

    @Test
    public void shouldAddTableToEarliestAutoOffsetResetList() {
        String topicName = "topic-1";
        this.builder.table("topic-1", new ConsumedInternal(Consumed.with(Topology.AutoOffsetReset.EARLIEST)), this.materialized);
        Assert.assertTrue((boolean)this.builder.internalTopologyBuilder.earliestResetTopicsPattern().matcher("topic-1").matches());
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.latestResetTopicsPattern().matcher("topic-1").matches());
    }

    @Test
    public void shouldAddTableToLatestAutoOffsetResetList() {
        String topicName = "topic-1";
        this.builder.table("topic-1", new ConsumedInternal(Consumed.with(Topology.AutoOffsetReset.LATEST)), this.materialized);
        Assert.assertTrue((boolean)this.builder.internalTopologyBuilder.latestResetTopicsPattern().matcher("topic-1").matches());
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.earliestResetTopicsPattern().matcher("topic-1").matches());
    }

    @Test
    public void shouldNotAddTableToOffsetResetLists() {
        String topicName = "topic-1";
        this.builder.table("topic-1", this.consumed, this.materialized);
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.latestResetTopicsPattern().matcher("topic-1").matches());
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.earliestResetTopicsPattern().matcher("topic-1").matches());
    }

    @Test
    public void shouldNotAddRegexTopicsToOffsetResetLists() {
        Pattern topicPattern = Pattern.compile("topic-\\d");
        String topic = "topic-5";
        this.builder.stream(topicPattern, this.consumed);
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.latestResetTopicsPattern().matcher("topic-5").matches());
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.earliestResetTopicsPattern().matcher("topic-5").matches());
    }

    @Test
    public void shouldAddRegexTopicToEarliestAutoOffsetResetList() {
        Pattern topicPattern = Pattern.compile("topic-\\d+");
        String topicTwo = "topic-500000";
        this.builder.stream(topicPattern, new ConsumedInternal(Consumed.with(Topology.AutoOffsetReset.EARLIEST)));
        Assert.assertTrue((boolean)this.builder.internalTopologyBuilder.earliestResetTopicsPattern().matcher("topic-500000").matches());
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.latestResetTopicsPattern().matcher("topic-500000").matches());
    }

    @Test
    public void shouldAddRegexTopicToLatestAutoOffsetResetList() {
        Pattern topicPattern = Pattern.compile("topic-\\d+");
        String topicTwo = "topic-1000000";
        this.builder.stream(topicPattern, new ConsumedInternal(Consumed.with(Topology.AutoOffsetReset.LATEST)));
        Assert.assertTrue((boolean)this.builder.internalTopologyBuilder.latestResetTopicsPattern().matcher("topic-1000000").matches());
        Assert.assertFalse((boolean)this.builder.internalTopologyBuilder.earliestResetTopicsPattern().matcher("topic-1000000").matches());
    }

    @Test
    public void shouldHaveNullTimestampExtractorWhenNoneSupplied() throws Exception {
        this.builder.stream(Collections.singleton("topic"), this.consumed);
        ProcessorTopology processorTopology = this.builder.internalTopologyBuilder.build((Integer)null);
        Assert.assertNull((Object)processorTopology.source("topic").getTimestampExtractor());
    }

    @Test
    public void shouldUseProvidedTimestampExtractor() throws Exception {
        ConsumedInternal consumed = new ConsumedInternal(Consumed.with(new MockTimestampExtractor()));
        this.builder.stream(Collections.singleton("topic"), consumed);
        ProcessorTopology processorTopology = this.builder.internalTopologyBuilder.build((Integer)null);
        Assert.assertThat((Object)processorTopology.source("topic").getTimestampExtractor(), (Matcher)IsInstanceOf.instanceOf(MockTimestampExtractor.class));
    }

    @Test
    public void ktableShouldHaveNullTimestampExtractorWhenNoneSupplied() throws Exception {
        this.builder.table("topic", this.consumed, this.materialized);
        ProcessorTopology processorTopology = this.builder.internalTopologyBuilder.build((Integer)null);
        Assert.assertNull((Object)processorTopology.source("topic").getTimestampExtractor());
    }

    @Test
    public void ktableShouldUseProvidedTimestampExtractor() throws Exception {
        ConsumedInternal consumed = new ConsumedInternal(Consumed.with(new MockTimestampExtractor()));
        this.builder.table("topic", consumed, this.materialized);
        ProcessorTopology processorTopology = this.builder.internalTopologyBuilder.build((Integer)null);
        Assert.assertThat((Object)processorTopology.source("topic").getTimestampExtractor(), (Matcher)IsInstanceOf.instanceOf(MockTimestampExtractor.class));
    }

    public static InternalTopologyBuilder internalTopologyBuilder(InternalStreamsBuilder internalStreamsBuilder) {
        return internalStreamsBuilder.internalTopologyBuilder;
    }
}

