/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.HashMap;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KGroupedTable;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Serialized;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockAggregator;
import org.apache.kafka.test.MockInitializer;
import org.apache.kafka.test.MockMapper;
import org.apache.kafka.test.MockReducer;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class KGroupedTableImplTest {
    private final StreamsBuilder builder = new StreamsBuilder();
    private static final String INVALID_STORE_NAME = "~foo bar~";
    private KGroupedTable<String, String> groupedTable;
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();
    private final String topic = "input";

    @Before
    public void before() {
        this.groupedTable = this.builder.table("blah", Consumed.with(Serdes.String(), Serdes.String())).groupBy(MockMapper.selectValueKeyValueMapper());
    }

    @Test
    public void shouldAllowNullStoreNameOnCount() {
        this.groupedTable.count((String)null);
    }

    @Test
    public void shouldAllowNullStoreNameOnAggregate() {
        this.groupedTable.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, (String)null);
    }

    @Test(expected=InvalidTopicException.class)
    public void shouldNotAllowInvalidStoreNameOnAggregate() {
        this.groupedTable.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, INVALID_STORE_NAME);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullInitializerOnAggregate() {
        this.groupedTable.aggregate(null, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, "store");
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullAdderOnAggregate() {
        this.groupedTable.aggregate(MockInitializer.STRING_INIT, null, MockAggregator.TOSTRING_REMOVER, "store");
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullSubtractorOnAggregate() {
        this.groupedTable.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, null, "store");
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullAdderOnReduce() {
        this.groupedTable.reduce(null, MockReducer.STRING_REMOVER, "store");
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullSubtractorOnReduce() {
        this.groupedTable.reduce(MockReducer.STRING_ADDER, null, "store");
    }

    @Test
    public void shouldAllowNullStoreNameOnReduce() {
        this.groupedTable.reduce(MockReducer.STRING_ADDER, MockReducer.STRING_REMOVER, (String)null);
    }

    @Test(expected=InvalidTopicException.class)
    public void shouldNotAllowInvalidStoreNameOnReduce() {
        this.groupedTable.reduce(MockReducer.STRING_ADDER, MockReducer.STRING_REMOVER, INVALID_STORE_NAME);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowNullStoreSupplierOnReduce() {
        this.groupedTable.reduce(MockReducer.STRING_ADDER, MockReducer.STRING_REMOVER, (StateStoreSupplier<KeyValueStore>)null);
    }

    private void doShouldReduce(KTable<String, Integer> reduced, String topic) {
        final HashMap results = new HashMap();
        reduced.foreach(new ForeachAction<String, Integer>(){

            @Override
            public void apply(String key, Integer value) {
                results.put(key, value);
            }
        });
        this.driver.setUp(this.builder, TestUtils.tempDirectory(), Serdes.String(), Serdes.Integer());
        this.driver.setTime(10L);
        this.driver.process(topic, "A", 1.1);
        this.driver.process(topic, "B", 2.2);
        this.driver.flushState();
        Assert.assertEquals((Object)1, results.get("A"));
        Assert.assertEquals((Object)2, results.get("B"));
        this.driver.process(topic, "A", 2.6);
        this.driver.process(topic, "B", 1.3);
        this.driver.process(topic, "A", 5.7);
        this.driver.process(topic, "B", 6.2);
        this.driver.flushState();
        Assert.assertEquals((Object)5, results.get("A"));
        Assert.assertEquals((Object)6, results.get("B"));
    }

    @Test
    public void shouldReduce() {
        KeyValueMapper<String, Number, KeyValue<String, Integer>> intProjection = new KeyValueMapper<String, Number, KeyValue<String, Integer>>(){

            @Override
            public KeyValue<String, Integer> apply(String key, Number value) {
                return KeyValue.pair(key, value.intValue());
            }
        };
        KTable<String, Integer> reduced = this.builder.table("input", Consumed.with(Serdes.String(), Serdes.Double()), Materialized.as("store").withKeySerde(Serdes.String()).withValueSerde(Serdes.Double())).groupBy(intProjection).reduce(MockReducer.INTEGER_ADDER, MockReducer.INTEGER_SUBTRACTOR, "reduced");
        this.doShouldReduce(reduced, "input");
        Assert.assertEquals((Object)reduced.queryableStoreName(), (Object)"reduced");
    }

    @Test
    public void shouldReduceWithInternalStoreName() {
        KeyValueMapper<String, Number, KeyValue<String, Integer>> intProjection = new KeyValueMapper<String, Number, KeyValue<String, Integer>>(){

            @Override
            public KeyValue<String, Integer> apply(String key, Number value) {
                return KeyValue.pair(key, value.intValue());
            }
        };
        KTable<String, Integer> reduced = this.builder.table("input", Consumed.with(Serdes.String(), Serdes.Double()), Materialized.as("store").withKeySerde(Serdes.String()).withValueSerde(Serdes.Double())).groupBy(intProjection).reduce(MockReducer.INTEGER_ADDER, MockReducer.INTEGER_SUBTRACTOR);
        this.doShouldReduce(reduced, "input");
        Assert.assertNull((Object)reduced.queryableStoreName());
    }

    @Test
    public void shouldReduceAndMaterializeResults() {
        KeyValueMapper<String, Number, KeyValue<String, Integer>> intProjection = new KeyValueMapper<String, Number, KeyValue<String, Integer>>(){

            @Override
            public KeyValue<String, Integer> apply(String key, Number value) {
                return KeyValue.pair(key, value.intValue());
            }
        };
        KTable<String, Integer> reduced = this.builder.table("input", Consumed.with(Serdes.String(), Serdes.Double())).groupBy(intProjection).reduce(MockReducer.INTEGER_ADDER, MockReducer.INTEGER_SUBTRACTOR, Materialized.as("reduce").withKeySerde(Serdes.String()).withValueSerde(Serdes.Integer()));
        this.doShouldReduce(reduced, "input");
        KeyValueStore reduce = (KeyValueStore)this.driver.allStateStores().get("reduce");
        MatcherAssert.assertThat(reduce.get("A"), (Matcher)CoreMatchers.equalTo((Object)5));
        MatcherAssert.assertThat(reduce.get("B"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void shouldCountAndMaterializeResults() {
        KTable<String, String> table = this.builder.table("input", Consumed.with(Serdes.String(), Serdes.String()));
        table.groupBy(MockMapper.selectValueKeyValueMapper(), Serialized.with(Serdes.String(), Serdes.String())).count(Materialized.as("count").withKeySerde(Serdes.String()).withValueSerde(Serdes.Long()));
        this.processData("input");
        KeyValueStore counts = (KeyValueStore)this.driver.allStateStores().get("count");
        MatcherAssert.assertThat(counts.get("1"), (Matcher)CoreMatchers.equalTo((Object)3L));
        MatcherAssert.assertThat(counts.get("2"), (Matcher)CoreMatchers.equalTo((Object)2L));
    }

    @Test
    public void shouldAggregateAndMaterializeResults() {
        KTable<String, String> table = this.builder.table("input", Consumed.with(Serdes.String(), Serdes.String()));
        table.groupBy(MockMapper.selectValueKeyValueMapper(), Serialized.with(Serdes.String(), Serdes.String())).aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, Materialized.as("aggregate").withValueSerde(Serdes.String()).withKeySerde(Serdes.String()));
        this.processData("input");
        KeyValueStore aggregate = (KeyValueStore)this.driver.allStateStores().get("aggregate");
        MatcherAssert.assertThat(aggregate.get("1"), (Matcher)CoreMatchers.equalTo((Object)"0+1+1+1"));
        MatcherAssert.assertThat(aggregate.get("2"), (Matcher)CoreMatchers.equalTo((Object)"0+2+2"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointOnCountWhenMaterializedIsNull() {
        this.groupedTable.count((Materialized<String, Long, KeyValueStore<Bytes, byte[]>>)null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnReduceWhenMaterializedIsNull() {
        this.groupedTable.reduce(MockReducer.STRING_ADDER, MockReducer.STRING_REMOVER, (Materialized<String, String, KeyValueStore<Bytes, byte[]>>)null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnReduceWhenAdderIsNull() {
        this.groupedTable.reduce(null, MockReducer.STRING_REMOVER, Materialized.as("store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnReduceWhenSubtractorIsNull() {
        this.groupedTable.reduce(MockReducer.STRING_ADDER, null, Materialized.as("store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnAggregateWhenInitializerIsNull() {
        this.groupedTable.aggregate(null, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, Materialized.as("store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnAggregateWhenAdderIsNull() {
        this.groupedTable.aggregate(MockInitializer.STRING_INIT, null, MockAggregator.TOSTRING_REMOVER, Materialized.as("store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnAggregateWhenSubtractorIsNull() {
        this.groupedTable.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, null, Materialized.as("store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnAggregateWhenMaterializedIsNull() {
        this.groupedTable.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, MockAggregator.TOSTRING_REMOVER, (Materialized)null);
    }

    private void processData(String topic) {
        this.driver.setUp(this.builder, TestUtils.tempDirectory(), Serdes.String(), Serdes.Integer());
        this.driver.setTime(0L);
        this.driver.process(topic, "A", "1");
        this.driver.process(topic, "B", "1");
        this.driver.process(topic, "C", "1");
        this.driver.process(topic, "D", "2");
        this.driver.process(topic, "E", "2");
        this.driver.flushState();
    }
}

