/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class KStreamFilterTest {
    private String topicName = "topic";
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();
    private Predicate<Integer, String> isMultipleOfThree = new Predicate<Integer, String>(){

        @Override
        public boolean test(Integer key, String value) {
            return key % 3 == 0;
        }
    };

    @Test
    public void testFilter() {
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{1, 2, 3, 4, 5, 6, 7};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream<Integer, String> stream = builder.stream(this.topicName, Consumed.with(Serdes.Integer(), Serdes.String()));
        stream.filter(this.isMultipleOfThree).process(processor, new String[0]);
        this.driver.setUp(builder);
        for (int expectedKey : expectedKeys) {
            this.driver.process(this.topicName, expectedKey, "V" + expectedKey);
        }
        Assert.assertEquals((long)2L, (long)processor.processed.size());
    }

    @Test
    public void testFilterNot() {
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{1, 2, 3, 4, 5, 6, 7};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream<Integer, String> stream = builder.stream(this.topicName, Consumed.with(Serdes.Integer(), Serdes.String()));
        stream.filterNot(this.isMultipleOfThree).process(processor, new String[0]);
        this.driver.setUp(builder);
        for (int expectedKey : expectedKeys) {
            this.driver.process(this.topicName, expectedKey, "V" + expectedKey);
        }
        Assert.assertEquals((long)5L, (long)processor.processed.size());
    }

    @Test
    public void testTypeVariance() {
        Predicate<Number, Object> numberKeyPredicate = new Predicate<Number, Object>(){

            @Override
            public boolean test(Number key, Object value) {
                return false;
            }
        };
        new StreamsBuilder().stream("empty").filter(numberKeyPredicate).filterNot(numberKeyPredicate).to("nirvana");
    }
}

