/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.ArrayList;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class KStreamFlatMapTest {
    private String topicName = "topic";
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();

    @Test
    public void testFlatMap() {
        StreamsBuilder builder = new StreamsBuilder();
        KeyValueMapper<Number, Object, Iterable<KeyValue<String, String>>> mapper = new KeyValueMapper<Number, Object, Iterable<KeyValue<String, String>>>(){

            @Override
            public Iterable<KeyValue<String, String>> apply(Number key, Object value) {
                ArrayList<KeyValue<String, String>> result2 = new ArrayList<KeyValue<String, String>>();
                for (int i = 0; i < key.intValue(); ++i) {
                    result2.add(KeyValue.pair(Integer.toString(key.intValue() * 10 + i), value.toString()));
                }
                return result2;
            }
        };
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream<Integer, String> stream = builder.stream(this.topicName, Consumed.with(Serdes.Integer(), Serdes.String()));
        stream.flatMap(mapper).process(processor, new String[0]);
        this.driver.setUp(builder);
        for (int expectedKey : expectedKeys) {
            this.driver.process(this.topicName, expectedKey, "V" + expectedKey);
        }
        Assert.assertEquals((long)6L, (long)processor.processed.size());
        String[] expected = new String[]{"10:V1", "20:V2", "21:V2", "30:V3", "31:V3", "32:V3"};
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)processor.processed.get(i));
        }
    }
}

