/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.ArrayList;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class KStreamFlatMapValuesTest {
    private String topicName = "topic";
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();

    @Test
    public void testFlatMapValues() {
        StreamsBuilder builder = new StreamsBuilder();
        ValueMapper<Number, Iterable<String>> mapper = new ValueMapper<Number, Iterable<String>>(){

            @Override
            public Iterable<String> apply(Number value) {
                ArrayList<String> result2 = new ArrayList<String>();
                result2.add("v" + value);
                result2.add("V" + value);
                return result2;
            }
        };
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        KStream<Integer, Integer> stream = builder.stream(this.topicName, Consumed.with(Serdes.Integer(), Serdes.Integer()));
        MockProcessorSupplier processor = new MockProcessorSupplier();
        stream.flatMapValues(mapper).process(processor, new String[0]);
        this.driver.setUp(builder);
        for (int expectedKey : expectedKeys) {
            this.driver.process(this.topicName, expectedKey, expectedKey);
        }
        Object[] expected = new String[]{"0:v0", "0:V0", "1:v1", "1:V1", "2:v2", "2:V2", "3:v3", "3:V3"};
        Assert.assertArrayEquals((Object[])expected, (Object[])processor.processed.toArray());
    }

    @Test
    public void testFlatMapValuesWithKeys() {
        StreamsBuilder builder = new StreamsBuilder();
        ValueMapperWithKey<Integer, Number, Iterable<String>> mapper = new ValueMapperWithKey<Integer, Number, Iterable<String>>(){

            @Override
            public Iterable<String> apply(Integer readOnlyKey, Number value) {
                ArrayList<String> result2 = new ArrayList<String>();
                result2.add("v" + value);
                result2.add("k" + readOnlyKey);
                return result2;
            }
        };
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        KStream<Integer, Integer> stream = builder.stream(this.topicName, Consumed.with(Serdes.Integer(), Serdes.Integer()));
        MockProcessorSupplier processor = new MockProcessorSupplier();
        stream.flatMapValues(mapper).process(processor, new String[0]);
        this.driver.setUp(builder);
        for (int expectedKey : expectedKeys) {
            this.driver.process(this.topicName, expectedKey, expectedKey);
        }
        Object[] expected = new String[]{"0:v0", "0:k0", "1:v1", "1:k1", "2:v2", "2:k2", "3:v3", "3:k3"};
        Assert.assertArrayEquals((Object[])expected, (Object[])processor.processed.toArray());
    }
}

