/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.StreamsBuilderTest;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.Joined;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorContext;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.MockValueJoiner;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class KStreamKStreamLeftJoinTest {
    private final String topic1 = "topic1";
    private final String topic2 = "topic2";
    private final Serde<Integer> intSerde = Serdes.Integer();
    private final Serde<String> stringSerde = Serdes.String();
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();
    private File stateDir = null;
    private final Consumed<Integer, String> consumed = Consumed.with(this.intSerde, this.stringSerde);

    @Before
    public void setUp() throws IOException {
        this.stateDir = TestUtils.tempDirectory((String)"kafka-test");
    }

    @Test
    public void testLeftJoin() {
        int i;
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream<Integer, String> stream1 = builder.stream("topic1", this.consumed);
        KStream<Integer, String> stream2 = builder.stream("topic2", this.consumed);
        KStream<Integer, String> joined = stream1.leftJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.of(100L), Joined.with(this.intSerde, this.stringSerde, this.stringSerde));
        joined.process(processor, new String[0]);
        Collection<Set<String>> copartitionGroups = StreamsBuilderTest.getCopartitionedGroups(builder);
        Assert.assertEquals((long)1L, (long)copartitionGroups.size());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("topic1", "topic2")), copartitionGroups.iterator().next());
        this.driver.setUp(builder, this.stateDir, Serdes.Integer(), Serdes.String());
        this.driver.setTime(0L);
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic1", expectedKeys[i], "X" + expectedKeys[i]);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:X0+null", "1:X1+null");
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic2", expectedKeys[i], "Y" + expectedKeys[i]);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:X0+Y0", "1:X1+Y1");
        for (i = 0; i < 3; ++i) {
            this.driver.process("topic1", expectedKeys[i], "X" + expectedKeys[i]);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:X0+Y0", "1:X1+Y1", "2:X2+null");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic2", expectedKey, "YY" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:X0+YY0", "0:X0+YY0", "1:X1+YY1", "1:X1+YY1", "2:X2+YY2");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:XX0+Y0", "0:XX0+YY0", "1:XX1+Y1", "1:XX1+YY1", "2:XX2+YY2", "3:XX3+YY3");
    }

    @Test
    public void testWindowing() {
        int i;
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        long time = 0L;
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream<Integer, String> stream1 = builder.stream("topic1", this.consumed);
        KStream<Integer, String> stream2 = builder.stream("topic2", this.consumed);
        KStream<Integer, String> joined = stream1.leftJoin(stream2, MockValueJoiner.TOSTRING_JOINER, JoinWindows.of(100L), Joined.with(this.intSerde, this.stringSerde, this.stringSerde));
        joined.process(processor, new String[0]);
        Collection<Set<String>> copartitionGroups = StreamsBuilderTest.getCopartitionedGroups(builder);
        Assert.assertEquals((long)1L, (long)copartitionGroups.size());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("topic1", "topic2")), copartitionGroups.iterator().next());
        this.driver.setUp(builder, this.stateDir);
        this.setRecordContext(time, "topic1");
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic1", expectedKeys[i], "X" + expectedKeys[i]);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:X0+null", "1:X1+null");
        this.setRecordContext(time, "topic2");
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic2", expectedKeys[i], "Y" + expectedKeys[i]);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:X0+Y0", "1:X1+Y1");
        time = 1000L;
        this.setRecordContext(time, "topic2");
        for (i = 0; i < expectedKeys.length; ++i) {
            this.setRecordContext(time + (long)i, "topic2");
            this.driver.process("topic2", expectedKeys[i], "Y" + expectedKeys[i]);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult(new String[0]);
        time = 1100L;
        this.setRecordContext(time, "topic1");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:XX0+Y0", "1:XX1+Y1", "2:XX2+Y2", "3:XX3+Y3");
        this.setRecordContext(++time, "topic1");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:XX0+null", "1:XX1+Y1", "2:XX2+Y2", "3:XX3+Y3");
        this.setRecordContext(++time, "topic1");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:XX0+null", "1:XX1+null", "2:XX2+Y2", "3:XX3+Y3");
        this.setRecordContext(++time, "topic1");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:XX0+null", "1:XX1+null", "2:XX2+null", "3:XX3+Y3");
        this.setRecordContext(++time, "topic1");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:XX0+null", "1:XX1+null", "2:XX2+null", "3:XX3+null");
        time = 899L;
        this.setRecordContext(time, "topic1");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:XX0+null", "1:XX1+null", "2:XX2+null", "3:XX3+null");
        this.setRecordContext(++time, "topic1");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:XX0+Y0", "1:XX1+null", "2:XX2+null", "3:XX3+null");
        this.setRecordContext(++time, "topic1");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:XX0+Y0", "1:XX1+Y1", "2:XX2+null", "3:XX3+null");
        this.setRecordContext(++time, "topic1");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:XX0+Y0", "1:XX1+Y1", "2:XX2+Y2", "3:XX3+null");
        this.setRecordContext(++time, "topic1");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:XX0+Y0", "1:XX1+Y1", "2:XX2+Y2", "3:XX3+Y3");
    }

    private void setRecordContext(long time, String topic) {
        ((MockProcessorContext)this.driver.context()).setRecordContext(new ProcessorRecordContext(time, 0L, 0, topic));
    }
}

