/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class KStreamMapValuesTest {
    private String topicName = "topic";
    private final Serde<Integer> intSerde = Serdes.Integer();
    private final Serde<String> stringSerde = Serdes.String();
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();

    @Test
    public void testFlatMapValues() {
        StreamsBuilder builder = new StreamsBuilder();
        ValueMapper<CharSequence, Integer> mapper = new ValueMapper<CharSequence, Integer>(){

            @Override
            public Integer apply(CharSequence value) {
                return value.length();
            }
        };
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream<Integer, String> stream = builder.stream(this.topicName, Consumed.with(this.intSerde, this.stringSerde));
        stream.mapValues(mapper).process(processor, new String[0]);
        this.driver.setUp(builder);
        for (int expectedKey : expectedKeys) {
            this.driver.process(this.topicName, expectedKey, Integer.toString(expectedKey));
        }
        Object[] expected = new String[]{"1:1", "10:2", "100:3", "1000:4"};
        Assert.assertArrayEquals((Object[])expected, (Object[])processor.processed.toArray());
    }

    @Test
    public void testMapValuesWithKeys() {
        StreamsBuilder builder = new StreamsBuilder();
        ValueMapperWithKey<Integer, CharSequence, Integer> mapper = new ValueMapperWithKey<Integer, CharSequence, Integer>(){

            @Override
            public Integer apply(Integer readOnlyKey, CharSequence value) {
                return value.length() + readOnlyKey;
            }
        };
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream<Integer, String> stream = builder.stream(this.topicName, Consumed.with(this.intSerde, this.stringSerde));
        stream.mapValues(mapper).process(processor, new String[0]);
        this.driver.setUp(builder);
        for (int expectedKey : expectedKeys) {
            this.driver.process(this.topicName, expectedKey, Integer.toString(expectedKey));
        }
        Object[] expected = new String[]{"1:2", "10:12", "100:103", "1000:1004"};
        Assert.assertArrayEquals((Object[])expected, (Object[])processor.processed.toArray());
    }
}

