/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class KStreamTransformTest {
    private String topicName = "topic";
    private final Serde<Integer> intSerde = Serdes.Integer();
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();

    @Test
    public void testTransform() {
        StreamsBuilder builder = new StreamsBuilder();
        TransformerSupplier<Number, Number, KeyValue<Integer, Integer>> transformerSupplier = new TransformerSupplier<Number, Number, KeyValue<Integer, Integer>>(){

            @Override
            public Transformer<Number, Number, KeyValue<Integer, Integer>> get() {
                return new Transformer<Number, Number, KeyValue<Integer, Integer>>(){
                    private int total = 0;

                    @Override
                    public void init(ProcessorContext context) {
                    }

                    @Override
                    public KeyValue<Integer, Integer> transform(Number key, Number value) {
                        this.total += value.intValue();
                        return KeyValue.pair(key.intValue() * 2, this.total);
                    }

                    @Override
                    public KeyValue<Integer, Integer> punctuate(long timestamp) {
                        return KeyValue.pair(-1, (int)timestamp);
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream<Integer, Integer> stream = builder.stream(this.topicName, Consumed.with(this.intSerde, this.intSerde));
        stream.transform(transformerSupplier, new String[0]).process(processor, new String[0]);
        this.driver.setUp(builder);
        for (int expectedKey : expectedKeys) {
            this.driver.process(this.topicName, expectedKey, expectedKey * 10);
        }
        this.driver.punctuate(2L);
        this.driver.punctuate(3L);
        Assert.assertEquals((long)6L, (long)processor.processed.size());
        String[] expected = new String[]{"2:10", "20:110", "200:1110", "2000:11110", "-1:2", "-1:3"};
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)processor.processed.get(i));
        }
    }
}

