/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.ValueTransformer;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.kstream.internals.InternalValueTransformerWithKey;
import org.apache.kafka.streams.kstream.internals.InternalValueTransformerWithKeySupplier;
import org.apache.kafka.streams.kstream.internals.KStreamTransformValues;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class KStreamTransformValuesTest {
    private String topicName = "topic";
    private final Serde<Integer> intSerde = Serdes.Integer();
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();

    @Test
    public void testTransform() {
        StreamsBuilder builder = new StreamsBuilder();
        ValueTransformerSupplier<Number, Integer> valueTransformerSupplier = new ValueTransformerSupplier<Number, Integer>(){

            @Override
            public ValueTransformer<Number, Integer> get() {
                return new ValueTransformer<Number, Integer>(){
                    private int total = 0;

                    @Override
                    public void init(ProcessorContext context) {
                    }

                    @Override
                    public Integer transform(Number value) {
                        this.total += value.intValue();
                        return this.total;
                    }

                    @Override
                    public Integer punctuate(long timestamp) {
                        return null;
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream<Integer, Integer> stream = builder.stream(this.topicName, Consumed.with(this.intSerde, this.intSerde));
        stream.transformValues(valueTransformerSupplier, new String[0]).process(processor, new String[0]);
        this.driver.setUp(builder);
        for (int expectedKey : expectedKeys) {
            this.driver.process(this.topicName, expectedKey, expectedKey * 10);
        }
        Object[] expected = new String[]{"1:10", "10:110", "100:1110", "1000:11110"};
        Assert.assertArrayEquals((Object[])expected, (Object[])processor.processed.toArray());
    }

    @Test
    public void testTransformWithKey() {
        StreamsBuilder builder = new StreamsBuilder();
        ValueTransformerWithKeySupplier<Integer, Number, Integer> valueTransformerSupplier = new ValueTransformerWithKeySupplier<Integer, Number, Integer>(){

            @Override
            public ValueTransformerWithKey<Integer, Number, Integer> get() {
                return new ValueTransformerWithKey<Integer, Number, Integer>(){
                    private int total = 0;

                    @Override
                    public void init(ProcessorContext context) {
                    }

                    @Override
                    public Integer transform(Integer readOnlyKey, Number value) {
                        this.total += value.intValue() + readOnlyKey;
                        return this.total;
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream<Integer, Integer> stream = builder.stream(this.topicName, Consumed.with(this.intSerde, this.intSerde));
        stream.transformValues(valueTransformerSupplier, new String[0]).process(processor, new String[0]);
        this.driver.setUp(builder);
        for (int expectedKey : expectedKeys) {
            this.driver.process(this.topicName, expectedKey, expectedKey * 10);
        }
        Object[] expected = new String[]{"1:11", "10:121", "100:1221", "1000:12221"};
        Assert.assertArrayEquals((Object[])expected, (Object[])processor.processed.toArray());
    }

    @Test
    public void shouldNotAllowValueTransformerToCallInternalProcessorContextMethods() {
        final BadValueTransformer badValueTransformer = new BadValueTransformer();
        KStreamTransformValues<Integer, Integer, Integer> transformValue = new KStreamTransformValues<Integer, Integer, Integer>(new InternalValueTransformerWithKeySupplier<Integer, Integer, Integer>(){

            @Override
            public InternalValueTransformerWithKey<Integer, Integer, Integer> get() {
                return new InternalValueTransformerWithKey<Integer, Integer, Integer>(){

                    @Override
                    public Integer punctuate(long timestamp) {
                        throw new StreamsException("ValueTransformerWithKey#punctuate should not be called.");
                    }

                    @Override
                    public void init(ProcessorContext context) {
                        badValueTransformer.init(context);
                    }

                    @Override
                    public Integer transform(Integer readOnlyKey, Integer value) {
                        return badValueTransformer.transform(readOnlyKey, value);
                    }

                    @Override
                    public void close() {
                        badValueTransformer.close();
                    }
                };
            }
        });
        Processor<Integer, Integer> transformValueProcessor = transformValue.get();
        transformValueProcessor.init(null);
        try {
            transformValueProcessor.process(null, 0);
            Assert.fail((String)"should not allow call to context.forward() within ValueTransformer");
        }
        catch (StreamsException streamsException) {
            // empty catch block
        }
        try {
            transformValueProcessor.process(null, 1);
            Assert.fail((String)"should not allow call to context.forward() within ValueTransformer");
        }
        catch (StreamsException streamsException) {
            // empty catch block
        }
        try {
            transformValueProcessor.process(null, 2);
            Assert.fail((String)"should not allow call to context.forward() within ValueTransformer");
        }
        catch (StreamsException streamsException) {
            // empty catch block
        }
        try {
            transformValueProcessor.punctuate(0L);
            Assert.fail((String)"should not allow ValueTransformer#puntuate() to return not-null value");
        }
        catch (StreamsException streamsException) {
            // empty catch block
        }
    }

    private static final class BadValueTransformer
    implements ValueTransformerWithKey<Integer, Integer, Integer> {
        private ProcessorContext context;

        private BadValueTransformer() {
        }

        @Override
        public void init(ProcessorContext context) {
            this.context = context;
        }

        @Override
        public Integer transform(Integer key, Integer value) {
            if (value == 0) {
                this.context.forward(null, null);
            }
            if (value == 1) {
                this.context.forward(null, null, null);
            }
            if (value == 2) {
                this.context.forward(null, null, 0);
            }
            throw new RuntimeException("Should never happen in this test");
        }

        @Override
        public void close() {
        }
    }
}

