/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@Deprecated
public class KTableForeachTest {
    private final String topicName = "topic";
    private File stateDir = null;
    private final Serde<Integer> intSerde = Serdes.Integer();
    private final Serde<String> stringSerde = Serdes.String();
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();

    @Before
    public void setUp() {
        this.stateDir = TestUtils.tempDirectory((String)"kafka-test");
    }

    @Test
    public void testForeach() {
        List<KeyValue> inputRecords = Arrays.asList(new KeyValue<Integer, String>(0, "zero"), new KeyValue<Integer, String>(1, "one"), new KeyValue<Integer, String>(2, "two"), new KeyValue<Integer, String>(3, "three"));
        List<KeyValue> expectedRecords = Arrays.asList(new KeyValue<Integer, String>(0, "ZERO"), new KeyValue<Integer, String>(2, "ONE"), new KeyValue<Integer, String>(4, "TWO"), new KeyValue<Integer, String>(6, "THREE"));
        final ArrayList actualRecords = new ArrayList();
        ForeachAction<Integer, String> action = new ForeachAction<Integer, String>(){

            @Override
            public void apply(Integer key, String value) {
                actualRecords.add(new KeyValue<Integer, String>(key * 2, value.toUpperCase(Locale.ROOT)));
            }
        };
        StreamsBuilder builder = new StreamsBuilder();
        KTable<Integer, String> table = builder.table("topic", Consumed.with(this.intSerde, this.stringSerde), Materialized.as("topic").withKeySerde(this.intSerde).withValueSerde(this.stringSerde));
        table.foreach(action);
        this.driver.setUp(builder, this.stateDir);
        for (KeyValue record : inputRecords) {
            this.driver.process("topic", record.key, record.value);
        }
        this.driver.flushState();
        Assert.assertEquals((long)expectedRecords.size(), (long)actualRecords.size());
        for (int i = 0; i < expectedRecords.size(); ++i) {
            KeyValue expectedRecord = expectedRecords.get(i);
            KeyValue actualRecord = (KeyValue)actualRecords.get(i);
            Assert.assertEquals((Object)expectedRecord, (Object)actualRecord);
        }
    }

    @Test
    public void testTypeVariance() {
        ForeachAction<Number, Object> consume = new ForeachAction<Number, Object>(){

            @Override
            public void apply(Number key, Object value) {
            }
        };
        new StreamsBuilder().table("emptyTopic").foreach(consume);
    }
}

