/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.StreamsBuilderTest;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.MockValueJoiner;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class KTableKTableInnerJoinTest {
    private final String topic1 = "topic1";
    private final String topic2 = "topic2";
    private final Serde<Integer> intSerde = Serdes.Integer();
    private final Serde<String> stringSerde = Serdes.String();
    private final Consumed<Integer, String> consumed = Consumed.with(this.intSerde, this.stringSerde);
    private File stateDir = null;
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();

    @Before
    public void setUp() {
        this.stateDir = TestUtils.tempDirectory((String)"kafka-test");
    }

    private void doTestJoin(StreamsBuilder builder, int[] expectedKeys, MockProcessorSupplier<Integer, String> processor, KTable<Integer, String> joined) {
        int i;
        Collection<Set<String>> copartitionGroups = StreamsBuilderTest.getCopartitionedGroups(builder);
        Assert.assertEquals((long)1L, (long)copartitionGroups.size());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("topic1", "topic2")), copartitionGroups.iterator().next());
        KTableValueGetterSupplier getterSupplier = ((KTableImpl)joined).valueGetterSupplier();
        this.driver.setUp(builder, this.stateDir, Serdes.Integer(), Serdes.String());
        this.driver.setTime(0L);
        KTableValueGetter<Integer, String> getter2 = getterSupplier.get();
        getter2.init(this.driver.context());
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic1", expectedKeys[i], "X" + expectedKeys[i]);
        }
        this.driver.process("topic1", null, "SomeVal");
        this.driver.flushState();
        processor.checkAndClearProcessResult(new String[0]);
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic2", expectedKeys[i], "Y" + expectedKeys[i]);
        }
        this.driver.process("topic2", null, "AnotherVal");
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:X0+Y0", "1:X1+Y1");
        this.checkJoinedValues(getter2, this.kv(0, "X0+Y0"), this.kv(1, "X1+Y1"));
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:XX0+Y0", "1:XX1+Y1");
        this.checkJoinedValues(getter2, this.kv(0, "XX0+Y0"), this.kv(1, "XX1+Y1"));
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic2", expectedKey, "YY" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:XX0+YY0", "1:XX1+YY1", "2:XX2+YY2", "3:XX3+YY3");
        this.checkJoinedValues(getter2, this.kv(0, "XX0+YY0"), this.kv(1, "XX1+YY1"), this.kv(2, "XX2+YY2"), this.kv(3, "XX3+YY3"));
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "X" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:X0+YY0", "1:X1+YY1", "2:X2+YY2", "3:X3+YY3");
        this.checkJoinedValues(getter2, this.kv(0, "X0+YY0"), this.kv(1, "X1+YY1"), this.kv(2, "X2+YY2"), this.kv(3, "X3+YY3"));
        for (int i2 = 0; i2 < 2; ++i2) {
            this.driver.process("topic2", expectedKeys[i2], null);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("0:null", "1:null");
        this.checkJoinedValues(getter2, this.kv(0, null), this.kv(1, null));
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        this.driver.flushState();
        processor.checkAndClearProcessResult("2:XX2+YY2", "3:XX3+YY3");
        this.checkJoinedValues(getter2, this.kv(2, "XX2+YY2"), this.kv(3, "XX3+YY3"));
        this.driver.process("topic1", null, "XX1");
        this.checkJoinedValues(getter2, this.kv(2, "XX2+YY2"), this.kv(3, "XX3+YY3"));
    }

    @Test
    public void testJoin() {
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        MockProcessorSupplier<Integer, String> processor = new MockProcessorSupplier<Integer, String>();
        KTable<Integer, String> table1 = builder.table("topic1", this.consumed);
        KTable<Integer, String> table2 = builder.table("topic2", this.consumed);
        KTable<Integer, String> joined = table1.join(table2, MockValueJoiner.TOSTRING_JOINER);
        joined.toStream().process(processor, new String[0]);
        this.doTestJoin(builder, expectedKeys, processor, joined);
    }

    @Test
    public void testQueryableJoin() {
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        MockProcessorSupplier<Integer, String> processor = new MockProcessorSupplier<Integer, String>();
        KTable<Integer, String> table1 = builder.table("topic1", this.consumed);
        KTable<Integer, String> table2 = builder.table("topic2", this.consumed);
        KTable<Integer, String> joined = table1.join(table2, MockValueJoiner.TOSTRING_JOINER, Serdes.String(), "anyQueryableName");
        joined.toStream().process(processor, new String[0]);
        this.doTestJoin(builder, expectedKeys, processor, joined);
    }

    private void doTestSendingOldValues(StreamsBuilder builder, int[] expectedKeys, KTable<Integer, String> table1, KTable<Integer, String> table2, MockProcessorSupplier<Integer, String> proc, KTable<Integer, String> joined, boolean sendOldValues) {
        int i;
        this.driver.setUp(builder, this.stateDir, Serdes.Integer(), Serdes.String());
        this.driver.setTime(0L);
        if (!sendOldValues) {
            Assert.assertFalse((boolean)((KTableImpl)table1).sendingOldValueEnabled());
            Assert.assertFalse((boolean)((KTableImpl)table2).sendingOldValueEnabled());
            Assert.assertFalse((boolean)((KTableImpl)joined).sendingOldValueEnabled());
        } else {
            ((KTableImpl)joined).enableSendingOldValues();
            Assert.assertTrue((boolean)((KTableImpl)table1).sendingOldValueEnabled());
            Assert.assertTrue((boolean)((KTableImpl)table2).sendingOldValueEnabled());
            Assert.assertTrue((boolean)((KTableImpl)joined).sendingOldValueEnabled());
        }
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic1", expectedKeys[i], "X" + expectedKeys[i]);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult(new String[0]);
        for (i = 0; i < 2; ++i) {
            this.driver.process("topic2", expectedKeys[i], "Y" + expectedKeys[i]);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+Y0<-null)", "1:(X1+Y1<-null)");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(XX0+Y0<-null)", "1:(XX1+Y1<-null)");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic2", expectedKey, "YY" + expectedKey);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(XX0+YY0<-null)", "1:(XX1+YY1<-null)", "2:(XX2+YY2<-null)", "3:(XX3+YY3<-null)");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "X" + expectedKey);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(X0+YY0<-null)", "1:(X1+YY1<-null)", "2:(X2+YY2<-null)", "3:(X3+YY3<-null)");
        for (int i2 = 0; i2 < 2; ++i2) {
            this.driver.process("topic2", expectedKeys[i2], null);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("0:(null<-null)", "1:(null<-null)");
        for (int expectedKey : expectedKeys) {
            this.driver.process("topic1", expectedKey, "XX" + expectedKey);
        }
        this.driver.flushState();
        proc.checkAndClearProcessResult("2:(XX2+YY2<-null)", "3:(XX3+YY3<-null)");
    }

    @Test
    public void testNotSendingOldValues() {
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        KTable<Integer, String> table1 = builder.table("topic1", this.consumed);
        KTable<Integer, String> table2 = builder.table("topic2", this.consumed);
        KTable<Integer, String> joined = table1.join(table2, MockValueJoiner.TOSTRING_JOINER);
        MockProcessorSupplier<Integer, String> proc = new MockProcessorSupplier<Integer, String>();
        builder.build().addProcessor("proc", proc, ((KTableImpl)joined).name);
        this.doTestSendingOldValues(builder, expectedKeys, table1, table2, proc, joined, false);
    }

    @Test
    public void testQueryableNotSendingOldValues() {
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        KTable<Integer, String> table1 = builder.table("topic1", this.consumed);
        KTable<Integer, String> table2 = builder.table("topic2", this.consumed);
        KTable<Integer, String> joined = table1.join(table2, MockValueJoiner.TOSTRING_JOINER, Serdes.String(), "anyQueryableName");
        MockProcessorSupplier<Integer, String> proc = new MockProcessorSupplier<Integer, String>();
        builder.build().addProcessor("proc", proc, ((KTableImpl)joined).name);
        this.doTestSendingOldValues(builder, expectedKeys, table1, table2, proc, joined, false);
    }

    @Test
    public void testSendingOldValues() {
        StreamsBuilder builder = new StreamsBuilder();
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        KTable<Integer, String> table1 = builder.table("topic1", this.consumed);
        KTable<Integer, String> table2 = builder.table("topic2", this.consumed);
        KTable<Integer, String> joined = table1.join(table2, MockValueJoiner.TOSTRING_JOINER);
        MockProcessorSupplier<Integer, String> proc = new MockProcessorSupplier<Integer, String>();
        builder.build().addProcessor("proc", proc, ((KTableImpl)joined).name);
        this.doTestSendingOldValues(builder, expectedKeys, table1, table2, proc, joined, true);
    }

    private KeyValue<Integer, String> kv(Integer key, String value) {
        return new KeyValue<Integer, String>(key, value);
    }

    private void checkJoinedValues(KTableValueGetter<Integer, String> getter2, KeyValue<Integer, String> ... expected) {
        for (KeyValue<Integer, String> kv : expected) {
            String value = getter2.get((Integer)kv.key);
            if (kv.value == null) {
                Assert.assertNull((Object)value);
                continue;
            }
            Assert.assertEquals(kv.value, (Object)value);
        }
    }
}

