/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.io.File;
import java.util.HashMap;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class KTableMapKeysTest {
    private final Serde<String> stringSerde = new Serdes.StringSerde();
    private final Serde<Integer> integerSerde = new Serdes.IntegerSerde();
    private File stateDir = null;
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();

    @Before
    public void setUp() {
        this.stateDir = TestUtils.tempDirectory((String)"kafka-test");
    }

    @Test
    public void testMapKeysConvertingToStream() {
        int i;
        StreamsBuilder builder = new StreamsBuilder();
        String topic1 = "topic_map_keys";
        KTable<Integer, String> table1 = builder.table(topic1, Consumed.with(this.integerSerde, this.stringSerde));
        final HashMap<Integer, String> keyMap = new HashMap<Integer, String>();
        keyMap.put(1, "ONE");
        keyMap.put(2, "TWO");
        keyMap.put(3, "THREE");
        KeyValueMapper<Integer, String, String> keyMapper = new KeyValueMapper<Integer, String, String>(){

            @Override
            public String apply(Integer key, String value) {
                return (String)keyMap.get(key);
            }
        };
        KStream<String, String> convertedStream = table1.toStream(keyMapper);
        String[] expected = new String[]{"ONE:V_ONE", "TWO:V_TWO", "THREE:V_THREE"};
        int[] originalKeys = new int[]{1, 2, 3};
        String[] values = new String[]{"V_ONE", "V_TWO", "V_THREE"};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        convertedStream.process(processor, new String[0]);
        this.driver.setUp(builder, this.stateDir);
        for (i = 0; i < originalKeys.length; ++i) {
            this.driver.process(topic1, originalKeys[i], values[i]);
        }
        this.driver.flushState();
        Assert.assertEquals((long)3L, (long)processor.processed.size());
        for (i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)processor.processed.get(i));
        }
    }
}

