/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;

public class SessionKeySerde<K>
implements Serde<Windowed<K>> {
    private static final int TIMESTAMP_SIZE = 8;
    private final Serde<K> keySerde;

    public SessionKeySerde(Serde<K> keySerde) {
        this.keySerde = keySerde;
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public void close() {
    }

    @Override
    public Serializer<Windowed<K>> serializer() {
        return new SessionKeySerializer(this.keySerde.serializer());
    }

    @Override
    public Deserializer<Windowed<K>> deserializer() {
        return new SessionKeyDeserializer(this.keySerde.deserializer());
    }

    public static long extractEnd(byte[] binaryKey) {
        return ByteBuffer.wrap(binaryKey).getLong(binaryKey.length - 16);
    }

    public static long extractStart(byte[] binaryKey) {
        return ByteBuffer.wrap(binaryKey).getLong(binaryKey.length - 8);
    }

    public static Window extractWindow(byte[] binaryKey) {
        ByteBuffer buffer = ByteBuffer.wrap(binaryKey);
        long start = buffer.getLong(binaryKey.length - 8);
        long end = buffer.getLong(binaryKey.length - 16);
        return new SessionWindow(start, end);
    }

    public static byte[] extractKeyBytes(byte[] binaryKey) {
        byte[] bytes = new byte[binaryKey.length - 16];
        System.arraycopy(binaryKey, 0, bytes, 0, bytes.length);
        return bytes;
    }

    public static <K> Windowed<K> from(byte[] binaryKey, Deserializer<K> keyDeserializer, String topic) {
        K key = SessionKeySerde.extractKey(binaryKey, keyDeserializer, topic);
        Window window = SessionKeySerde.extractWindow(binaryKey);
        return new Windowed<K>(key, window);
    }

    public static Windowed<Bytes> fromBytes(Bytes bytesKey) {
        byte[] binaryKey = bytesKey.get();
        ByteBuffer buffer = ByteBuffer.wrap(binaryKey);
        long start = buffer.getLong(binaryKey.length - 8);
        long end = buffer.getLong(binaryKey.length - 16);
        return new Windowed<Bytes>(Bytes.wrap(SessionKeySerde.extractKeyBytes(binaryKey)), new SessionWindow(start, end));
    }

    private static <K> K extractKey(byte[] binaryKey, Deserializer<K> deserializer, String topic) {
        return deserializer.deserialize(topic, SessionKeySerde.extractKeyBytes(binaryKey));
    }

    public static <K> Bytes toBinary(Windowed<K> sessionKey, Serializer<K> serializer, String topic) {
        byte[] bytes = serializer.serialize(topic, sessionKey.key());
        ByteBuffer buf = ByteBuffer.allocate(bytes.length + 16);
        buf.put(bytes);
        buf.putLong(sessionKey.window().end());
        buf.putLong(sessionKey.window().start());
        return new Bytes(buf.array());
    }

    public static Bytes bytesToBinary(Windowed<Bytes> sessionKey) {
        byte[] bytes = sessionKey.key().get();
        ByteBuffer buf = ByteBuffer.allocate(bytes.length + 16);
        buf.put(bytes);
        buf.putLong(sessionKey.window().end());
        buf.putLong(sessionKey.window().start());
        return new Bytes(buf.array());
    }

    private class SessionKeyDeserializer
    implements Deserializer<Windowed<K>> {
        private final Deserializer<K> deserializer;

        SessionKeyDeserializer(Deserializer<K> deserializer) {
            this.deserializer = deserializer;
        }

        @Override
        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        @Override
        public Windowed<K> deserialize(String topic, byte[] data) {
            if (data == null || data.length == 0) {
                return null;
            }
            return SessionKeySerde.from(data, this.deserializer, topic);
        }

        @Override
        public void close() {
        }
    }

    private class SessionKeySerializer
    implements Serializer<Windowed<K>> {
        private final Serializer<K> keySerializer;

        SessionKeySerializer(Serializer<K> keySerializer) {
            this.keySerializer = keySerializer;
        }

        @Override
        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        @Override
        public byte[] serialize(String topic, Windowed<K> data) {
            if (data == null) {
                return null;
            }
            return SessionKeySerde.toBinary(data, this.keySerializer, topic).get();
        }

        @Override
        public void close() {
        }
    }
}

