/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionKeySerde;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.junit.Assert;
import org.junit.Test;

public class SessionKeySerdeTest {
    private final String topic = "topic";
    private final String key = "key";
    private final long startTime = 50L;
    private final long endTime = 100L;
    private final Window window = new SessionWindow(50L, 100L);
    private final Windowed<String> windowedKey = new Windowed<String>("key", this.window);
    private final Serde<String> serde = Serdes.String();
    private final SessionKeySerde<String> sessionKeySerde = new SessionKeySerde<String>(this.serde);

    @Test
    public void shouldSerializeDeserialize() {
        byte[] bytes = this.sessionKeySerde.serializer().serialize("topic", this.windowedKey);
        Windowed<String> result2 = this.sessionKeySerde.deserializer().deserialize("topic", bytes);
        Assert.assertEquals(this.windowedKey, result2);
    }

    @Test
    public void shouldSerializeNullToNull() {
        Assert.assertNull((Object)this.sessionKeySerde.serializer().serialize("topic", null));
    }

    @Test
    public void shouldDeSerializeEmtpyByteArrayToNull() {
        Assert.assertNull(this.sessionKeySerde.deserializer().deserialize("topic", new byte[0]));
    }

    @Test
    public void shouldDeSerializeNullToNull() {
        Assert.assertNull(this.sessionKeySerde.deserializer().deserialize("topic", null));
    }

    @Test
    public void shouldConvertToBinaryAndBack() {
        Bytes serialized = SessionKeySerde.toBinary(this.windowedKey, this.serde.serializer(), "dummy");
        Windowed<String> result2 = SessionKeySerde.from(serialized.get(), Serdes.String().deserializer(), "dummy");
        Assert.assertEquals(this.windowedKey, result2);
    }

    @Test
    public void shouldExtractEndTimeFromBinary() {
        Bytes serialized = SessionKeySerde.toBinary(this.windowedKey, this.serde.serializer(), "dummy");
        Assert.assertEquals((long)100L, (long)SessionKeySerde.extractEnd(serialized.get()));
    }

    @Test
    public void shouldExtractStartTimeFromBinary() {
        Bytes serialized = SessionKeySerde.toBinary(this.windowedKey, this.serde.serializer(), "dummy");
        Assert.assertEquals((long)50L, (long)SessionKeySerde.extractStart(serialized.get()));
    }

    @Test
    public void shouldExtractWindowFromBindary() {
        Bytes serialized = SessionKeySerde.toBinary(this.windowedKey, this.serde.serializer(), "dummy");
        Assert.assertEquals((Object)this.window, (Object)SessionKeySerde.extractWindow(serialized.get()));
    }

    @Test
    public void shouldExtractKeyBytesFromBinary() {
        Bytes serialized = SessionKeySerde.toBinary(this.windowedKey, this.serde.serializer(), "dummy");
        Assert.assertArrayEquals((byte[])"key".getBytes(), (byte[])SessionKeySerde.extractKeyBytes(serialized.get()));
    }

    @Test
    public void shouldExtractKeyFromBinary() {
        Bytes serialized = SessionKeySerde.toBinary(this.windowedKey, this.serde.serializer(), "dummy");
        Assert.assertEquals(this.windowedKey, SessionKeySerde.from(serialized.get(), this.serde.deserializer(), "dummy"));
    }

    @Test
    public void shouldExtractBytesKeyFromBinary() {
        Bytes bytesKey = Bytes.wrap("key".getBytes());
        Windowed<Bytes> windowedBytesKey = new Windowed<Bytes>(bytesKey, this.window);
        Bytes serialized = SessionKeySerde.bytesToBinary(windowedBytesKey);
        Assert.assertEquals(windowedBytesKey, SessionKeySerde.fromBytes(serialized));
    }
}

