/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Merger;
import org.apache.kafka.streams.kstream.Serialized;
import org.apache.kafka.streams.kstream.SessionWindowedKStream;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.test.KStreamTestDriver;
import org.apache.kafka.test.MockAggregator;
import org.apache.kafka.test.MockInitializer;
import org.apache.kafka.test.MockReducer;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SessionWindowedKStreamImplTest {
    private static final String TOPIC = "input";
    private final StreamsBuilder builder = new StreamsBuilder();
    @Rule
    public final KStreamTestDriver driver = new KStreamTestDriver();
    private final Merger<String, String> sessionMerger = new Merger<String, String>(){

        @Override
        public String apply(String aggKey, String aggOne, String aggTwo) {
            return aggOne + "+" + aggTwo;
        }
    };
    private SessionWindowedKStream<String, String> stream;

    @Before
    public void before() {
        KStream<String, String> stream = this.builder.stream(TOPIC, Consumed.with(Serdes.String(), Serdes.String()));
        this.stream = stream.groupByKey(Serialized.with(Serdes.String(), Serdes.String())).windowedBy(SessionWindows.with(500L));
    }

    @Test
    public void shouldCountSessionWindowed() {
        final HashMap results = new HashMap();
        this.stream.count().toStream().foreach(new ForeachAction<Windowed<String>, Long>(){

            @Override
            public void apply(Windowed<String> key, Long value) {
                results.put(key, value);
            }
        });
        this.processData();
        MatcherAssert.assertThat(results.get(new Windowed<String>("1", new SessionWindow(10L, 15L))), (Matcher)CoreMatchers.equalTo((Object)2L));
        MatcherAssert.assertThat(results.get(new Windowed<String>("2", new SessionWindow(600L, 600L))), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat(results.get(new Windowed<String>("1", new SessionWindow(600L, 600L))), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldReduceWindowed() {
        final HashMap results = new HashMap();
        this.stream.reduce(MockReducer.STRING_ADDER).toStream().foreach(new ForeachAction<Windowed<String>, String>(){

            @Override
            public void apply(Windowed<String> key, String value) {
                results.put(key, value);
            }
        });
        this.processData();
        MatcherAssert.assertThat(results.get(new Windowed<String>("1", new SessionWindow(10L, 15L))), (Matcher)CoreMatchers.equalTo((Object)"1+2"));
        MatcherAssert.assertThat(results.get(new Windowed<String>("2", new SessionWindow(600L, 600L))), (Matcher)CoreMatchers.equalTo((Object)"1"));
        MatcherAssert.assertThat(results.get(new Windowed<String>("1", new SessionWindow(600L, 600L))), (Matcher)CoreMatchers.equalTo((Object)"3"));
    }

    @Test
    public void shouldAggregateSessionWindowed() {
        final HashMap results = new HashMap();
        this.stream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, this.sessionMerger).toStream().foreach(new ForeachAction<Windowed<String>, String>(){

            @Override
            public void apply(Windowed<String> key, String value) {
                results.put(key, value);
            }
        });
        this.processData();
        MatcherAssert.assertThat(results.get(new Windowed<String>("1", new SessionWindow(10L, 15L))), (Matcher)CoreMatchers.equalTo((Object)"0+0+1+2"));
        MatcherAssert.assertThat(results.get(new Windowed<String>("2", new SessionWindow(600L, 600L))), (Matcher)CoreMatchers.equalTo((Object)"0+1"));
        MatcherAssert.assertThat(results.get(new Windowed<String>("1", new SessionWindow(600L, 600L))), (Matcher)CoreMatchers.equalTo((Object)"0+3"));
    }

    @Test
    public void shouldMaterializeCount() {
        this.stream.count(Materialized.as("count-store").withKeySerde(Serdes.String()));
        this.processData();
        SessionStore store = (SessionStore)this.driver.allStateStores().get("count-store");
        List data = StreamsTestUtils.toList(store.fetch("1", "2"));
        MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair(new Windowed<String>("1", new SessionWindow(10L, 15L)), 2L), KeyValue.pair(new Windowed<String>("1", new SessionWindow(600L, 600L)), 1L), KeyValue.pair(new Windowed<String>("2", new SessionWindow(600L, 600L)), 1L))));
    }

    @Test
    public void shouldMaterializeWithoutSpecifyingSerdes() {
        this.stream.count(Materialized.as("count-store"));
        this.processData();
        SessionStore store = (SessionStore)this.driver.allStateStores().get("count-store");
        List data = StreamsTestUtils.toList(store.fetch("1", "2"));
        MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair(new Windowed<String>("1", new SessionWindow(10L, 15L)), 2L), KeyValue.pair(new Windowed<String>("1", new SessionWindow(600L, 600L)), 1L), KeyValue.pair(new Windowed<String>("2", new SessionWindow(600L, 600L)), 1L))));
    }

    @Test
    public void shouldMaterializeReduced() {
        this.stream.reduce(MockReducer.STRING_ADDER, Materialized.as("reduced").withKeySerde(Serdes.String()).withValueSerde(Serdes.String()));
        this.processData();
        SessionStore sessionStore = (SessionStore)this.driver.allStateStores().get("reduced");
        List data = StreamsTestUtils.toList(sessionStore.fetch("1", "2"));
        MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair(new Windowed<String>("1", new SessionWindow(10L, 15L)), "1+2"), KeyValue.pair(new Windowed<String>("1", new SessionWindow(600L, 600L)), "3"), KeyValue.pair(new Windowed<String>("2", new SessionWindow(600L, 600L)), "1"))));
    }

    @Test
    public void shouldMaterializeAggregated() {
        this.stream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, this.sessionMerger, Materialized.as("aggregated").withKeySerde(Serdes.String()).withValueSerde(Serdes.String()));
        this.processData();
        SessionStore sessionStore = (SessionStore)this.driver.allStateStores().get("aggregated");
        List data = StreamsTestUtils.toList(sessionStore.fetch("1", "2"));
        MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair(new Windowed<String>("1", new SessionWindow(10L, 15L)), "0+0+1+2"), KeyValue.pair(new Windowed<String>("1", new SessionWindow(600L, 600L)), "0+3"), KeyValue.pair(new Windowed<String>("2", new SessionWindow(600L, 600L)), "0+1"))));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnAggregateIfInitializerIsNull() {
        this.stream.aggregate(null, MockAggregator.TOSTRING_ADDER, this.sessionMerger);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnAggregateIfAggregatorIsNull() {
        this.stream.aggregate(MockInitializer.STRING_INIT, null, this.sessionMerger);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnAggregateIfMergerIsNull() {
        this.stream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnReduceIfReducerIsNull() {
        this.stream.reduce(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnMaterializedAggregateIfInitializerIsNull() {
        this.stream.aggregate(null, MockAggregator.TOSTRING_ADDER, this.sessionMerger, Materialized.as("store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnMaterializedAggregateIfAggregatorIsNull() {
        this.stream.aggregate(MockInitializer.STRING_INIT, null, this.sessionMerger, Materialized.as("store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnMaterializedAggregateIfMergerIsNull() {
        this.stream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, null, Materialized.as("store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnMaterializedAggregateIfMaterializedIsNull() {
        this.stream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, this.sessionMerger, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnMaterializedReduceIfReducerIsNull() {
        this.stream.reduce(null, Materialized.as("store"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnMaterializedReduceIfMaterializedIsNull() {
        this.stream.reduce(MockReducer.STRING_ADDER, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnCountIfMaterializedIsNull() {
        this.stream.count(null);
    }

    private void processData() {
        this.driver.setUp(this.builder, TestUtils.tempDirectory(), 0L);
        this.driver.setTime(10L);
        this.driver.process(TOPIC, "1", "1");
        this.driver.setTime(15L);
        this.driver.process(TOPIC, "1", "2");
        this.driver.setTime(600L);
        this.driver.process(TOPIC, "1", "3");
        this.driver.process(TOPIC, "2", "1");
        this.driver.flushState();
    }
}

