/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.junit.Assert;
import org.junit.Test;

public class TimeWindowTest {
    private long start = 50L;
    private long end = 100L;
    private final TimeWindow window = new TimeWindow(this.start, this.end);
    private final SessionWindow sessionWindow = new SessionWindow(this.start, this.end);

    @Test(expected=IllegalArgumentException.class)
    public void endMustBeLargerThanStart() {
        new TimeWindow(this.start, this.start);
    }

    @Test
    public void shouldNotOverlapIfOtherWindowIsBeforeThisWindow() {
        Assert.assertFalse((boolean)this.window.overlap(new TimeWindow(0L, 25L)));
        Assert.assertFalse((boolean)this.window.overlap(new TimeWindow(0L, this.start - 1L)));
        Assert.assertFalse((boolean)this.window.overlap(new TimeWindow(0L, this.start)));
    }

    @Test
    public void shouldOverlapIfOtherWindowEndIsWithinThisWindow() {
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(0L, this.start + 1L)));
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(0L, 75L)));
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(0L, this.end - 1L)));
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(this.start - 1L, this.start + 1L)));
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(this.start - 1L, 75L)));
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(this.start - 1L, this.end - 1L)));
    }

    @Test
    public void shouldOverlapIfOtherWindowContainsThisWindow() {
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(0L, this.end)));
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(0L, this.end + 1L)));
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(0L, 150L)));
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(this.start - 1L, this.end)));
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(this.start - 1L, this.end + 1L)));
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(this.start - 1L, 150L)));
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(this.start, this.end)));
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(this.start, this.end + 1L)));
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(this.start, 150L)));
    }

    @Test
    public void shouldOverlapIfOtherWindowIsWithinThisWindow() {
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(this.start, 75L)));
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(this.start, this.end)));
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(75L, this.end)));
    }

    @Test
    public void shouldOverlapIfOtherWindowStartIsWithinThisWindow() {
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(this.start, this.end + 1L)));
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(this.start, 150L)));
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(75L, this.end + 1L)));
        Assert.assertTrue((boolean)this.window.overlap(new TimeWindow(75L, 150L)));
    }

    @Test
    public void shouldNotOverlapIsOtherWindowIsAfterThisWindow() {
        Assert.assertFalse((boolean)this.window.overlap(new TimeWindow(this.end, this.end + 1L)));
        Assert.assertFalse((boolean)this.window.overlap(new TimeWindow(this.end, 150L)));
        Assert.assertFalse((boolean)this.window.overlap(new TimeWindow(this.end + 1L, 150L)));
        Assert.assertFalse((boolean)this.window.overlap(new TimeWindow(125L, 150L)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void cannotCompareTimeWindowWithDifferentWindowType() {
        this.window.overlap(this.sessionWindow);
    }
}

