/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.UnlimitedWindow;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;

public class WindowedDeserializer<T>
implements Deserializer<Windowed<T>> {
    private static final int TIMESTAMP_SIZE = 8;
    private final Long windowSize;
    private Deserializer<T> inner;

    public WindowedDeserializer() {
        this(null, Long.MAX_VALUE);
    }

    public WindowedDeserializer(Long windowSize) {
        this(null, windowSize);
    }

    public WindowedDeserializer(Deserializer<T> inner) {
        this(inner, Long.MAX_VALUE);
    }

    public WindowedDeserializer(Deserializer<T> inner, long windowSize) {
        this.inner = inner;
        this.windowSize = windowSize;
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        if (this.inner == null) {
            String propertyName = isKey ? "key.deserializer.inner.class" : "value.deserializer.inner.class";
            Object innerDeserializerClass = configs.get(propertyName);
            propertyName = innerDeserializerClass == null ? "deserializer.inner.class" : propertyName;
            String value = null;
            try {
                value = (String)configs.get(propertyName);
                this.inner = (Deserializer)Deserializer.class.cast(Utils.newInstance(value, Deserializer.class));
                this.inner.configure(configs, isKey);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException(propertyName, value, "Class " + value + " could not be found.");
            }
        }
    }

    @Override
    public Windowed<T> deserialize(String topic, byte[] data) {
        byte[] bytes = new byte[data.length - 8];
        System.arraycopy(data, 0, bytes, 0, bytes.length);
        long start = ByteBuffer.wrap(data).getLong(data.length - 8);
        Window timeWindow = this.windowSize != Long.MAX_VALUE ? WindowStoreUtils.timeWindowForSize(start, this.windowSize) : new UnlimitedWindow(start);
        return new Windowed<T>(this.inner.deserialize(topic, bytes), timeWindow);
    }

    @Override
    public void close() {
        this.inner.close();
    }

    public Deserializer<T> innerDeserializer() {
        return this.inner;
    }

    public Long getWindowSize() {
        return this.windowSize;
    }
}

