/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Windowed;

public class WindowedSerializer<T>
implements Serializer<Windowed<T>> {
    private static final int TIMESTAMP_SIZE = 8;
    private Serializer<T> inner;

    public WindowedSerializer(Serializer<T> inner) {
        this.inner = inner;
    }

    public WindowedSerializer() {
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        if (this.inner == null) {
            String propertyName = isKey ? "key.serializer.inner.class" : "value.serializer.inner.class";
            Object innerSerializerClass = configs.get(propertyName);
            propertyName = innerSerializerClass == null ? "serializer.inner.class" : propertyName;
            String value = null;
            try {
                value = (String)configs.get(propertyName);
                this.inner = (Serializer)Serializer.class.cast(Utils.newInstance(value, Serializer.class));
                this.inner.configure(configs, isKey);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException(propertyName, value, "Class " + value + " could not be found.");
            }
        }
    }

    @Override
    public byte[] serialize(String topic, Windowed<T> data) {
        byte[] serializedKey = this.inner.serialize(topic, data.key());
        ByteBuffer buf = ByteBuffer.allocate(serializedKey.length + 8);
        buf.put(serializedKey);
        buf.putLong(data.window().start());
        return buf.array();
    }

    @Override
    public void close() {
        this.inner.close();
    }

    byte[] serializeBaseKey(String topic, Windowed<T> data) {
        return this.inner.serialize(topic, data.key());
    }

    Serializer<T> innerSerializer() {
        return this.inner;
    }
}

