/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.TopologyBuilderException;
import org.apache.kafka.streams.processor.internals.RepartitionTopicConfig;
import org.apache.kafka.streams.processor.internals.StreamPartitionAssignor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class CopartitionedTopicsValidatorTest {
    private final StreamPartitionAssignor.CopartitionedTopicsValidator validator = new StreamPartitionAssignor.CopartitionedTopicsValidator("thread");
    private final Map<TopicPartition, PartitionInfo> partitions = new HashMap<TopicPartition, PartitionInfo>();
    private final Cluster cluster = Cluster.empty();

    @Before
    public void before() {
        this.partitions.put(new TopicPartition("first", 0), new PartitionInfo("first", 0, null, null, null));
        this.partitions.put(new TopicPartition("first", 1), new PartitionInfo("first", 1, null, null, null));
        this.partitions.put(new TopicPartition("second", 0), new PartitionInfo("second", 0, null, null, null));
        this.partitions.put(new TopicPartition("second", 1), new PartitionInfo("second", 1, null, null, null));
    }

    @Test(expected=TopologyBuilderException.class)
    public void shouldThrowTopologyBuilderExceptionIfNoPartitionsFoundForCoPartitionedTopic() {
        this.validator.validate(Collections.singleton("topic"), Collections.emptyMap(), this.cluster);
    }

    @Test(expected=TopologyBuilderException.class)
    public void shouldThrowTopologyBuilderExceptionIfPartitionCountsForCoPartitionedTopicsDontMatch() {
        this.partitions.remove(new TopicPartition("second", 0));
        this.validator.validate(Utils.mkSet("first", "second"), Collections.emptyMap(), this.cluster.withPartitions(this.partitions));
    }

    @Test
    public void shouldEnforceCopartitioningOnRepartitionTopics() {
        StreamPartitionAssignor.InternalTopicMetadata metadata = this.createTopicMetadata("repartitioned", 10);
        this.validator.validate(Utils.mkSet("first", "second", metadata.config.name()), Collections.singletonMap(metadata.config.name(), metadata), this.cluster.withPartitions(this.partitions));
        MatcherAssert.assertThat((Object)metadata.numPartitions, (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void shouldSetNumPartitionsToMaximumPartitionsWhenAllTopicsAreRepartitionTopics() {
        StreamPartitionAssignor.InternalTopicMetadata one = this.createTopicMetadata("one", 1);
        StreamPartitionAssignor.InternalTopicMetadata two = this.createTopicMetadata("two", 15);
        StreamPartitionAssignor.InternalTopicMetadata three = this.createTopicMetadata("three", 5);
        HashMap<String, StreamPartitionAssignor.InternalTopicMetadata> repartitionTopicConfig = new HashMap<String, StreamPartitionAssignor.InternalTopicMetadata>();
        repartitionTopicConfig.put(one.config.name(), one);
        repartitionTopicConfig.put(two.config.name(), two);
        repartitionTopicConfig.put(three.config.name(), three);
        this.validator.validate(Utils.mkSet(one.config.name(), two.config.name(), three.config.name()), repartitionTopicConfig, this.cluster);
        MatcherAssert.assertThat((Object)one.numPartitions, (Matcher)CoreMatchers.equalTo((Object)15));
        MatcherAssert.assertThat((Object)two.numPartitions, (Matcher)CoreMatchers.equalTo((Object)15));
        MatcherAssert.assertThat((Object)three.numPartitions, (Matcher)CoreMatchers.equalTo((Object)15));
    }

    @Test
    public void shouldSetRepartitionTopicsPartitionCountToNotAvailableIfAnyNotAvaliable() {
        StreamPartitionAssignor.InternalTopicMetadata one = this.createTopicMetadata("one", 1);
        StreamPartitionAssignor.InternalTopicMetadata two = this.createTopicMetadata("two", -2);
        HashMap<String, StreamPartitionAssignor.InternalTopicMetadata> repartitionTopicConfig = new HashMap<String, StreamPartitionAssignor.InternalTopicMetadata>();
        repartitionTopicConfig.put(one.config.name(), one);
        repartitionTopicConfig.put(two.config.name(), two);
        this.validator.validate(Utils.mkSet("first", "second", one.config.name(), two.config.name()), repartitionTopicConfig, this.cluster.withPartitions(this.partitions));
        MatcherAssert.assertThat((Object)one.numPartitions, (Matcher)CoreMatchers.equalTo((Object)-2));
        MatcherAssert.assertThat((Object)two.numPartitions, (Matcher)CoreMatchers.equalTo((Object)-2));
    }

    private StreamPartitionAssignor.InternalTopicMetadata createTopicMetadata(String repartitionTopic, int partitions) {
        RepartitionTopicConfig repartitionTopicConfig = new RepartitionTopicConfig(repartitionTopic, Collections.emptyMap());
        StreamPartitionAssignor.InternalTopicMetadata metadata = new StreamPartitionAssignor.InternalTopicMetadata(repartitionTopicConfig);
        metadata.numPartitions = partitions;
        return metadata;
    }
}

