/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.MockChangelogReader;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.state.internals.OffsetCheckpoint;
import org.apache.kafka.test.MockBatchingStateRestoreListener;
import org.apache.kafka.test.MockStateStore;
import org.apache.kafka.test.NoOpProcessorContext;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProcessorStateManagerTest {
    private final Set<TopicPartition> noPartitions = Collections.emptySet();
    private final String applicationId = "test-application";
    private final String persistentStoreName = "persistentStore";
    private final String nonPersistentStoreName = "nonPersistentStore";
    private final String persistentStoreTopicName = ProcessorStateManager.storeChangelogTopic("test-application", "persistentStore");
    private final String nonPersistentStoreTopicName = ProcessorStateManager.storeChangelogTopic("test-application", "nonPersistentStore");
    private final MockStateStore persistentStore = new MockStateStore("persistentStore", true);
    private final MockStateStore nonPersistentStore = new MockStateStore("nonPersistentStore", false);
    private final TopicPartition persistentStorePartition = new TopicPartition(this.persistentStoreTopicName, 1);
    private final String storeName = "mockStateStore";
    private final String changelogTopic = ProcessorStateManager.storeChangelogTopic("test-application", "mockStateStore");
    private final TopicPartition changelogTopicPartition = new TopicPartition(this.changelogTopic, 0);
    private final TaskId taskId = new TaskId(0, 1);
    private final MockChangelogReader changelogReader = new MockChangelogReader();
    private final MockStateStore mockStateStore = new MockStateStore("mockStateStore", true);
    private final byte[] key = new byte[]{0, 0, 0, 1};
    private final byte[] value = "the-value".getBytes(Charset.forName("UTF-8"));
    private final ConsumerRecord<byte[], byte[]> consumerRecord = new ConsumerRecord<byte[], byte[]>(this.changelogTopic, 0, 0L, this.key, this.value);
    private final LogContext logContext = new LogContext("process-state-manager-test ");
    private File baseDir;
    private File checkpointFile;
    private OffsetCheckpoint checkpoint;
    private StateDirectory stateDirectory;

    @Before
    public void setup() {
        this.baseDir = TestUtils.tempDirectory();
        this.stateDirectory = new StateDirectory(new StreamsConfig(new Properties(){
            {
                this.put("application.id", "test-application");
                this.put("bootstrap.servers", "dummy:1234");
                this.put("state.dir", ProcessorStateManagerTest.this.baseDir.getPath());
            }
        }), (Time)new MockTime());
        this.checkpointFile = new File(this.stateDirectory.directoryForTask(this.taskId), ".checkpoint");
        this.checkpoint = new OffsetCheckpoint(this.checkpointFile);
    }

    @After
    public void cleanup() throws IOException {
        Utils.delete(this.baseDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRestoreStoreWithBatchingRestoreSpecification() throws Exception {
        TaskId taskId = new TaskId(0, 2);
        MockBatchingStateRestoreListener batchingRestoreCallback = new MockBatchingStateRestoreListener();
        KeyValue<byte[], byte[]> expectedKeyValue = KeyValue.pair(this.key, this.value);
        MockStateStore persistentStore = this.getPersistentStore();
        ProcessorStateManager stateMgr = this.getStandByStateManager(taskId);
        try {
            stateMgr.register(persistentStore, batchingRestoreCallback);
            stateMgr.updateStandbyStates(this.persistentStorePartition, Collections.singletonList(this.consumerRecord));
            MatcherAssert.assertThat((Object)batchingRestoreCallback.getRestoredRecords().size(), (Matcher)Is.is((Object)1));
            Assert.assertTrue((boolean)batchingRestoreCallback.getRestoredRecords().contains(expectedKeyValue));
        }
        finally {
            stateMgr.close(Collections.emptyMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRestoreStoreWithSinglePutRestoreSpecification() throws Exception {
        TaskId taskId = new TaskId(0, 2);
        Integer intKey = 1;
        MockStateStore persistentStore = this.getPersistentStore();
        ProcessorStateManager stateMgr = this.getStandByStateManager(taskId);
        try {
            stateMgr.register(persistentStore, persistentStore.stateRestoreCallback);
            stateMgr.updateStandbyStates(this.persistentStorePartition, Collections.singletonList(this.consumerRecord));
            MatcherAssert.assertThat((Object)persistentStore.keys.size(), (Matcher)Is.is((Object)1));
            Assert.assertTrue((boolean)persistentStore.keys.contains(intKey));
        }
        finally {
            stateMgr.close(Collections.emptyMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterPersistentStore() throws IOException {
        TaskId taskId = new TaskId(0, 2);
        MockStateStore persistentStore = this.getPersistentStore();
        ProcessorStateManager stateMgr = new ProcessorStateManager(taskId, this.noPartitions, false, this.stateDirectory, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("persistentStore", ProcessorStateManagerTest.this.persistentStoreTopicName);
                this.put("nonPersistentStore", "nonPersistentStore");
            }
        }, this.changelogReader, false, this.logContext);
        try {
            stateMgr.register(persistentStore, persistentStore.stateRestoreCallback);
            Assert.assertTrue((boolean)this.changelogReader.wasRegistered(new TopicPartition(this.persistentStoreTopicName, 2)));
        }
        finally {
            stateMgr.close(Collections.emptyMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterNonPersistentStore() throws IOException {
        MockStateStore nonPersistentStore = new MockStateStore("nonPersistentStore", false);
        ProcessorStateManager stateMgr = new ProcessorStateManager(new TaskId(0, 2), this.noPartitions, false, this.stateDirectory, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("persistentStore", ProcessorStateManagerTest.this.persistentStoreTopicName);
                this.put("nonPersistentStore", ProcessorStateManagerTest.this.nonPersistentStoreTopicName);
            }
        }, this.changelogReader, false, this.logContext);
        try {
            stateMgr.register(nonPersistentStore, nonPersistentStore.stateRestoreCallback);
            Assert.assertTrue((boolean)this.changelogReader.wasRegistered(new TopicPartition(this.nonPersistentStoreTopicName, 2)));
        }
        finally {
            stateMgr.close(Collections.emptyMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangeLogOffsets() throws IOException {
        TaskId taskId = new TaskId(0, 0);
        long lastCheckpointedOffset = 10L;
        String storeName1 = "store1";
        String storeName2 = "store2";
        String storeName3 = "store3";
        String storeTopicName1 = ProcessorStateManager.storeChangelogTopic("test-application", "store1");
        String storeTopicName2 = ProcessorStateManager.storeChangelogTopic("test-application", "store2");
        String storeTopicName3 = ProcessorStateManager.storeChangelogTopic("test-application", "store3");
        HashMap<String, String> storeToChangelogTopic = new HashMap<String, String>();
        storeToChangelogTopic.put("store1", storeTopicName1);
        storeToChangelogTopic.put("store2", storeTopicName2);
        storeToChangelogTopic.put("store3", storeTopicName3);
        OffsetCheckpoint checkpoint = new OffsetCheckpoint(new File(this.stateDirectory.directoryForTask(taskId), ".checkpoint"));
        checkpoint.write(Collections.singletonMap(new TopicPartition(storeTopicName1, 0), 10L));
        TopicPartition partition1 = new TopicPartition(storeTopicName1, 0);
        TopicPartition partition2 = new TopicPartition(storeTopicName2, 0);
        TopicPartition partition3 = new TopicPartition(storeTopicName3, 1);
        MockStateStore store1 = new MockStateStore("store1", true);
        MockStateStore store2 = new MockStateStore("store2", true);
        MockStateStore store3 = new MockStateStore("store3", true);
        Set<TopicPartition> sourcePartitions = Utils.mkSet(new TopicPartition(storeTopicName3, 1));
        ProcessorStateManager stateMgr = new ProcessorStateManager(taskId, sourcePartitions, true, this.stateDirectory, storeToChangelogTopic, this.changelogReader, false, this.logContext);
        try {
            stateMgr.register(store1, store1.stateRestoreCallback);
            stateMgr.register(store2, store2.stateRestoreCallback);
            stateMgr.register(store3, store3.stateRestoreCallback);
            Map<TopicPartition, Long> changeLogOffsets = stateMgr.checkpointed();
            Assert.assertEquals((long)3L, (long)changeLogOffsets.size());
            Assert.assertTrue((boolean)changeLogOffsets.containsKey(partition1));
            Assert.assertTrue((boolean)changeLogOffsets.containsKey(partition2));
            Assert.assertTrue((boolean)changeLogOffsets.containsKey(partition3));
            Assert.assertEquals((long)10L, (long)changeLogOffsets.get(partition1));
            Assert.assertEquals((long)-1L, (long)changeLogOffsets.get(partition2));
            Assert.assertEquals((long)-1L, (long)changeLogOffsets.get(partition3));
        }
        finally {
            stateMgr.close(Collections.emptyMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetStore() throws IOException {
        MockStateStore mockStateStore = new MockStateStore("nonPersistentStore", false);
        ProcessorStateManager stateMgr = new ProcessorStateManager(new TaskId(0, 1), this.noPartitions, false, this.stateDirectory, Collections.emptyMap(), this.changelogReader, false, this.logContext);
        try {
            stateMgr.register(mockStateStore, mockStateStore.stateRestoreCallback);
            Assert.assertNull((Object)stateMgr.getStore("noSuchStore"));
            Assert.assertEquals((Object)mockStateStore, (Object)stateMgr.getStore("nonPersistentStore"));
        }
        finally {
            stateMgr.close(Collections.emptyMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushAndClose() throws IOException {
        this.checkpoint.write(Collections.emptyMap());
        HashMap<TopicPartition, Long> ackedOffsets = new HashMap<TopicPartition, Long>();
        ackedOffsets.put(new TopicPartition(this.persistentStoreTopicName, 1), 123L);
        ackedOffsets.put(new TopicPartition(this.nonPersistentStoreTopicName, 1), 456L);
        ackedOffsets.put(new TopicPartition(ProcessorStateManager.storeChangelogTopic("test-application", "otherTopic"), 1), 789L);
        ProcessorStateManager stateMgr = new ProcessorStateManager(this.taskId, this.noPartitions, false, this.stateDirectory, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("persistentStore", ProcessorStateManagerTest.this.persistentStoreTopicName);
                this.put("nonPersistentStore", ProcessorStateManagerTest.this.nonPersistentStoreTopicName);
            }
        }, this.changelogReader, false, this.logContext);
        try {
            Assert.assertFalse((boolean)this.checkpointFile.exists());
            stateMgr.register(this.persistentStore, this.persistentStore.stateRestoreCallback);
            stateMgr.register(this.nonPersistentStore, this.nonPersistentStore.stateRestoreCallback);
        }
        finally {
            stateMgr.flush();
            stateMgr.close(ackedOffsets);
        }
        Assert.assertTrue((boolean)this.persistentStore.flushed);
        Assert.assertTrue((boolean)this.persistentStore.closed);
        Assert.assertTrue((boolean)this.nonPersistentStore.flushed);
        Assert.assertTrue((boolean)this.nonPersistentStore.closed);
        Assert.assertTrue((boolean)this.checkpointFile.exists());
        Map<TopicPartition, Long> checkpointedOffsets = this.checkpoint.read();
        Assert.assertEquals((long)1L, (long)checkpointedOffsets.size());
        Assert.assertEquals((Object)new Long(124L), (Object)checkpointedOffsets.get(new TopicPartition(this.persistentStoreTopicName, 1)));
    }

    @Test
    public void shouldRegisterStoreWithoutLoggingEnabledAndNotBackedByATopic() throws IOException {
        ProcessorStateManager stateMgr = new ProcessorStateManager(new TaskId(0, 1), this.noPartitions, false, this.stateDirectory, Collections.emptyMap(), this.changelogReader, false, this.logContext);
        stateMgr.register(this.nonPersistentStore, this.nonPersistentStore.stateRestoreCallback);
        Assert.assertNotNull((Object)stateMgr.getStore("nonPersistentStore"));
    }

    @Test
    public void shouldNotChangeOffsetsIfAckedOffsetsIsNull() throws IOException {
        Map<TopicPartition, Long> offsets = Collections.singletonMap(this.persistentStorePartition, 99L);
        this.checkpoint.write(offsets);
        MockStateStore persistentStore = new MockStateStore("persistentStore", true);
        ProcessorStateManager stateMgr = new ProcessorStateManager(this.taskId, this.noPartitions, false, this.stateDirectory, Collections.emptyMap(), this.changelogReader, false, this.logContext);
        stateMgr.register(persistentStore, persistentStore.stateRestoreCallback);
        stateMgr.close(null);
        Map<TopicPartition, Long> read = this.checkpoint.read();
        MatcherAssert.assertThat(read, (Matcher)CoreMatchers.equalTo(offsets));
    }

    @Test
    public void shouldWriteCheckpointForPersistentLogEnabledStore() throws IOException {
        ProcessorStateManager stateMgr = new ProcessorStateManager(this.taskId, this.noPartitions, false, this.stateDirectory, Collections.singletonMap(this.persistentStore.name(), this.persistentStoreTopicName), this.changelogReader, false, this.logContext);
        stateMgr.register(this.persistentStore, this.persistentStore.stateRestoreCallback);
        stateMgr.checkpoint(Collections.singletonMap(this.persistentStorePartition, 10L));
        Map<TopicPartition, Long> read = this.checkpoint.read();
        MatcherAssert.assertThat(read, (Matcher)CoreMatchers.equalTo(Collections.singletonMap(this.persistentStorePartition, 11L)));
    }

    @Test
    public void shouldWriteCheckpointForStandbyReplica() throws IOException {
        ProcessorStateManager stateMgr = new ProcessorStateManager(this.taskId, this.noPartitions, true, this.stateDirectory, Collections.singletonMap(this.persistentStore.name(), this.persistentStoreTopicName), this.changelogReader, false, this.logContext);
        stateMgr.register(this.persistentStore, this.persistentStore.stateRestoreCallback);
        byte[] bytes = Serdes.Integer().serializer().serialize("", 10);
        stateMgr.updateStandbyStates(this.persistentStorePartition, Collections.singletonList(new ConsumerRecord<byte[], byte[]>(this.persistentStorePartition.topic(), this.persistentStorePartition.partition(), 888L, bytes, bytes)));
        stateMgr.checkpoint(Collections.emptyMap());
        Map<TopicPartition, Long> read = this.checkpoint.read();
        MatcherAssert.assertThat(read, (Matcher)CoreMatchers.equalTo(Collections.singletonMap(this.persistentStorePartition, 889L)));
    }

    @Test
    public void shouldNotWriteCheckpointForNonPersistent() throws IOException {
        TopicPartition topicPartition = new TopicPartition(this.nonPersistentStoreTopicName, 1);
        ProcessorStateManager stateMgr = new ProcessorStateManager(this.taskId, this.noPartitions, true, this.stateDirectory, Collections.singletonMap("nonPersistentStore", this.nonPersistentStoreTopicName), this.changelogReader, false, this.logContext);
        stateMgr.register(this.nonPersistentStore, this.nonPersistentStore.stateRestoreCallback);
        stateMgr.checkpoint(Collections.singletonMap(topicPartition, 876L));
        Map<TopicPartition, Long> read = this.checkpoint.read();
        MatcherAssert.assertThat(read, (Matcher)CoreMatchers.equalTo(Collections.emptyMap()));
    }

    @Test
    public void shouldNotWriteCheckpointForStoresWithoutChangelogTopic() throws IOException {
        ProcessorStateManager stateMgr = new ProcessorStateManager(this.taskId, this.noPartitions, true, this.stateDirectory, Collections.emptyMap(), this.changelogReader, false, this.logContext);
        stateMgr.register(this.persistentStore, this.persistentStore.stateRestoreCallback);
        stateMgr.checkpoint(Collections.singletonMap(this.persistentStorePartition, 987L));
        Map<TopicPartition, Long> read = this.checkpoint.read();
        MatcherAssert.assertThat(read, (Matcher)CoreMatchers.equalTo(Collections.emptyMap()));
    }

    @Test
    public void shouldThrowIllegalArgumentExceptionIfStoreNameIsSameAsCheckpointFileName() throws IOException {
        ProcessorStateManager stateManager = new ProcessorStateManager(this.taskId, this.noPartitions, false, this.stateDirectory, Collections.emptyMap(), this.changelogReader, false, this.logContext);
        try {
            stateManager.register(new MockStateStore(".checkpoint", true), null);
            Assert.fail((String)"should have thrown illegal argument exception when store name same as checkpoint file");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowIllegalArgumentExceptionOnRegisterWhenStoreHasAlreadyBeenRegistered() throws IOException {
        ProcessorStateManager stateManager = new ProcessorStateManager(this.taskId, this.noPartitions, false, this.stateDirectory, Collections.emptyMap(), this.changelogReader, false, this.logContext);
        stateManager.register(this.mockStateStore, null);
        try {
            stateManager.register(this.mockStateStore, null);
            Assert.fail((String)"should have thrown illegal argument exception when store with same name already registered");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowProcessorStateExceptionOnFlushIfStoreThrowsAnException() throws IOException {
        ProcessorStateManager stateManager = new ProcessorStateManager(this.taskId, Collections.singleton(this.changelogTopicPartition), false, this.stateDirectory, Collections.singletonMap("mockStateStore", this.changelogTopic), this.changelogReader, false, this.logContext);
        MockStateStore stateStore = new MockStateStore("mockStateStore", true){

            @Override
            public void flush() {
                throw new RuntimeException("KABOOM!");
            }
        };
        stateManager.register(stateStore, stateStore.stateRestoreCallback);
        try {
            stateManager.flush();
            Assert.fail((String)"Should throw ProcessorStateException if store flush throws exception");
        }
        catch (ProcessorStateException processorStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowProcessorStateExceptionOnCloseIfStoreThrowsAnException() throws IOException {
        ProcessorStateManager stateManager = new ProcessorStateManager(this.taskId, Collections.singleton(this.changelogTopicPartition), false, this.stateDirectory, Collections.singletonMap("mockStateStore", this.changelogTopic), this.changelogReader, false, this.logContext);
        MockStateStore stateStore = new MockStateStore("mockStateStore", true){

            @Override
            public void close() {
                throw new RuntimeException("KABOOM!");
            }
        };
        stateManager.register(stateStore, stateStore.stateRestoreCallback);
        try {
            stateManager.close(Collections.emptyMap());
            Assert.fail((String)"Should throw ProcessorStateException if store close throws exception");
        }
        catch (ProcessorStateException processorStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFlushAllStoresEvenIfStoreThrowsExcepiton() throws IOException {
        ProcessorStateManager stateManager = new ProcessorStateManager(this.taskId, Collections.singleton(this.changelogTopicPartition), false, this.stateDirectory, Collections.singletonMap("mockStateStore", this.changelogTopic), this.changelogReader, false, this.logContext);
        final AtomicBoolean flushedStore = new AtomicBoolean(false);
        MockStateStore stateStore1 = new MockStateStore("mockStateStore", true){

            @Override
            public void flush() {
                throw new RuntimeException("KABOOM!");
            }
        };
        MockStateStore stateStore2 = new MockStateStore("mockStateStore2", true){

            @Override
            public void flush() {
                flushedStore.set(true);
            }
        };
        stateManager.register(stateStore1, stateStore1.stateRestoreCallback);
        stateManager.register(stateStore2, stateStore2.stateRestoreCallback);
        try {
            stateManager.flush();
        }
        catch (ProcessorStateException processorStateException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)flushedStore.get());
    }

    @Test
    public void shouldCloseAllStoresEvenIfStoreThrowsExcepiton() throws IOException {
        ProcessorStateManager stateManager = new ProcessorStateManager(this.taskId, Collections.singleton(this.changelogTopicPartition), false, this.stateDirectory, Collections.singletonMap("mockStateStore", this.changelogTopic), this.changelogReader, false, this.logContext);
        final AtomicBoolean closedStore = new AtomicBoolean(false);
        MockStateStore stateStore1 = new MockStateStore("mockStateStore", true){

            @Override
            public void close() {
                throw new RuntimeException("KABOOM!");
            }
        };
        MockStateStore stateStore2 = new MockStateStore("mockStateStore2", true){

            @Override
            public void close() {
                closedStore.set(true);
            }
        };
        stateManager.register(stateStore1, stateStore1.stateRestoreCallback);
        stateManager.register(stateStore2, stateStore2.stateRestoreCallback);
        try {
            stateManager.close(Collections.emptyMap());
        }
        catch (ProcessorStateException processorStateException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)closedStore.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDeleteCheckpointFileOnCreationIfEosEnabled() throws IOException {
        this.checkpoint.write(Collections.singletonMap(new TopicPartition(this.persistentStoreTopicName, 1), 123L));
        Assert.assertTrue((boolean)this.checkpointFile.exists());
        ProcessorStateManager stateManager = null;
        try {
            stateManager = new ProcessorStateManager(this.taskId, this.noPartitions, false, this.stateDirectory, Collections.emptyMap(), this.changelogReader, true, this.logContext);
            Assert.assertFalse((boolean)this.checkpointFile.exists());
        }
        finally {
            if (stateManager != null) {
                stateManager.close(null);
            }
        }
    }

    @Test
    public void shouldSuccessfullyReInitializeStateStores() throws IOException {
        String store2Name = "store2";
        String store2Changelog = "store2-changelog";
        TopicPartition store2Partition = new TopicPartition("store2-changelog", 0);
        List<TopicPartition> changelogPartitions = Arrays.asList(this.changelogTopicPartition, store2Partition);
        HashMap storeToChangelog = new HashMap(){
            {
                this.put("mockStateStore", ProcessorStateManagerTest.this.changelogTopic);
                this.put("store2", "store2-changelog");
            }
        };
        final ProcessorStateManager stateManager = new ProcessorStateManager(this.taskId, changelogPartitions, false, this.stateDirectory, storeToChangelog, this.changelogReader, false, this.logContext);
        MockStateStore stateStore = new MockStateStore("mockStateStore", true);
        MockStateStore stateStore2 = new MockStateStore("store2", true);
        stateManager.register(stateStore, stateStore.stateRestoreCallback);
        stateManager.register(stateStore2, stateStore2.stateRestoreCallback);
        stateStore.initialized = false;
        stateStore2.initialized = false;
        stateManager.reinitializeStateStoresForPartitions(changelogPartitions, new NoOpProcessorContext(){

            @Override
            public void register(StateStore store, boolean deprecatedAndIgnoredLoggingEnabled, StateRestoreCallback stateRestoreCallback) {
                stateManager.register(store, stateRestoreCallback);
            }
        });
        Assert.assertTrue((boolean)stateStore.initialized);
        Assert.assertTrue((boolean)stateStore2.initialized);
    }

    private ProcessorStateManager getStandByStateManager(TaskId taskId) throws IOException {
        return new ProcessorStateManager(taskId, this.noPartitions, true, this.stateDirectory, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("persistentStore", ProcessorStateManagerTest.this.persistentStoreTopicName);
            }
        }, this.changelogReader, false, this.logContext);
    }

    private MockStateStore getPersistentStore() {
        return new MockStateStore("persistentStore", true);
    }
}

