/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.ExtendedDeserializer;
import org.apache.kafka.test.MockSourceNode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class SourceNodeTest {
    @Test
    public void shouldProvideTopicHeadersAndDataToKeyDeserializer() {
        MockSourceNode<String, String> sourceNode = new MockSourceNode<String, String>(new String[]{""}, new TheExtendedDeserializer(), new TheExtendedDeserializer());
        RecordHeaders headers = new RecordHeaders();
        String deserializeKey = (String)sourceNode.deserializeKey("topic", headers, "data".getBytes(StandardCharsets.UTF_8));
        MatcherAssert.assertThat((Object)deserializeKey, (Matcher)CoreMatchers.is((Object)("topic" + headers + "data")));
    }

    @Test
    public void shouldProvideTopicHeadersAndDataToValueDeserializer() {
        MockSourceNode<String, String> sourceNode = new MockSourceNode<String, String>(new String[]{""}, new TheExtendedDeserializer(), new TheExtendedDeserializer());
        RecordHeaders headers = new RecordHeaders();
        String deserializedValue = (String)sourceNode.deserializeValue("topic", headers, "data".getBytes(StandardCharsets.UTF_8));
        MatcherAssert.assertThat((Object)deserializedValue, (Matcher)CoreMatchers.is((Object)("topic" + headers + "data")));
    }

    public static class TheExtendedDeserializer
    implements ExtendedDeserializer<String> {
        @Override
        public String deserialize(String topic, Headers headers, byte[] data) {
            return topic + headers + new String(data, StandardCharsets.UTF_8);
        }

        @Override
        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        @Override
        public String deserialize(String topic, byte[] data) {
            return this.deserialize(topic, null, data);
        }

        @Override
        public void close() {
        }
    }
}

