/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.InvalidOffsetException;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.TaskMigratedException;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilderTest;
import org.apache.kafka.streams.processor.LogAndSkipOnInvalidTimestamp;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.TaskMetadata;
import org.apache.kafka.streams.processor.ThreadMetadata;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.RecordCollectorImpl;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.StreamThread;
import org.apache.kafka.streams.processor.internals.StreamsMetadataState;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.TaskManager;
import org.apache.kafka.streams.processor.internals.ThreadStateTransitionValidator;
import org.apache.kafka.test.MockClientSupplier;
import org.apache.kafka.test.MockStateRestoreListener;
import org.apache.kafka.test.MockTimestampExtractor;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StreamThreadTest {
    private final String clientId = "clientId";
    private final String applicationId = "stream-thread-test";
    private final MockTime mockTime = new MockTime();
    private final Metrics metrics = new Metrics();
    private final MockClientSupplier clientSupplier = new MockClientSupplier();
    private UUID processId = UUID.randomUUID();
    private final InternalStreamsBuilder internalStreamsBuilder = new InternalStreamsBuilder(new InternalTopologyBuilder());
    private InternalTopologyBuilder internalTopologyBuilder;
    private final StreamsConfig config = new StreamsConfig(this.configProps(false));
    private final String stateDir = TestUtils.tempDirectory().getPath();
    private final StateDirectory stateDirectory = new StateDirectory(this.config, (Time)this.mockTime);
    private StreamsMetadataState streamsMetadataState;
    private final ConsumedInternal<Object, Object> consumed = new ConsumedInternal();
    private final String topic1 = "topic1";
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final TopicPartition t1p2 = new TopicPartition("topic1", 2);
    private final TaskId task1 = new TaskId(0, 1);
    private final TaskId task2 = new TaskId(0, 2);

    @Before
    public void setUp() {
        this.processId = UUID.randomUUID();
        this.internalTopologyBuilder = InternalStreamsBuilderTest.internalTopologyBuilder(this.internalStreamsBuilder);
        this.internalTopologyBuilder.setApplicationId("stream-thread-test");
        this.streamsMetadataState = new StreamsMetadataState(this.internalTopologyBuilder, StreamsMetadataState.UNKNOWN_HOST);
    }

    private Properties configProps(final boolean enableEos) {
        return new Properties(){
            {
                this.setProperty("application.id", "stream-thread-test");
                this.setProperty("bootstrap.servers", "localhost:2171");
                this.setProperty("buffered.records.per.partition", "3");
                this.setProperty("default.timestamp.extractor", MockTimestampExtractor.class.getName());
                this.setProperty("state.dir", TestUtils.tempDirectory().getAbsolutePath());
                if (enableEos) {
                    this.setProperty("processing.guarantee", "exactly_once");
                }
            }
        };
    }

    @Test
    public void testPartitionAssignmentChangeForSingleGroup() {
        this.internalTopologyBuilder.addSource(null, "source1", null, null, null, "topic1");
        StreamThread thread = this.getStreamThread();
        StateListenerStub stateListener = new StateListenerStub();
        thread.setStateListener(stateListener);
        Assert.assertEquals((Object)thread.state(), (Object)StreamThread.State.CREATED);
        ConsumerRebalanceListener rebalanceListener = thread.rebalanceListener;
        thread.setState(StreamThread.State.RUNNING);
        List<TopicPartition> revokedPartitions = Collections.emptyList();
        rebalanceListener.onPartitionsRevoked(revokedPartitions);
        Assert.assertEquals((Object)thread.state(), (Object)StreamThread.State.PARTITIONS_REVOKED);
        List<TopicPartition> assignedPartitions = Collections.singletonList(this.t1p1);
        thread.taskManager().setAssignmentMetadata(Collections.emptyMap(), Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.consumer;
        mockConsumer.assign(assignedPartitions);
        mockConsumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        rebalanceListener.onPartitionsAssigned(assignedPartitions);
        thread.runOnce(-1L);
        Assert.assertEquals((Object)thread.state(), (Object)StreamThread.State.RUNNING);
        Assert.assertEquals((long)4L, (long)stateListener.numChanges);
        Assert.assertEquals((Object)StreamThread.State.PARTITIONS_ASSIGNED, (Object)stateListener.oldState);
        thread.shutdown();
        Assert.assertTrue((thread.state() == StreamThread.State.PENDING_SHUTDOWN ? 1 : 0) != 0);
    }

    @Test
    public void testStateChangeStartClose() throws InterruptedException {
        final StreamThread thread = this.createStreamThread("clientId", this.config, false);
        StateListenerStub stateListener = new StateListenerStub();
        thread.setStateListener(stateListener);
        thread.start();
        TestUtils.waitForCondition((TestCondition)new TestCondition(){

            public boolean conditionMet() {
                return thread.state() == StreamThread.State.RUNNING;
            }
        }, (long)10000L, (String)"Thread never started.");
        thread.shutdown();
        TestUtils.waitForCondition((TestCondition)new TestCondition(){

            public boolean conditionMet() {
                return thread.state() == StreamThread.State.DEAD;
            }
        }, (long)10000L, (String)"Thread never shut down.");
        thread.shutdown();
        Assert.assertEquals((Object)thread.state(), (Object)StreamThread.State.DEAD);
    }

    private Cluster createCluster(int numNodes) {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        for (int i = 0; i < numNodes; ++i) {
            nodes.put(i, new Node(i, "localhost", 8121 + i));
        }
        return new Cluster("mockClusterId", nodes.values(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
    }

    private StreamThread createStreamThread(String clientId, StreamsConfig config, boolean eosEnabled) {
        if (eosEnabled) {
            this.clientSupplier.setApplicationIdForProducer("stream-thread-test");
        }
        this.clientSupplier.setClusterForAdminClient(this.createCluster(1));
        return StreamThread.create(this.internalTopologyBuilder, config, this.clientSupplier, this.clientSupplier.getAdminClient(config.getAdminConfigs(clientId)), this.processId, clientId, this.metrics, (Time)this.mockTime, this.streamsMetadataState, 0L, this.stateDirectory, new MockStateRestoreListener());
    }

    @Test
    public void testMetrics() {
        StreamThread thread = this.createStreamThread("clientId", this.config, false);
        String defaultGroupName = "stream-metrics";
        String defaultPrefix = "thread." + thread.getName();
        Map<String, String> defaultTags = Collections.singletonMap("client-id", thread.getName());
        Assert.assertNotNull((Object)this.metrics.getSensor(defaultPrefix + ".commit-latency"));
        Assert.assertNotNull((Object)this.metrics.getSensor(defaultPrefix + ".poll-latency"));
        Assert.assertNotNull((Object)this.metrics.getSensor(defaultPrefix + ".process-latency"));
        Assert.assertNotNull((Object)this.metrics.getSensor(defaultPrefix + ".punctuate-latency"));
        Assert.assertNotNull((Object)this.metrics.getSensor(defaultPrefix + ".task-created"));
        Assert.assertNotNull((Object)this.metrics.getSensor(defaultPrefix + ".task-closed"));
        Assert.assertNotNull((Object)this.metrics.getSensor(defaultPrefix + ".skipped-records"));
        Assert.assertNotNull((Object)this.metrics.metrics().get(this.metrics.metricName("commit-latency-avg", "stream-metrics", "The average commit time in ms", defaultTags)));
        Assert.assertNotNull((Object)this.metrics.metrics().get(this.metrics.metricName("commit-latency-max", "stream-metrics", "The maximum commit time in ms", defaultTags)));
        Assert.assertNotNull((Object)this.metrics.metrics().get(this.metrics.metricName("commit-rate", "stream-metrics", "The average per-second number of commit calls", defaultTags)));
        Assert.assertNotNull((Object)this.metrics.metrics().get(this.metrics.metricName("poll-latency-avg", "stream-metrics", "The average poll time in ms", defaultTags)));
        Assert.assertNotNull((Object)this.metrics.metrics().get(this.metrics.metricName("poll-latency-max", "stream-metrics", "The maximum poll time in ms", defaultTags)));
        Assert.assertNotNull((Object)this.metrics.metrics().get(this.metrics.metricName("poll-rate", "stream-metrics", "The average per-second number of record-poll calls", defaultTags)));
        Assert.assertNotNull((Object)this.metrics.metrics().get(this.metrics.metricName("process-latency-avg", "stream-metrics", "The average process time in ms", defaultTags)));
        Assert.assertNotNull((Object)this.metrics.metrics().get(this.metrics.metricName("process-latency-max", "stream-metrics", "The maximum process time in ms", defaultTags)));
        Assert.assertNotNull((Object)this.metrics.metrics().get(this.metrics.metricName("process-rate", "stream-metrics", "The average per-second number of process calls", defaultTags)));
        Assert.assertNotNull((Object)this.metrics.metrics().get(this.metrics.metricName("punctuate-latency-avg", "stream-metrics", "The average punctuate time in ms", defaultTags)));
        Assert.assertNotNull((Object)this.metrics.metrics().get(this.metrics.metricName("punctuate-latency-max", "stream-metrics", "The maximum punctuate time in ms", defaultTags)));
        Assert.assertNotNull((Object)this.metrics.metrics().get(this.metrics.metricName("punctuate-rate", "stream-metrics", "The average per-second number of punctuate calls", defaultTags)));
        Assert.assertNotNull((Object)this.metrics.metrics().get(this.metrics.metricName("task-created-rate", "stream-metrics", "The average per-second number of newly created tasks", defaultTags)));
        Assert.assertNotNull((Object)this.metrics.metrics().get(this.metrics.metricName("task-closed-rate", "stream-metrics", "The average per-second number of closed tasks", defaultTags)));
        Assert.assertNotNull((Object)this.metrics.metrics().get(this.metrics.metricName("skipped-records-rate", "stream-metrics", "The average per-second number of skipped records.", defaultTags)));
    }

    @Test
    public void shouldNotCommitBeforeTheCommitInterval() {
        long commitInterval = 1000L;
        Properties props = this.configProps(false);
        props.setProperty("state.dir", this.stateDir);
        props.setProperty("commit.interval.ms", Long.toString(1000L));
        StreamsConfig config = new StreamsConfig(props);
        Consumer consumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        TaskManager taskManager = this.mockTaskManagerCommit(consumer, 1, 1);
        StreamThread.StreamsMetricsThreadImpl streamsMetrics = new StreamThread.StreamsMetricsThreadImpl(this.metrics, "", "", Collections.emptyMap());
        StreamThread thread = new StreamThread((Time)this.mockTime, config, consumer, consumer, null, taskManager, streamsMetrics, this.internalTopologyBuilder, "clientId", new LogContext(""));
        thread.maybeCommit(this.mockTime.milliseconds());
        this.mockTime.sleep(990L);
        thread.maybeCommit(this.mockTime.milliseconds());
        EasyMock.verify((Object[])new Object[]{taskManager});
    }

    @Test
    public void shouldNotCauseExceptionIfNothingCommited() {
        long commitInterval = 1000L;
        Properties props = this.configProps(false);
        props.setProperty("state.dir", this.stateDir);
        props.setProperty("commit.interval.ms", Long.toString(1000L));
        StreamsConfig config = new StreamsConfig(props);
        Consumer consumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        TaskManager taskManager = this.mockTaskManagerCommit(consumer, 1, 0);
        StreamThread.StreamsMetricsThreadImpl streamsMetrics = new StreamThread.StreamsMetricsThreadImpl(this.metrics, "", "", Collections.emptyMap());
        StreamThread thread = new StreamThread((Time)this.mockTime, config, consumer, consumer, null, taskManager, streamsMetrics, this.internalTopologyBuilder, "clientId", new LogContext(""));
        thread.maybeCommit(this.mockTime.milliseconds());
        this.mockTime.sleep(990L);
        thread.maybeCommit(this.mockTime.milliseconds());
        EasyMock.verify((Object[])new Object[]{taskManager});
    }

    @Test
    public void shouldCommitAfterTheCommitInterval() {
        long commitInterval = 1000L;
        Properties props = this.configProps(false);
        props.setProperty("state.dir", this.stateDir);
        props.setProperty("commit.interval.ms", Long.toString(1000L));
        StreamsConfig config = new StreamsConfig(props);
        Consumer consumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        TaskManager taskManager = this.mockTaskManagerCommit(consumer, 2, 1);
        StreamThread.StreamsMetricsThreadImpl streamsMetrics = new StreamThread.StreamsMetricsThreadImpl(this.metrics, "", "", Collections.emptyMap());
        StreamThread thread = new StreamThread((Time)this.mockTime, config, consumer, consumer, null, taskManager, streamsMetrics, this.internalTopologyBuilder, "clientId", new LogContext(""));
        thread.maybeCommit(this.mockTime.milliseconds());
        this.mockTime.sleep(1001L);
        thread.maybeCommit(this.mockTime.milliseconds());
        EasyMock.verify((Object[])new Object[]{taskManager});
    }

    private TaskManager mockTaskManagerCommit(Consumer<byte[], byte[]> consumer, int numberOfCommits, int commits) {
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        EasyMock.expect((Object)taskManager.commitAll()).andReturn((Object)commits).times(numberOfCommits);
        EasyMock.replay((Object[])new Object[]{taskManager, consumer});
        return taskManager;
    }

    @Test
    public void shouldInjectSharedProducerForAllTasksUsingClientSupplierOnCreateIfEosDisabled() {
        this.internalTopologyBuilder.addSource(null, "source1", null, null, null, "topic1");
        StreamThread thread = this.createStreamThread("clientId", this.config, false);
        thread.setState(StreamThread.State.RUNNING);
        thread.rebalanceListener.onPartitionsRevoked(Collections.emptyList());
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        assignedPartitions.add(this.t1p1);
        assignedPartitions.add(this.t1p2);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        activeTasks.put(this.task2, Collections.singleton(this.t1p2));
        thread.taskManager().setAssignmentMetadata(activeTasks, Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.consumer;
        mockConsumer.assign(assignedPartitions);
        HashMap<TopicPartition, Long> beginOffsets = new HashMap<TopicPartition, Long>();
        beginOffsets.put(this.t1p1, 0L);
        beginOffsets.put(this.t1p2, 0L);
        mockConsumer.updateBeginningOffsets(beginOffsets);
        thread.rebalanceListener.onPartitionsAssigned(new HashSet<TopicPartition>(assignedPartitions));
        Assert.assertEquals((long)1L, (long)this.clientSupplier.producers.size());
        Producer globalProducer = this.clientSupplier.producers.get(0);
        for (Task task : thread.tasks().values()) {
            Assert.assertSame((Object)globalProducer, ((RecordCollectorImpl)((StreamTask)task).recordCollector()).producer());
        }
        Assert.assertSame(this.clientSupplier.consumer, thread.consumer);
        Assert.assertSame(this.clientSupplier.restoreConsumer, thread.restoreConsumer);
    }

    @Test
    public void shouldInjectProducerPerTaskUsingClientSupplierOnCreateIfEosEnable() {
        this.internalTopologyBuilder.addSource(null, "source1", null, null, null, "topic1");
        StreamThread thread = this.createStreamThread("clientId", new StreamsConfig(this.configProps(true)), true);
        thread.setState(StreamThread.State.RUNNING);
        thread.rebalanceListener.onPartitionsRevoked(Collections.emptyList());
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        assignedPartitions.add(this.t1p1);
        assignedPartitions.add(this.t1p2);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        activeTasks.put(this.task2, Collections.singleton(this.t1p2));
        thread.taskManager().setAssignmentMetadata(activeTasks, Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.consumer;
        mockConsumer.assign(assignedPartitions);
        HashMap<TopicPartition, Long> beginOffsets = new HashMap<TopicPartition, Long>();
        beginOffsets.put(this.t1p1, 0L);
        beginOffsets.put(this.t1p2, 0L);
        mockConsumer.updateBeginningOffsets(beginOffsets);
        thread.rebalanceListener.onPartitionsAssigned(new HashSet<TopicPartition>(assignedPartitions));
        thread.runOnce(-1L);
        Assert.assertEquals((long)thread.tasks().size(), (long)this.clientSupplier.producers.size());
        Assert.assertSame(this.clientSupplier.consumer, thread.consumer);
        Assert.assertSame(this.clientSupplier.restoreConsumer, thread.restoreConsumer);
    }

    @Test
    public void shouldCloseAllTaskProducersOnCloseIfEosEnabled() {
        this.internalTopologyBuilder.addSource(null, "source1", null, null, null, "topic1");
        StreamThread thread = this.createStreamThread("clientId", new StreamsConfig(this.configProps(true)), true);
        thread.setState(StreamThread.State.RUNNING);
        thread.rebalanceListener.onPartitionsRevoked(Collections.emptyList());
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        assignedPartitions.add(this.t1p1);
        assignedPartitions.add(this.t1p2);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        activeTasks.put(this.task2, Collections.singleton(this.t1p2));
        thread.taskManager().setAssignmentMetadata(activeTasks, Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.consumer;
        mockConsumer.assign(assignedPartitions);
        HashMap<TopicPartition, Long> beginOffsets = new HashMap<TopicPartition, Long>();
        beginOffsets.put(this.t1p1, 0L);
        beginOffsets.put(this.t1p2, 0L);
        mockConsumer.updateBeginningOffsets(beginOffsets);
        thread.rebalanceListener.onPartitionsAssigned(assignedPartitions);
        thread.shutdown();
        thread.run();
        for (Task task : thread.tasks().values()) {
            Assert.assertTrue((boolean)((MockProducer)((RecordCollectorImpl)((StreamTask)task).recordCollector()).producer()).closed());
        }
    }

    @Test
    public void shouldShutdownTaskManagerOnClose() {
        Consumer consumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        EasyMock.expect(taskManager.activeTasks()).andReturn(Collections.emptyMap());
        EasyMock.expect(taskManager.standbyTasks()).andReturn(Collections.emptyMap());
        taskManager.shutdown(true);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{taskManager, consumer});
        StreamThread.StreamsMetricsThreadImpl streamsMetrics = new StreamThread.StreamsMetricsThreadImpl(this.metrics, "", "", Collections.emptyMap());
        final StreamThread thread = new StreamThread((Time)this.mockTime, this.config, consumer, consumer, null, taskManager, streamsMetrics, this.internalTopologyBuilder, "clientId", new LogContext(""));
        thread.setStateListener(new StreamThread.StateListener(){

            @Override
            public void onChange(Thread t, ThreadStateTransitionValidator newState, ThreadStateTransitionValidator oldState) {
                if (oldState == StreamThread.State.CREATED && newState == StreamThread.State.RUNNING) {
                    thread.shutdown();
                }
            }
        });
        thread.run();
        EasyMock.verify((Object[])new Object[]{taskManager});
    }

    @Test
    public void shouldShutdownTaskManagerOnCloseWithoutStart() {
        Consumer consumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        taskManager.shutdown(true);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{taskManager, consumer});
        StreamThread.StreamsMetricsThreadImpl streamsMetrics = new StreamThread.StreamsMetricsThreadImpl(this.metrics, "", "", Collections.emptyMap());
        StreamThread thread = new StreamThread((Time)this.mockTime, this.config, consumer, consumer, null, taskManager, streamsMetrics, this.internalTopologyBuilder, "clientId", new LogContext(""));
        thread.shutdown();
        EasyMock.verify((Object[])new Object[]{taskManager});
    }

    @Test
    public void shouldOnlyShutdownOnce() {
        Consumer consumer = (Consumer)EasyMock.createNiceMock(Consumer.class);
        TaskManager taskManager = (TaskManager)EasyMock.createNiceMock(TaskManager.class);
        taskManager.shutdown(true);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{taskManager, consumer});
        StreamThread.StreamsMetricsThreadImpl streamsMetrics = new StreamThread.StreamsMetricsThreadImpl(this.metrics, "", "", Collections.emptyMap());
        StreamThread thread = new StreamThread((Time)this.mockTime, this.config, consumer, consumer, null, taskManager, streamsMetrics, this.internalTopologyBuilder, "clientId", new LogContext(""));
        thread.shutdown();
        thread.run();
        EasyMock.verify((Object[])new Object[]{taskManager});
    }

    @Test
    public void shouldNotNullPointerWhenStandbyTasksAssignedAndNoStateStoresForTopology() {
        this.internalTopologyBuilder.addSource(null, "name", null, null, null, "topic");
        this.internalTopologyBuilder.addSink("out", "output", null, null, null, new String[0]);
        StreamThread thread = this.createStreamThread("clientId", this.config, false);
        thread.setState(StreamThread.State.RUNNING);
        thread.rebalanceListener.onPartitionsRevoked(Collections.emptyList());
        HashMap<TaskId, Set<TopicPartition>> standbyTasks = new HashMap<TaskId, Set<TopicPartition>>();
        standbyTasks.put(this.task1, Collections.singleton(this.t1p1));
        thread.taskManager().setAssignmentMetadata(Collections.emptyMap(), standbyTasks);
        thread.taskManager().createTasks(Collections.emptyList());
        thread.rebalanceListener.onPartitionsAssigned(Collections.emptyList());
    }

    @Test
    public void shouldCloseTaskAsZombieAndRemoveFromActiveTasksIfProducerWasFencedWhileProcessing() throws Exception {
        this.internalTopologyBuilder.addSource(null, "source", null, null, null, "topic1");
        this.internalTopologyBuilder.addSink("sink", "dummyTopic", null, null, null, "source");
        final StreamThread thread = this.createStreamThread("clientId", new StreamsConfig(this.configProps(true)), true);
        MockConsumer<byte[], byte[]> consumer = this.clientSupplier.consumer;
        consumer.updatePartitions("topic1", Collections.singletonList(new PartitionInfo("topic1", 1, null, null, null)));
        thread.setState(StreamThread.State.RUNNING);
        thread.rebalanceListener.onPartitionsRevoked(null);
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        assignedPartitions.add(this.t1p1);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        thread.taskManager().setAssignmentMetadata(activeTasks, Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.consumer;
        mockConsumer.assign(assignedPartitions);
        mockConsumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        thread.rebalanceListener.onPartitionsAssigned(assignedPartitions);
        thread.runOnce(-1L);
        Assert.assertThat((Object)thread.tasks().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        final MockProducer producer = this.clientSupplier.producers.get(0);
        consumer.updateBeginningOffsets(Collections.singletonMap(assignedPartitions.iterator().next(), 0L));
        consumer.unsubscribe();
        consumer.assign(new HashSet<TopicPartition>(assignedPartitions));
        consumer.addRecord(new ConsumerRecord<byte[], byte[]>("topic1", 1, 0L, new byte[0], new byte[0]));
        this.mockTime.sleep(this.config.getLong("commit.interval.ms") + 1L);
        thread.runOnce(-1L);
        Assert.assertThat((Object)producer.history().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertFalse((boolean)producer.transactionCommitted());
        this.mockTime.sleep(this.config.getLong("commit.interval.ms") + 1L);
        TestUtils.waitForCondition((TestCondition)new TestCondition(){

            public boolean conditionMet() {
                return producer.commitCount() == 1L;
            }
        }, (String)"StreamsThread did not commit transaction.");
        producer.fenceProducer();
        this.mockTime.sleep(this.config.getLong("commit.interval.ms") + 1L);
        consumer.addRecord(new ConsumerRecord<byte[], byte[]>("topic1", 1, 0L, new byte[0], new byte[0]));
        try {
            thread.runOnce(-1L);
            Assert.fail((String)"Should have thrown TaskMigratedException");
        }
        catch (TaskMigratedException taskMigratedException) {
            // empty catch block
        }
        TestUtils.waitForCondition((TestCondition)new TestCondition(){

            public boolean conditionMet() {
                return thread.tasks().isEmpty();
            }
        }, (String)"StreamsThread did not remove fenced zombie task.");
        Assert.assertThat((Object)producer.commitCount(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldCloseTaskAsZombieAndRemoveFromActiveTasksIfProducerGotFencedAtBeginTransactionWhenTaskIsResumed() {
        this.internalTopologyBuilder.addSource(null, "name", null, null, null, "topic1");
        this.internalTopologyBuilder.addSink("out", "output", null, null, null, new String[0]);
        StreamThread thread = this.createStreamThread("clientId", new StreamsConfig(this.configProps(true)), true);
        thread.setState(StreamThread.State.RUNNING);
        thread.rebalanceListener.onPartitionsRevoked(null);
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        assignedPartitions.add(this.t1p1);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        thread.taskManager().setAssignmentMetadata(activeTasks, Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.consumer;
        mockConsumer.assign(assignedPartitions);
        mockConsumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        thread.rebalanceListener.onPartitionsAssigned(assignedPartitions);
        thread.runOnce(-1L);
        Assert.assertThat((Object)thread.tasks().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        thread.rebalanceListener.onPartitionsRevoked(null);
        this.clientSupplier.producers.get(0).fenceProducer();
        thread.rebalanceListener.onPartitionsAssigned(assignedPartitions);
        try {
            thread.runOnce(-1L);
            Assert.fail((String)"Should have thrown TaskMigratedException");
        }
        catch (TaskMigratedException taskMigratedException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)thread.tasks().isEmpty());
    }

    private StreamThread getStreamThread() {
        return this.createStreamThread("clientId", this.config, false);
    }

    @Test
    public void shouldReturnActiveTaskMetadataWhileRunningState() {
        this.internalTopologyBuilder.addSource(null, "source", null, null, null, "topic1");
        StreamThread thread = this.createStreamThread("clientId", this.config, false);
        thread.setState(StreamThread.State.RUNNING);
        thread.rebalanceListener.onPartitionsRevoked(null);
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        assignedPartitions.add(this.t1p1);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        thread.taskManager().setAssignmentMetadata(activeTasks, Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.consumer;
        mockConsumer.assign(assignedPartitions);
        mockConsumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        thread.rebalanceListener.onPartitionsAssigned(assignedPartitions);
        thread.runOnce(-1L);
        ThreadMetadata threadMetadata = thread.threadMetadata();
        Assert.assertEquals((Object)StreamThread.State.RUNNING.name(), (Object)threadMetadata.threadState());
        Assert.assertTrue((boolean)threadMetadata.activeTasks().contains(new TaskMetadata(this.task1.toString(), Utils.mkSet(this.t1p1))));
        Assert.assertTrue((boolean)threadMetadata.standbyTasks().isEmpty());
    }

    @Test
    public void shouldReturnStandbyTaskMetadataWhileRunningState() {
        this.internalStreamsBuilder.stream(Collections.singleton("topic1"), this.consumed).groupByKey().count(Materialized.as("count-one"));
        StreamThread thread = this.createStreamThread("clientId", this.config, false);
        MockConsumer<byte[], byte[]> restoreConsumer = this.clientSupplier.restoreConsumer;
        restoreConsumer.updatePartitions("stream-thread-test-count-one-changelog", Collections.singletonList(new PartitionInfo("stream-thread-test-count-one-changelog", 0, null, new Node[0], new Node[0])));
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        offsets.put(new TopicPartition("stream-thread-test-count-one-changelog", 1), 0L);
        restoreConsumer.updateEndOffsets(offsets);
        restoreConsumer.updateBeginningOffsets(offsets);
        thread.setState(StreamThread.State.RUNNING);
        thread.rebalanceListener.onPartitionsRevoked(null);
        HashMap<TaskId, Set<TopicPartition>> standbyTasks = new HashMap<TaskId, Set<TopicPartition>>();
        standbyTasks.put(this.task1, Collections.singleton(this.t1p1));
        thread.taskManager().setAssignmentMetadata(Collections.emptyMap(), standbyTasks);
        thread.rebalanceListener.onPartitionsAssigned(Collections.emptyList());
        thread.runOnce(-1L);
        ThreadMetadata threadMetadata = thread.threadMetadata();
        Assert.assertEquals((Object)StreamThread.State.RUNNING.name(), (Object)threadMetadata.threadState());
        Assert.assertTrue((boolean)threadMetadata.standbyTasks().contains(new TaskMetadata(this.task1.toString(), Utils.mkSet(this.t1p1))));
        Assert.assertTrue((boolean)threadMetadata.activeTasks().isEmpty());
    }

    @Test
    public void shouldAlwaysUpdateTasksMetadataAfterChangingState() {
        StreamThread thread = this.createStreamThread("clientId", this.config, false);
        ThreadMetadata metadata = thread.threadMetadata();
        Assert.assertEquals((Object)StreamThread.State.CREATED.name(), (Object)metadata.threadState());
        thread.setState(StreamThread.State.RUNNING);
        metadata = thread.threadMetadata();
        Assert.assertEquals((Object)StreamThread.State.RUNNING.name(), (Object)metadata.threadState());
    }

    @Test
    public void shouldAlwaysReturnEmptyTasksMetadataWhileRebalancingStateAndTasksNotRunning() {
        this.internalStreamsBuilder.stream(Collections.singleton("topic1"), this.consumed).groupByKey().count(Materialized.as("count-one"));
        StreamThread thread = this.createStreamThread("clientId", this.config, false);
        MockConsumer<byte[], byte[]> restoreConsumer = this.clientSupplier.restoreConsumer;
        restoreConsumer.updatePartitions("stream-thread-test-count-one-changelog", Utils.mkList(new PartitionInfo("stream-thread-test-count-one-changelog", 0, null, new Node[0], new Node[0]), new PartitionInfo("stream-thread-test-count-one-changelog", 1, null, new Node[0], new Node[0])));
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        offsets.put(new TopicPartition("stream-thread-test-count-one-changelog", 0), 0L);
        offsets.put(new TopicPartition("stream-thread-test-count-one-changelog", 1), 0L);
        restoreConsumer.updateEndOffsets(offsets);
        restoreConsumer.updateBeginningOffsets(offsets);
        this.clientSupplier.consumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        thread.setState(StreamThread.State.RUNNING);
        ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
        thread.rebalanceListener.onPartitionsRevoked(assignedPartitions);
        this.assertThreadMetadataHasEmptyTasksWithState(thread.threadMetadata(), StreamThread.State.PARTITIONS_REVOKED);
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        HashMap<TaskId, Set<TopicPartition>> standbyTasks = new HashMap<TaskId, Set<TopicPartition>>();
        assignedPartitions.add(this.t1p1);
        activeTasks.put(this.task1, Collections.singleton(this.t1p1));
        standbyTasks.put(this.task2, Collections.singleton(this.t1p2));
        thread.taskManager().setAssignmentMetadata(activeTasks, standbyTasks);
        thread.rebalanceListener.onPartitionsAssigned(assignedPartitions);
        this.assertThreadMetadataHasEmptyTasksWithState(thread.threadMetadata(), StreamThread.State.PARTITIONS_ASSIGNED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRecoverFromInvalidOffsetExceptionOnRestoreAndFinishRestore() throws Exception {
        this.internalStreamsBuilder.stream(Collections.singleton("topic"), this.consumed).groupByKey().count(Materialized.as("count"));
        final StreamThread thread = this.createStreamThread("cliendId", this.config, false);
        MockConsumer mockConsumer = (MockConsumer)thread.consumer;
        final MockConsumer mockRestoreConsumer = (MockConsumer)thread.restoreConsumer;
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        final Set<TopicPartition> topicPartitionSet = Collections.singleton(topicPartition);
        HashMap<TaskId, Set<TopicPartition>> activeTasks = new HashMap<TaskId, Set<TopicPartition>>();
        activeTasks.put(new TaskId(0, 0), topicPartitionSet);
        thread.taskManager().setAssignmentMetadata(activeTasks, Collections.emptyMap());
        mockConsumer.updatePartitions("topic", (List<PartitionInfo>)new ArrayList<PartitionInfo>(){
            {
                this.add(new PartitionInfo("topic", 0, null, new Node[0], new Node[0]));
            }
        });
        mockConsumer.updateBeginningOffsets(Collections.singletonMap(topicPartition, 0L));
        mockRestoreConsumer.updatePartitions("stream-thread-test-count-changelog", (List<PartitionInfo>)new ArrayList<PartitionInfo>(){
            {
                this.add(new PartitionInfo("stream-thread-test-count-changelog", 0, null, new Node[0], new Node[0]));
            }
        });
        final TopicPartition changelogPartition = new TopicPartition("stream-thread-test-count-changelog", 0);
        final Set<TopicPartition> changelogPartitionSet = Collections.singleton(changelogPartition);
        mockRestoreConsumer.updateBeginningOffsets(Collections.singletonMap(changelogPartition, 0L));
        mockRestoreConsumer.updateEndOffsets(Collections.singletonMap(changelogPartition, 2L));
        mockConsumer.schedulePollTask(new Runnable(){

            @Override
            public void run() {
                thread.setState(StreamThread.State.PARTITIONS_REVOKED);
                thread.rebalanceListener.onPartitionsAssigned(topicPartitionSet);
            }
        });
        try {
            thread.start();
            TestUtils.waitForCondition((TestCondition)new TestCondition(){

                public boolean conditionMet() {
                    return mockRestoreConsumer.assignment().size() == 1;
                }
            }, (String)"Never restore first record");
            mockRestoreConsumer.addRecord(new ConsumerRecord<byte[], byte[]>("stream-thread-test-count-changelog", 0, 0L, "K1".getBytes(), "V1".getBytes()));
            TestUtils.waitForCondition((TestCondition)new TestCondition(){

                public boolean conditionMet() {
                    return mockRestoreConsumer.position(changelogPartition) == 1L;
                }
            }, (String)"Never restore first record");
            mockRestoreConsumer.setException(new InvalidOffsetException("Try Again!"){

                @Override
                public Set<TopicPartition> partitions() {
                    return changelogPartitionSet;
                }
            });
            mockRestoreConsumer.addRecord(new ConsumerRecord<byte[], byte[]>("stream-thread-test-count-changelog", 0, 0L, "K1".getBytes(), "V1".getBytes()));
            mockRestoreConsumer.addRecord(new ConsumerRecord<byte[], byte[]>("stream-thread-test-count-changelog", 0, 1L, "K2".getBytes(), "V2".getBytes()));
            TestUtils.waitForCondition((TestCondition)new TestCondition(){

                public boolean conditionMet() {
                    mockRestoreConsumer.assign(changelogPartitionSet);
                    return mockRestoreConsumer.position(changelogPartition) == 2L;
                }
            }, (String)"Never finished restore");
        }
        finally {
            thread.shutdown();
            thread.join(10000L);
        }
    }

    @Test
    public void shouldReportSkippedRecordsForInvalidTimestamps() {
        this.internalTopologyBuilder.addSource(null, "source1", null, null, null, "topic1");
        Properties config = this.configProps(false);
        config.setProperty("default.timestamp.extractor", LogAndSkipOnInvalidTimestamp.class.getName());
        StreamThread thread = this.createStreamThread("clientId", new StreamsConfig(config), false);
        thread.setState(StreamThread.State.RUNNING);
        thread.setState(StreamThread.State.PARTITIONS_REVOKED);
        Set<TopicPartition> assignedPartitions = Collections.singleton(this.t1p1);
        thread.taskManager().setAssignmentMetadata(Collections.singletonMap(new TaskId(0, this.t1p1.partition()), assignedPartitions), Collections.emptyMap());
        MockConsumer mockConsumer = (MockConsumer)thread.consumer;
        mockConsumer.assign(Collections.singleton(this.t1p1));
        mockConsumer.updateBeginningOffsets(Collections.singletonMap(this.t1p1, 0L));
        thread.rebalanceListener.onPartitionsAssigned(assignedPartitions);
        thread.runOnce(-1L);
        MetricName skippedTotalMetric = this.metrics.metricName("skipped-records-total", "stream-metrics", Collections.singletonMap("client-id", thread.getName()));
        Assert.assertEquals((Object)0.0, (Object)this.metrics.metric(skippedTotalMetric).metricValue());
        long offset = -1L;
        mockConsumer.addRecord(new ConsumerRecord<byte[], byte[]>(this.t1p1.topic(), this.t1p1.partition(), ++offset, -1L, TimestampType.CREATE_TIME, -1L, -1, -1, new byte[0], new byte[0]));
        mockConsumer.addRecord(new ConsumerRecord<byte[], byte[]>(this.t1p1.topic(), this.t1p1.partition(), ++offset, -1L, TimestampType.CREATE_TIME, -1L, -1, -1, new byte[0], new byte[0]));
        thread.runOnce(-1L);
        Assert.assertEquals((Object)2.0, (Object)this.metrics.metric(skippedTotalMetric).metricValue());
        mockConsumer.addRecord(new ConsumerRecord<byte[], byte[]>(this.t1p1.topic(), this.t1p1.partition(), ++offset, -1L, TimestampType.CREATE_TIME, -1L, -1, -1, new byte[0], new byte[0]));
        mockConsumer.addRecord(new ConsumerRecord<byte[], byte[]>(this.t1p1.topic(), this.t1p1.partition(), ++offset, -1L, TimestampType.CREATE_TIME, -1L, -1, -1, new byte[0], new byte[0]));
        mockConsumer.addRecord(new ConsumerRecord<byte[], byte[]>(this.t1p1.topic(), this.t1p1.partition(), ++offset, -1L, TimestampType.CREATE_TIME, -1L, -1, -1, new byte[0], new byte[0]));
        mockConsumer.addRecord(new ConsumerRecord<byte[], byte[]>(this.t1p1.topic(), this.t1p1.partition(), ++offset, -1L, TimestampType.CREATE_TIME, -1L, -1, -1, new byte[0], new byte[0]));
        thread.runOnce(-1L);
        Assert.assertEquals((Object)6.0, (Object)this.metrics.metric(skippedTotalMetric).metricValue());
        mockConsumer.addRecord(new ConsumerRecord<byte[], byte[]>(this.t1p1.topic(), this.t1p1.partition(), ++offset, 1L, TimestampType.CREATE_TIME, -1L, -1, -1, new byte[0], new byte[0]));
        mockConsumer.addRecord(new ConsumerRecord<byte[], byte[]>(this.t1p1.topic(), this.t1p1.partition(), ++offset, 1L, TimestampType.CREATE_TIME, -1L, -1, -1, new byte[0], new byte[0]));
        thread.runOnce(-1L);
        Assert.assertEquals((Object)6.0, (Object)this.metrics.metric(skippedTotalMetric).metricValue());
    }

    private void assertThreadMetadataHasEmptyTasksWithState(ThreadMetadata metadata, StreamThread.State state) {
        Assert.assertEquals((Object)state.name(), (Object)metadata.threadState());
        Assert.assertTrue((boolean)metadata.activeTasks().isEmpty());
        Assert.assertTrue((boolean)metadata.standbyTasks().isEmpty());
    }

    private static class StateListenerStub
    implements StreamThread.StateListener {
        int numChanges = 0;
        ThreadStateTransitionValidator oldState = null;
        ThreadStateTransitionValidator newState = null;

        private StateListenerStub() {
        }

        @Override
        public void onChange(Thread thread, ThreadStateTransitionValidator newState, ThreadStateTransitionValidator oldState) {
            ++this.numChanges;
            if (this.newState != null && this.newState != oldState) {
                throw new RuntimeException("State mismatch " + oldState + " different from " + this.newState);
            }
            this.oldState = oldState;
            this.newState = newState;
        }
    }
}

