/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Count;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamsMetricsImpl
implements StreamsMetrics {
    private static final Logger log = LoggerFactory.getLogger(StreamsMetricsImpl.class);
    final Metrics metrics;
    final String groupName;
    final Map<String, String> tags;
    final Map<Sensor, Sensor> parentSensors;

    public StreamsMetricsImpl(Metrics metrics, String groupName, Map<String, String> tags) {
        Objects.requireNonNull(metrics, "Metrics cannot be null");
        this.metrics = metrics;
        this.groupName = groupName;
        this.tags = tags;
        this.parentSensors = new HashMap<Sensor, Sensor>();
    }

    public Metrics registry() {
        return this.metrics;
    }

    @Override
    public Sensor addSensor(String name, Sensor.RecordingLevel recordingLevel) {
        return this.metrics.sensor(name, recordingLevel);
    }

    @Override
    public Sensor addSensor(String name, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
        return this.metrics.sensor(name, recordingLevel, parents);
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() {
        return Collections.unmodifiableMap(this.metrics.metrics());
    }

    @Override
    public void recordLatency(Sensor sensor, long startNs, long endNs) {
        sensor.record(endNs - startNs);
    }

    @Override
    public void recordThroughput(Sensor sensor, long value) {
        sensor.record(value);
    }

    private String groupNameFromScope(String scopeName) {
        return "stream-" + scopeName + "-metrics";
    }

    private String sensorName(String operationName, String entityName) {
        if (entityName == null) {
            return operationName;
        }
        return entityName + "-" + operationName;
    }

    public Map<String, String> tagMap(String ... tags) {
        HashMap<String, String> tagMap = new HashMap<String, String>(this.tags);
        if (tags != null) {
            if (tags.length % 2 != 0) {
                throw new IllegalArgumentException("Tags needs to be specified in key-value pairs");
            }
            for (int i = 0; i < tags.length; i += 2) {
                tagMap.put(tags[i], tags[i + 1]);
            }
        }
        return tagMap;
    }

    private Map<String, String> constructTags(String scopeName, String entityName, String ... tags) {
        ArrayList<String> updatedTagList = new ArrayList<String>(Arrays.asList(tags));
        updatedTagList.add(scopeName + "-id");
        updatedTagList.add(entityName);
        return this.tagMap(updatedTagList.toArray(new String[updatedTagList.size()]));
    }

    @Override
    public Sensor addLatencyAndThroughputSensor(String scopeName, String entityName, String operationName, Sensor.RecordingLevel recordingLevel, String ... tags) {
        Map<String, String> tagMap = this.constructTags(scopeName, entityName, tags);
        Map<String, String> allTagMap = this.constructTags(scopeName, "all", tags);
        Sensor parent = this.metrics.sensor(this.sensorName(operationName, null), recordingLevel);
        this.addLatencyAndThroughputMetrics(scopeName, parent, operationName, allTagMap);
        Sensor sensor = this.metrics.sensor(this.sensorName(operationName, entityName), recordingLevel, parent);
        this.addLatencyAndThroughputMetrics(scopeName, sensor, operationName, tagMap);
        this.parentSensors.put(sensor, parent);
        return sensor;
    }

    @Override
    public Sensor addThroughputSensor(String scopeName, String entityName, String operationName, Sensor.RecordingLevel recordingLevel, String ... tags) {
        Map<String, String> tagMap = this.constructTags(scopeName, entityName, tags);
        Map<String, String> allTagMap = this.constructTags(scopeName, "all", tags);
        Sensor parent = this.metrics.sensor(this.sensorName(operationName, null), recordingLevel);
        this.addThroughputMetrics(scopeName, parent, operationName, allTagMap);
        Sensor sensor = this.metrics.sensor(this.sensorName(operationName, entityName), recordingLevel, parent);
        this.addThroughputMetrics(scopeName, sensor, operationName, tagMap);
        this.parentSensors.put(sensor, parent);
        return sensor;
    }

    private void addLatencyAndThroughputMetrics(String scopeName, Sensor sensor, String opName, Map<String, String> tags) {
        this.maybeAddMetric(sensor, this.metrics.metricName(opName + "-latency-avg", this.groupNameFromScope(scopeName), "The average latency of " + opName + " operation.", tags), new Avg());
        this.maybeAddMetric(sensor, this.metrics.metricName(opName + "-latency-max", this.groupNameFromScope(scopeName), "The max latency of " + opName + " operation.", tags), new Max());
        this.addThroughputMetrics(scopeName, sensor, opName, tags);
    }

    private void addThroughputMetrics(String scopeName, Sensor sensor, String opName, Map<String, String> tags) {
        MetricName rateMetricName = this.metrics.metricName(opName + "-rate", this.groupNameFromScope(scopeName), "The average number of occurrence of " + opName + " operation per second.", tags);
        MetricName totalMetricName = this.metrics.metricName(opName + "-total", this.groupNameFromScope(scopeName), "The total number of occurrence of " + opName + " operations.", tags);
        if (!this.metrics.metrics().containsKey(rateMetricName) && !this.metrics.metrics().containsKey(totalMetricName)) {
            sensor.add(new Meter(new Count(), rateMetricName, totalMetricName));
        } else {
            log.trace("Trying to add metric twice: {} {}", (Object)rateMetricName, (Object)totalMetricName);
        }
    }

    public void maybeAddMetric(Sensor sensor, MetricName name, MeasurableStat stat) {
        if (!this.metrics.metrics().containsKey(name)) {
            sensor.add(name, stat);
        } else {
            log.trace("Trying to add metric twice: {}", (Object)name);
        }
    }

    public void measureLatencyNs(Time time, Runnable action, Sensor sensor) {
        long startNs = -1L;
        if (sensor.shouldRecord()) {
            startNs = time.nanoseconds();
        }
        action.run();
        if (startNs != -1L) {
            this.recordLatency(sensor, startNs, time.nanoseconds());
        }
    }

    @Override
    public void removeSensor(Sensor sensor) {
        Objects.requireNonNull(sensor, "Sensor is null");
        this.metrics.removeSensor(sensor.name());
        Sensor parent = this.parentSensors.get(sensor);
        if (parent != null) {
            this.metrics.removeSensor(parent.name());
        }
    }
}

