/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.StreamsMetricsImpl;
import org.junit.Assert;
import org.junit.Test;

public class StreamsMetricsImplTest {
    @Test(expected=NullPointerException.class)
    public void testNullMetrics() {
        String groupName = "doesNotMatter";
        HashMap<String, String> tags = new HashMap<String, String>();
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(null, groupName, tags);
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveNullSensor() {
        String groupName = "doesNotMatter";
        HashMap<String, String> tags = new HashMap<String, String>();
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), groupName, tags);
        streamsMetrics.removeSensor(null);
    }

    @Test
    public void testRemoveSensor() {
        String groupName = "doesNotMatter";
        String sensorName = "sensor1";
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        HashMap<String, String> tags = new HashMap<String, String>();
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), groupName, tags);
        Sensor sensor1 = streamsMetrics.addSensor(sensorName, Sensor.RecordingLevel.DEBUG);
        streamsMetrics.removeSensor(sensor1);
        Sensor sensor1a = streamsMetrics.addSensor(sensorName, Sensor.RecordingLevel.DEBUG, sensor1);
        streamsMetrics.removeSensor(sensor1a);
        Sensor sensor2 = streamsMetrics.addLatencyAndThroughputSensor(scope, entity, operation, Sensor.RecordingLevel.DEBUG, new String[0]);
        streamsMetrics.removeSensor(sensor2);
        Sensor sensor3 = streamsMetrics.addThroughputSensor(scope, entity, operation, Sensor.RecordingLevel.DEBUG, new String[0]);
        streamsMetrics.removeSensor(sensor3);
    }

    @Test
    public void testLatencyMetrics() {
        String groupName = "doesNotMatter";
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        HashMap<String, String> tags = new HashMap<String, String>();
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), groupName, tags);
        Sensor sensor1 = streamsMetrics.addLatencyAndThroughputSensor(scope, entity, operation, Sensor.RecordingLevel.DEBUG, new String[0]);
        Map<MetricName, ? extends Metric> metrics = streamsMetrics.metrics();
        int meterMetricsCount = 2;
        int otherMetricsCount = 4;
        Assert.assertEquals((long)(meterMetricsCount * 2 + otherMetricsCount + 1), (long)metrics.size());
        streamsMetrics.removeSensor(sensor1);
        metrics = streamsMetrics.metrics();
        Assert.assertEquals((long)metrics.size(), (long)1L);
    }

    @Test
    public void testThroughputMetrics() {
        String groupName = "doesNotMatter";
        String scope = "scope";
        String entity = "entity";
        String operation = "put";
        HashMap<String, String> tags = new HashMap<String, String>();
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), groupName, tags);
        Sensor sensor1 = streamsMetrics.addThroughputSensor(scope, entity, operation, Sensor.RecordingLevel.DEBUG, new String[0]);
        Map<MetricName, ? extends Metric> metrics = streamsMetrics.metrics();
        int meterMetricsCount = 2;
        Assert.assertEquals((long)(meterMetricsCount * 2 + 1), (long)metrics.size());
        streamsMetrics.removeSensor(sensor1);
        metrics = streamsMetrics.metrics();
        Assert.assertEquals((long)metrics.size(), (long)1L);
    }
}

