/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.BatchingStateRestoreCallback;
import org.apache.kafka.streams.processor.internals.WrappedBatchingStateRestoreCallback;
import org.apache.kafka.test.MockRestoreCallback;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;

public class WrappedBatchingStateRestoreCallbackTest {
    private final MockRestoreCallback mockRestoreCallback = new MockRestoreCallback();
    private final byte[] key = "key".getBytes(Charset.forName("UTF-8"));
    private final byte[] value = "value".getBytes(Charset.forName("UTF-8"));
    private final Collection<KeyValue<byte[], byte[]>> records = Collections.singletonList(KeyValue.pair(this.key, this.value));
    private final BatchingStateRestoreCallback wrappedBatchingStateRestoreCallback = new WrappedBatchingStateRestoreCallback(this.mockRestoreCallback);

    @Test
    public void shouldRestoreSinglePutsFromArray() {
        this.wrappedBatchingStateRestoreCallback.restoreAll(this.records);
        MatcherAssert.assertThat(this.mockRestoreCallback.restored, (Matcher)Is.is(this.records));
        KeyValue<byte[], byte[]> record = this.mockRestoreCallback.restored.get(0);
        MatcherAssert.assertThat(record.key, (Matcher)Is.is((Object)this.key));
        MatcherAssert.assertThat(record.value, (Matcher)Is.is((Object)this.value));
    }
}

