/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.MemoryNavigableLRUCache;
import org.apache.kafka.streams.state.internals.RocksDBSessionStore;
import org.apache.kafka.streams.state.internals.RocksDBStore;
import org.apache.kafka.streams.state.internals.RocksDBWindowStore;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;

public class StoresTest {
    @Test(expected=NullPointerException.class)
    public void shouldThrowIfPersistentKeyValueStoreStoreNameIsNull() {
        Stores.persistentKeyValueStore(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfIMemoryKeyValueStoreStoreNameIsNull() {
        Stores.inMemoryKeyValueStore(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfILruMapStoreNameIsNull() {
        Stores.lruMap(null, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfILruMapStoreCapacityIsNegative() {
        Stores.lruMap("anyName", -1);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfIPersistentWindowStoreStoreNameIsNull() {
        Stores.persistentWindowStore(null, 0L, 1, 0L, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfIPersistentWindowStoreRetentionPeriodIsNegative() {
        Stores.persistentWindowStore("anyName", -1L, 1, 0L, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfIPersistentWindowStoreIfNumberOfSegmentsSmallerThanOne() {
        Stores.persistentWindowStore("anyName", 0L, 0, 0L, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfIPersistentWindowStoreIfWindowSizeIsNegative() {
        Stores.persistentWindowStore("anyName", 0L, 1, -1L, false);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfIPersistentSessionStoreStoreNameIsNull() {
        Stores.persistentSessionStore(null, 0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfIPersistentSessionStoreRetentionPeriodIsNegative() {
        Stores.persistentSessionStore("anyName", -1L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfSupplierIsNullForWindowStoreBuilder() {
        Stores.windowStoreBuilder(null, Serdes.ByteArray(), Serdes.ByteArray());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfSupplierIsNullForKeyValueStoreBuilder() {
        Stores.keyValueStoreBuilder(null, Serdes.ByteArray(), Serdes.ByteArray());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowIfSupplierIsNullForSessionStoreBuilder() {
        Stores.sessionStoreBuilder(null, Serdes.ByteArray(), Serdes.ByteArray());
    }

    @Test
    public void shouldCreateInMemoryStoreSupplierWithLoggedConfig() {
        StateStoreSupplier supplier = Stores.create("store").withKeys(Serdes.String()).withValues(Serdes.String()).inMemory().enableLogging(Collections.singletonMap("retention.ms", "1000")).build();
        Map<String, String> config = supplier.logConfig();
        Assert.assertTrue((boolean)supplier.loggingEnabled());
        Assert.assertEquals((Object)"1000", (Object)config.get("retention.ms"));
    }

    @Test
    public void shouldCreateInMemoryStoreSupplierNotLogged() {
        StateStoreSupplier supplier = Stores.create("store").withKeys(Serdes.String()).withValues(Serdes.String()).inMemory().disableLogging().build();
        Assert.assertFalse((boolean)supplier.loggingEnabled());
    }

    @Test
    public void shouldCreatePersistenStoreSupplierWithLoggedConfig() {
        StateStoreSupplier supplier = Stores.create("store").withKeys(Serdes.String()).withValues(Serdes.String()).persistent().enableLogging(Collections.singletonMap("retention.ms", "1000")).build();
        Map<String, String> config = supplier.logConfig();
        Assert.assertTrue((boolean)supplier.loggingEnabled());
        Assert.assertEquals((Object)"1000", (Object)config.get("retention.ms"));
    }

    @Test
    public void shouldCreatePersistenStoreSupplierNotLogged() {
        StateStoreSupplier supplier = Stores.create("store").withKeys(Serdes.String()).withValues(Serdes.String()).persistent().disableLogging().build();
        Assert.assertFalse((boolean)supplier.loggingEnabled());
    }

    @Test
    public void shouldThrowIllegalArgumentExceptionWhenTryingToConstructWindowStoreWithLessThanTwoSegments() {
        Stores.PersistentKeyValueFactory<String, String> storeFactory = Stores.create("store").withKeys(Serdes.String()).withValues(Serdes.String()).persistent();
        try {
            storeFactory.windowed(1L, 1L, 1, false);
            Assert.fail((String)"Should have thrown illegal argument exception as number of segments is less than 2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldCreateInMemoryKeyValueStore() {
        MatcherAssert.assertThat(Stores.inMemoryKeyValueStore("memory").get(), (Matcher)IsInstanceOf.instanceOf(InMemoryKeyValueStore.class));
    }

    @Test
    public void shouldCreateMemoryNavigableCache() {
        MatcherAssert.assertThat(Stores.lruMap("map", 10).get(), (Matcher)IsInstanceOf.instanceOf(MemoryNavigableLRUCache.class));
    }

    @Test
    public void shouldCreateRocksDbStore() {
        MatcherAssert.assertThat(Stores.persistentKeyValueStore("store").get(), (Matcher)IsInstanceOf.instanceOf(RocksDBStore.class));
    }

    @Test
    public void shouldCreateRocksDbWindowStore() {
        MatcherAssert.assertThat(Stores.persistentWindowStore("store", 1L, 3, 1L, false).get(), (Matcher)IsInstanceOf.instanceOf(RocksDBWindowStore.class));
    }

    @Test
    public void shouldCreateRocksDbSessionStore() {
        MatcherAssert.assertThat(Stores.persistentSessionStore("store", 1L).get(), (Matcher)IsInstanceOf.instanceOf(RocksDBSessionStore.class));
    }

    @Test
    public void shouldBuildWindowStore() {
        WindowStore<String, String> store = Stores.windowStoreBuilder(Stores.persistentWindowStore("store", 3L, 2, 3L, true), Serdes.String(), Serdes.String()).build();
        MatcherAssert.assertThat(store, (Matcher)IsNot.not((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldBuildKeyValueStore() {
        KeyValueStore<String, String> store = Stores.keyValueStoreBuilder(Stores.persistentKeyValueStore("name"), Serdes.String(), Serdes.String()).build();
        MatcherAssert.assertThat(store, (Matcher)IsNot.not((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldBuildSessionStore() {
        SessionStore<String, String> store = Stores.sessionStoreBuilder(Stores.persistentSessionStore("name", 10L), Serdes.String(), Serdes.String()).build();
        MatcherAssert.assertThat(store, (Matcher)IsNot.not((Matcher)CoreMatchers.nullValue()));
    }
}

