/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.streams.state.HostInfo;

@InterfaceStability.Evolving
public class StreamsMetadata {
    public static final StreamsMetadata NOT_AVAILABLE = new StreamsMetadata(new HostInfo("unavailable", -1), Collections.emptySet(), Collections.emptySet());
    private final HostInfo hostInfo;
    private final Set<String> stateStoreNames;
    private final Set<TopicPartition> topicPartitions;

    public StreamsMetadata(HostInfo hostInfo, Set<String> stateStoreNames, Set<TopicPartition> topicPartitions) {
        this.hostInfo = hostInfo;
        this.stateStoreNames = stateStoreNames;
        this.topicPartitions = topicPartitions;
    }

    public HostInfo hostInfo() {
        return this.hostInfo;
    }

    public Set<String> stateStoreNames() {
        return this.stateStoreNames;
    }

    public Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public String host() {
        return this.hostInfo.host();
    }

    public int port() {
        return this.hostInfo.port();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamsMetadata that = (StreamsMetadata)o;
        if (!this.hostInfo.equals(that.hostInfo)) {
            return false;
        }
        if (!this.stateStoreNames.equals(that.stateStoreNames)) {
            return false;
        }
        return this.topicPartitions.equals(that.topicPartitions);
    }

    public int hashCode() {
        int result2 = this.hostInfo.hashCode();
        result2 = 31 * result2 + this.stateStoreNames.hashCode();
        result2 = 31 * result2 + this.topicPartitions.hashCode();
        return result2;
    }

    public String toString() {
        return "StreamsMetadata{hostInfo=" + this.hostInfo + ", stateStoreNames=" + this.stateStoreNames + ", topicPartitions=" + this.topicPartitions + '}';
    }
}

