/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.KeyValueStoreTestDriver;
import org.apache.kafka.test.MockProcessorContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractKeyValueStoreTest {
    protected MockProcessorContext context;
    protected KeyValueStore<Integer, String> store;
    protected KeyValueStoreTestDriver<Integer, String> driver;

    protected abstract <K, V> KeyValueStore<K, V> createKeyValueStore(ProcessorContext var1);

    @Before
    public void before() {
        this.driver = KeyValueStoreTestDriver.create(Integer.class, String.class);
        this.context = (MockProcessorContext)this.driver.context();
        this.context.setTime(10L);
        this.store = this.createKeyValueStore(this.context);
    }

    @After
    public void after() {
        this.store.close();
        this.context.close();
        this.driver.clear();
    }

    private static Map<Integer, String> getContents(KeyValueIterator<Integer, String> iter) {
        HashMap<Integer, String> result2 = new HashMap<Integer, String>();
        while (iter.hasNext()) {
            KeyValue entry = (KeyValue)iter.next();
            result2.put((Integer)entry.key, (String)entry.value);
        }
        return result2;
    }

    @Test
    public void shouldNotIncludeDeletedFromRangeResult() {
        this.store.close();
        StringSerializer serializer = new StringSerializer(){
            private int numCalls = 0;

            @Override
            public byte[] serialize(String topic, String data) {
                if (++this.numCalls > 3) {
                    Assert.fail((String)"Value serializer is called; it should never happen");
                }
                return super.serialize(topic, data);
            }
        };
        this.context.setValueSerde(Serdes.serdeFrom(serializer, new StringDeserializer()));
        this.store = this.createKeyValueStore(this.driver.context());
        this.store.put(0, "zero");
        this.store.put(1, "one");
        this.store.put(2, "two");
        this.store.delete(0);
        this.store.delete(1);
        Map<Integer, String> expectedContents = Collections.singletonMap(2, "two");
        Assert.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContents(this.store.all()));
    }

    @Test
    public void shouldDeleteIfSerializedValueIsNull() {
        this.store.close();
        StringSerializer serializer = new StringSerializer(){

            @Override
            public byte[] serialize(String topic, String data) {
                if (data.equals("null")) {
                    return null;
                }
                return super.serialize(topic, data);
            }
        };
        this.context.setValueSerde(Serdes.serdeFrom(serializer, new StringDeserializer()));
        this.store = this.createKeyValueStore(this.driver.context());
        this.store.put(0, "zero");
        this.store.put(1, "one");
        this.store.put(2, "two");
        this.store.put(0, "null");
        this.store.put(1, "null");
        Map<Integer, String> expectedContents = Collections.singletonMap(2, "two");
        Assert.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContents(this.store.all()));
    }

    @Test
    public void testPutGetRange() {
        this.store.put(0, "zero");
        this.store.put(1, "one");
        this.store.put(2, "two");
        this.store.put(4, "four");
        this.store.put(5, "five");
        Assert.assertEquals((long)5L, (long)this.driver.sizeOf(this.store));
        Assert.assertEquals((Object)"zero", this.store.get(0));
        Assert.assertEquals((Object)"one", this.store.get(1));
        Assert.assertEquals((Object)"two", this.store.get(2));
        Assert.assertNull(this.store.get(3));
        Assert.assertEquals((Object)"four", this.store.get(4));
        Assert.assertEquals((Object)"five", this.store.get(5));
        this.store.delete(5);
        Assert.assertEquals((long)4L, (long)this.driver.sizeOf(this.store));
        this.store.flush();
        Assert.assertEquals((Object)"zero", (Object)this.driver.flushedEntryStored(0));
        Assert.assertEquals((Object)"one", (Object)this.driver.flushedEntryStored(1));
        Assert.assertEquals((Object)"two", (Object)this.driver.flushedEntryStored(2));
        Assert.assertEquals((Object)"four", (Object)this.driver.flushedEntryStored(4));
        Assert.assertEquals(null, (Object)this.driver.flushedEntryStored(5));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(0));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(1));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(2));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(4));
        Assert.assertEquals((Object)true, (Object)this.driver.flushedEntryRemoved(5));
        HashMap<Integer, String> expectedContents = new HashMap<Integer, String>();
        expectedContents.put(2, "two");
        expectedContents.put(4, "four");
        Assert.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContents(this.store.range(2, 4)));
        Assert.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContents(this.store.range(2, 6)));
        expectedContents.put(0, "zero");
        expectedContents.put(1, "one");
        Assert.assertEquals(expectedContents, AbstractKeyValueStoreTest.getContents(this.store.all()));
    }

    @Test
    public void testPutGetRangeWithDefaultSerdes() {
        this.store.put(0, "zero");
        this.store.put(1, "one");
        this.store.put(2, "two");
        this.store.put(4, "four");
        this.store.put(5, "five");
        Assert.assertEquals((long)5L, (long)this.driver.sizeOf(this.store));
        Assert.assertEquals((Object)"zero", this.store.get(0));
        Assert.assertEquals((Object)"one", this.store.get(1));
        Assert.assertEquals((Object)"two", this.store.get(2));
        Assert.assertNull(this.store.get(3));
        Assert.assertEquals((Object)"four", this.store.get(4));
        Assert.assertEquals((Object)"five", this.store.get(5));
        this.store.delete(5);
        this.store.flush();
        Assert.assertEquals((Object)"zero", (Object)this.driver.flushedEntryStored(0));
        Assert.assertEquals((Object)"one", (Object)this.driver.flushedEntryStored(1));
        Assert.assertEquals((Object)"two", (Object)this.driver.flushedEntryStored(2));
        Assert.assertEquals((Object)"four", (Object)this.driver.flushedEntryStored(4));
        Assert.assertEquals(null, (Object)this.driver.flushedEntryStored(5));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(0));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(1));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(2));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(4));
        Assert.assertEquals((Object)true, (Object)this.driver.flushedEntryRemoved(5));
    }

    @Test
    public void testRestore() {
        this.store.close();
        this.driver.addEntryToRestoreLog(0, "zero");
        this.driver.addEntryToRestoreLog(1, "one");
        this.driver.addEntryToRestoreLog(2, "two");
        this.driver.addEntryToRestoreLog(3, "three");
        this.store = this.createKeyValueStore(this.driver.context());
        this.context.restore(this.store.name(), this.driver.restoredEntries());
        Assert.assertEquals((long)0L, (long)this.driver.checkForRestoredEntries(this.store));
        Assert.assertEquals((long)4L, (long)this.driver.sizeOf(this.store));
    }

    @Test
    public void testRestoreWithDefaultSerdes() {
        this.store.close();
        this.driver.addEntryToRestoreLog(0, "zero");
        this.driver.addEntryToRestoreLog(1, "one");
        this.driver.addEntryToRestoreLog(2, "two");
        this.driver.addEntryToRestoreLog(3, "three");
        this.store = this.createKeyValueStore(this.driver.context());
        this.context.restore(this.store.name(), this.driver.restoredEntries());
        Assert.assertEquals((long)0L, (long)this.driver.checkForRestoredEntries(this.store));
        Assert.assertEquals((long)4L, (long)this.driver.sizeOf(this.store));
    }

    @Test
    public void testPutIfAbsent() {
        Assert.assertNull((Object)this.store.putIfAbsent(0, "zero"));
        Assert.assertNull((Object)this.store.putIfAbsent(1, "one"));
        Assert.assertNull((Object)this.store.putIfAbsent(2, "two"));
        Assert.assertNull((Object)this.store.putIfAbsent(4, "four"));
        Assert.assertEquals((Object)"four", (Object)this.store.putIfAbsent(4, "unexpected value"));
        Assert.assertEquals((long)4L, (long)this.driver.sizeOf(this.store));
        Assert.assertEquals((Object)"zero", this.store.get(0));
        Assert.assertEquals((Object)"one", this.store.get(1));
        Assert.assertEquals((Object)"two", this.store.get(2));
        Assert.assertNull(this.store.get(3));
        Assert.assertEquals((Object)"four", this.store.get(4));
        this.store.flush();
        Assert.assertEquals((Object)"zero", (Object)this.driver.flushedEntryStored(0));
        Assert.assertEquals((Object)"one", (Object)this.driver.flushedEntryStored(1));
        Assert.assertEquals((Object)"two", (Object)this.driver.flushedEntryStored(2));
        Assert.assertEquals((Object)"four", (Object)this.driver.flushedEntryStored(4));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(0));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(1));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(2));
        Assert.assertEquals((Object)false, (Object)this.driver.flushedEntryRemoved(4));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnPutNullKey() {
        this.store.put(null, "anyValue");
    }

    @Test
    public void shouldNotThrowNullPointerExceptionOnPutNullValue() {
        this.store.put(1, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnPutIfAbsentNullKey() {
        this.store.putIfAbsent(null, "anyValue");
    }

    @Test
    public void shouldNotThrowNullPointerExceptionOnPutIfAbsentNullValue() {
        this.store.putIfAbsent(1, null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnPutAllNullKey() {
        this.store.putAll(Collections.singletonList(new KeyValue<Object, String>(null, "anyValue")));
    }

    @Test
    public void shouldNotThrowNullPointerExceptionOnPutAllNullKey() {
        this.store.putAll(Collections.singletonList(new KeyValue<Integer, Object>(1, null)));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnDeleteNullKey() {
        this.store.delete(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnGetNullKey() {
        this.store.get(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnRangeNullFromKey() {
        this.store.range(null, 2);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnRangeNullToKey() {
        this.store.range(2, null);
    }

    @Test
    public void testSize() {
        Assert.assertEquals((String)"A newly created store should have no entries", (long)0L, (long)this.store.approximateNumEntries());
        this.store.put(0, "zero");
        this.store.put(1, "one");
        this.store.put(2, "two");
        this.store.put(4, "four");
        this.store.put(5, "five");
        this.store.flush();
        Assert.assertEquals((long)5L, (long)this.store.approximateNumEntries());
    }
}

