/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.internals.CompositeReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.internals.StateStoreTestUtils;
import org.apache.kafka.streams.state.internals.WrappingStoreProvider;
import org.apache.kafka.test.NoOpReadOnlyStore;
import org.apache.kafka.test.StateStoreProviderStub;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompositeReadOnlyKeyValueStoreTest {
    private final String storeName = "my-store";
    private final String storeNameA = "my-storeA";
    private StateStoreProviderStub stubProviderTwo;
    private KeyValueStore<String, String> stubOneUnderlying;
    private CompositeReadOnlyKeyValueStore<String, String> theStore;
    private KeyValueStore<String, String> otherUnderlyingStore;

    @Before
    public void before() {
        StateStoreProviderStub stubProviderOne = new StateStoreProviderStub(false);
        this.stubProviderTwo = new StateStoreProviderStub(false);
        this.stubOneUnderlying = this.newStoreInstance();
        stubProviderOne.addStore("my-store", this.stubOneUnderlying);
        this.otherUnderlyingStore = this.newStoreInstance();
        stubProviderOne.addStore("other-store", this.otherUnderlyingStore);
        this.theStore = new CompositeReadOnlyKeyValueStore(new WrappingStoreProvider(Arrays.asList(stubProviderOne, this.stubProviderTwo)), QueryableStoreTypes.keyValueStore(), "my-store");
    }

    private KeyValueStore<String, String> newStoreInstance() {
        return StateStoreTestUtils.newKeyValueStore("my-store", "app-id", String.class, String.class);
    }

    @Test
    public void shouldReturnNullIfKeyDoesntExist() {
        Assert.assertNull((Object)this.theStore.get("whatever"));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnGetNullKey() {
        this.theStore.get(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnRangeNullFromKey() {
        this.theStore.range(null, "to");
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnRangeNullToKey() {
        this.theStore.range("from", null);
    }

    @Test
    public void shouldReturnValueIfExists() {
        this.stubOneUnderlying.put("key", "value");
        Assert.assertEquals((Object)"value", (Object)this.theStore.get("key"));
    }

    @Test
    public void shouldNotGetValuesFromOtherStores() {
        this.otherUnderlyingStore.put("otherKey", "otherValue");
        Assert.assertNull((Object)this.theStore.get("otherKey"));
    }

    @Test
    public void shouldThrowNoSuchElementExceptionWhileNext() {
        this.stubOneUnderlying.put("a", "1");
        KeyValueIterator<String, String> keyValueIterator = this.theStore.range("a", "b");
        keyValueIterator.next();
        try {
            keyValueIterator.next();
            Assert.fail((String)"Should have thrown NoSuchElementException with next()");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowNoSuchElementExceptionWhilePeekNext() {
        this.stubOneUnderlying.put("a", "1");
        KeyValueIterator<String, String> keyValueIterator = this.theStore.range("a", "b");
        keyValueIterator.next();
        try {
            keyValueIterator.peekNextKey();
            Assert.fail((String)"Should have thrown NoSuchElementException with peekNextKey()");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionWhileRemove() {
        KeyValueIterator<String, String> keyValueIterator = this.theStore.all();
        try {
            keyValueIterator.remove();
            Assert.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowUnsupportedOperationExceptionWhileRange() {
        this.stubOneUnderlying.put("a", "1");
        this.stubOneUnderlying.put("b", "1");
        KeyValueIterator<String, String> keyValueIterator = this.theStore.range("a", "b");
        try {
            keyValueIterator.remove();
            Assert.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFindValueForKeyWhenMultiStores() {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", cache);
        cache.put("key-two", "key-two-value");
        this.stubOneUnderlying.put("key-one", "key-one-value");
        Assert.assertEquals((Object)"key-two-value", (Object)this.theStore.get("key-two"));
        Assert.assertEquals((Object)"key-one-value", (Object)this.theStore.get("key-one"));
    }

    @Test
    public void shouldSupportRange() {
        this.stubOneUnderlying.put("a", "a");
        this.stubOneUnderlying.put("b", "b");
        this.stubOneUnderlying.put("c", "c");
        List results = StreamsTestUtils.toList(this.theStore.range("a", "b"));
        Assert.assertTrue((boolean)results.contains(new KeyValue<String, String>("a", "a")));
        Assert.assertTrue((boolean)results.contains(new KeyValue<String, String>("b", "b")));
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void shouldSupportRangeAcrossMultipleKVStores() {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", cache);
        this.stubOneUnderlying.put("a", "a");
        this.stubOneUnderlying.put("b", "b");
        this.stubOneUnderlying.put("z", "z");
        cache.put("c", "c");
        cache.put("d", "d");
        cache.put("x", "x");
        List results = StreamsTestUtils.toList(this.theStore.range("a", "e"));
        Assert.assertTrue((boolean)results.contains(new KeyValue<String, String>("a", "a")));
        Assert.assertTrue((boolean)results.contains(new KeyValue<String, String>("b", "b")));
        Assert.assertTrue((boolean)results.contains(new KeyValue<String, String>("c", "c")));
        Assert.assertTrue((boolean)results.contains(new KeyValue<String, String>("d", "d")));
        Assert.assertEquals((long)4L, (long)results.size());
    }

    @Test
    public void shouldSupportAllAcrossMultipleStores() {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", cache);
        this.stubOneUnderlying.put("a", "a");
        this.stubOneUnderlying.put("b", "b");
        this.stubOneUnderlying.put("z", "z");
        cache.put("c", "c");
        cache.put("d", "d");
        cache.put("x", "x");
        List results = StreamsTestUtils.toList(this.theStore.all());
        Assert.assertTrue((boolean)results.contains(new KeyValue<String, String>("a", "a")));
        Assert.assertTrue((boolean)results.contains(new KeyValue<String, String>("b", "b")));
        Assert.assertTrue((boolean)results.contains(new KeyValue<String, String>("c", "c")));
        Assert.assertTrue((boolean)results.contains(new KeyValue<String, String>("d", "d")));
        Assert.assertTrue((boolean)results.contains(new KeyValue<String, String>("x", "x")));
        Assert.assertTrue((boolean)results.contains(new KeyValue<String, String>("z", "z")));
        Assert.assertEquals((long)6L, (long)results.size());
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowInvalidStoreExceptionDuringRebalance() {
        this.rebalancing().get("anything");
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowInvalidStoreExceptionOnApproximateNumEntriesDuringRebalance() {
        this.rebalancing().approximateNumEntries();
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowInvalidStoreExceptionOnRangeDuringRebalance() {
        this.rebalancing().range("anything", "something");
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowInvalidStoreExceptionOnAllDuringRebalance() {
        this.rebalancing().all();
    }

    @Test
    public void shouldGetApproximateEntriesAcrossAllStores() {
        KeyValueStore<String, String> cache = this.newStoreInstance();
        this.stubProviderTwo.addStore("my-store", cache);
        this.stubOneUnderlying.put("a", "a");
        this.stubOneUnderlying.put("b", "b");
        this.stubOneUnderlying.put("z", "z");
        cache.put("c", "c");
        cache.put("d", "d");
        cache.put("x", "x");
        Assert.assertEquals((long)6L, (long)this.theStore.approximateNumEntries());
    }

    @Test
    public void shouldReturnLongMaxValueOnOverflow() {
        this.stubProviderTwo.addStore("my-store", new NoOpReadOnlyStore<Object, Object>(){

            @Override
            public long approximateNumEntries() {
                return Long.MAX_VALUE;
            }
        });
        this.stubOneUnderlying.put("overflow", "me");
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.theStore.approximateNumEntries());
    }

    @Test
    public void shouldReturnLongMaxValueOnUnderflow() {
        this.stubProviderTwo.addStore("my-store", new NoOpReadOnlyStore<Object, Object>(){

            @Override
            public long approximateNumEntries() {
                return Long.MAX_VALUE;
            }
        });
        this.stubProviderTwo.addStore("my-storeA", new NoOpReadOnlyStore<Object, Object>(){

            @Override
            public long approximateNumEntries() {
                return Long.MAX_VALUE;
            }
        });
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.theStore.approximateNumEntries());
    }

    private CompositeReadOnlyKeyValueStore<Object, Object> rebalancing() {
        return new CompositeReadOnlyKeyValueStore<Object, Object>(new WrappingStoreProvider(Collections.singletonList(new StateStoreProviderStub(true))), QueryableStoreTypes.keyValueStore(), "my-store");
    }
}

