/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.internals.CompositeReadOnlySessionStore;
import org.apache.kafka.streams.state.internals.WrappingStoreProvider;
import org.apache.kafka.test.ReadOnlySessionStoreStub;
import org.apache.kafka.test.StateStoreProviderStub;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompositeReadOnlySessionStoreTest {
    private final String storeName = "session-store";
    private final StateStoreProviderStub stubProviderOne = new StateStoreProviderStub(false);
    private final StateStoreProviderStub stubProviderTwo = new StateStoreProviderStub(false);
    private final ReadOnlySessionStoreStub<String, Long> underlyingSessionStore = new ReadOnlySessionStoreStub();
    private final ReadOnlySessionStoreStub<String, Long> otherUnderlyingStore = new ReadOnlySessionStoreStub();
    private CompositeReadOnlySessionStore<String, Long> sessionStore;

    @Before
    public void before() {
        this.stubProviderOne.addStore("session-store", this.underlyingSessionStore);
        this.stubProviderOne.addStore("other-session-store", this.otherUnderlyingStore);
        this.sessionStore = new CompositeReadOnlySessionStore(new WrappingStoreProvider(Arrays.asList(this.stubProviderOne, this.stubProviderTwo)), QueryableStoreTypes.sessionStore(), "session-store");
    }

    @Test
    public void shouldFetchResulstFromUnderlyingSessionStore() {
        this.underlyingSessionStore.put(new Windowed<String>("a", new SessionWindow(0L, 0L)), 1L);
        this.underlyingSessionStore.put(new Windowed<String>("a", new SessionWindow(10L, 10L)), 2L);
        List results = StreamsTestUtils.toList(this.sessionStore.fetch("a"));
        Assert.assertEquals(Arrays.asList(KeyValue.pair(new Windowed<String>("a", new SessionWindow(0L, 0L)), 1L), KeyValue.pair(new Windowed<String>("a", new SessionWindow(10L, 10L)), 2L)), results);
    }

    @Test
    public void shouldReturnEmptyIteratorIfNoData() {
        KeyValueIterator<Windowed<String>, Long> result2 = this.sessionStore.fetch("b");
        Assert.assertFalse((boolean)result2.hasNext());
    }

    @Test
    public void shouldFindValueForKeyWhenMultiStores() {
        ReadOnlySessionStoreStub<String, Long> secondUnderlying = new ReadOnlySessionStoreStub<String, Long>();
        this.stubProviderTwo.addStore("session-store", secondUnderlying);
        Windowed<String> keyOne = new Windowed<String>("key-one", new SessionWindow(0L, 0L));
        Windowed<String> keyTwo = new Windowed<String>("key-two", new SessionWindow(0L, 0L));
        this.underlyingSessionStore.put(keyOne, 0L);
        secondUnderlying.put(keyTwo, 10L);
        List keyOneResults = StreamsTestUtils.toList(this.sessionStore.fetch("key-one"));
        List keyTwoResults = StreamsTestUtils.toList(this.sessionStore.fetch("key-two"));
        Assert.assertEquals(Collections.singletonList(KeyValue.pair(keyOne, 0L)), keyOneResults);
        Assert.assertEquals(Collections.singletonList(KeyValue.pair(keyTwo, 10L)), keyTwoResults);
    }

    @Test
    public void shouldNotGetValueFromOtherStores() {
        Windowed<String> expectedKey = new Windowed<String>("foo", new SessionWindow(0L, 0L));
        this.otherUnderlyingStore.put(new Windowed<String>("foo", new SessionWindow(10L, 10L)), 10L);
        this.underlyingSessionStore.put(expectedKey, 1L);
        KeyValueIterator<Windowed<String>, Long> result2 = this.sessionStore.fetch("foo");
        Assert.assertEquals(KeyValue.pair(expectedKey, 1L), result2.next());
        Assert.assertFalse((boolean)result2.hasNext());
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowInvalidStateStoreExceptionOnRebalance() {
        CompositeReadOnlySessionStore store = new CompositeReadOnlySessionStore(new StateStoreProviderStub(true), QueryableStoreTypes.sessionStore(), "whateva");
        store.fetch("a");
    }

    @Test
    public void shouldThrowInvalidStateStoreExceptionIfSessionFetchThrows() {
        this.underlyingSessionStore.setOpen(false);
        try {
            this.sessionStore.fetch("key");
            Assert.fail((String)"Should have thrown InvalidStateStoreException with session store");
        }
        catch (InvalidStateStoreException invalidStateStoreException) {
            // empty catch block
        }
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionIfFetchingNullKey() {
        this.sessionStore.fetch(null);
    }

    @Test
    public void shouldFetchKeyRangeAcrossStores() {
        ReadOnlySessionStoreStub<String, Long> secondUnderlying = new ReadOnlySessionStoreStub<String, Long>();
        this.stubProviderTwo.addStore("session-store", secondUnderlying);
        this.underlyingSessionStore.put(new Windowed<String>("a", new SessionWindow(0L, 0L)), 0L);
        secondUnderlying.put(new Windowed<String>("b", new SessionWindow(0L, 0L)), 10L);
        List results = StreamsTestUtils.toList(this.sessionStore.fetch("a", "b"));
        MatcherAssert.assertThat((Object)results.size(), (Matcher)IsEqual.equalTo((Object)2));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNPEIfKeyIsNull() {
        this.underlyingSessionStore.fetch(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNPEIfFromKeyIsNull() {
        this.underlyingSessionStore.fetch(null, "a");
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNPEIfToKeyIsNull() {
        this.underlyingSessionStore.fetch("a", null);
    }
}

