/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.CompositeReadOnlyWindowStore;
import org.apache.kafka.streams.state.internals.ReadOnlyWindowStoreStub;
import org.apache.kafka.streams.state.internals.WrappingStoreProvider;
import org.apache.kafka.test.StateStoreProviderStub;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class CompositeReadOnlyWindowStoreTest {
    private static final long WINDOW_SIZE = 30000L;
    private final String storeName = "window-store";
    private StateStoreProviderStub stubProviderOne;
    private StateStoreProviderStub stubProviderTwo;
    private CompositeReadOnlyWindowStore<String, String> windowStore;
    private ReadOnlyWindowStoreStub<String, String> underlyingWindowStore;
    private ReadOnlyWindowStoreStub<String, String> otherUnderlyingStore;
    @Rule
    public final ExpectedException windowStoreIteratorException = ExpectedException.none();

    @Before
    public void before() {
        this.stubProviderOne = new StateStoreProviderStub(false);
        this.stubProviderTwo = new StateStoreProviderStub(false);
        this.underlyingWindowStore = new ReadOnlyWindowStoreStub(30000L);
        this.stubProviderOne.addStore("window-store", this.underlyingWindowStore);
        this.otherUnderlyingStore = new ReadOnlyWindowStoreStub(30000L);
        this.stubProviderOne.addStore("other-window-store", this.otherUnderlyingStore);
        this.windowStore = new CompositeReadOnlyWindowStore(new WrappingStoreProvider(Arrays.asList(this.stubProviderOne, this.stubProviderTwo)), QueryableStoreTypes.windowStore(), "window-store");
    }

    @Test
    public void shouldFetchValuesFromWindowStore() {
        this.underlyingWindowStore.put("my-key", "my-value", 0L);
        this.underlyingWindowStore.put("my-key", "my-later-value", 10L);
        WindowStoreIterator<String> iterator = this.windowStore.fetch("my-key", 0L, 25L);
        List results = StreamsTestUtils.toList(iterator);
        Assert.assertEquals(Arrays.asList(new KeyValue<Long, String>(0L, "my-value"), new KeyValue<Long, String>(10L, "my-later-value")), results);
    }

    @Test
    public void shouldReturnEmptyIteratorIfNoData() {
        WindowStoreIterator<String> iterator = this.windowStore.fetch("my-key", 0L, 25L);
        Assert.assertEquals((Object)false, (Object)iterator.hasNext());
    }

    @Test
    public void shouldFindValueForKeyWhenMultiStores() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("key-one", "value-one", 0L);
        secondUnderlying.put("key-two", "value-two", 10L);
        List keyOneResults = StreamsTestUtils.toList(this.windowStore.fetch("key-one", 0L, 1L));
        List keyTwoResults = StreamsTestUtils.toList(this.windowStore.fetch("key-two", 10L, 11L));
        Assert.assertEquals(Collections.singletonList(KeyValue.pair(0L, "value-one")), keyOneResults);
        Assert.assertEquals(Collections.singletonList(KeyValue.pair(10L, "value-two")), keyTwoResults);
    }

    @Test
    public void shouldNotGetValuesFromOtherStores() {
        this.otherUnderlyingStore.put("some-key", "some-value", 0L);
        this.underlyingWindowStore.put("some-key", "my-value", 1L);
        List results = StreamsTestUtils.toList(this.windowStore.fetch("some-key", 0L, 2L));
        Assert.assertEquals(Collections.singletonList(new KeyValue<Long, String>(1L, "my-value")), results);
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowInvalidStateStoreExceptionOnRebalance() {
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore(new StateStoreProviderStub(true), QueryableStoreTypes.windowStore(), "foo");
        store.fetch("key", 1L, 10L);
    }

    @Test
    public void shouldThrowInvalidStateStoreExceptionIfFetchThrows() {
        this.underlyingWindowStore.setOpen(false);
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore(this.stubProviderOne, QueryableStoreTypes.windowStore(), "window-store");
        try {
            store.fetch("key", 1L, 10L);
            Assert.fail((String)"InvalidStateStoreException was expected");
        }
        catch (InvalidStateStoreException e) {
            Assert.assertEquals((Object)"State store is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.", (Object)e.getMessage());
        }
    }

    @Test
    public void emptyIteratorAlwaysReturnsFalse() {
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore(new StateStoreProviderStub(false), QueryableStoreTypes.windowStore(), "foo");
        WindowStoreIterator windowStoreIterator = store.fetch("key", 1L, 10L);
        Assert.assertFalse((boolean)windowStoreIterator.hasNext());
    }

    @Test
    public void emptyIteratorPeekNextKeyShouldThrowNoSuchElementException() {
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore(new StateStoreProviderStub(false), QueryableStoreTypes.windowStore(), "foo");
        WindowStoreIterator windowStoreIterator = store.fetch("key", 1L, 10L);
        this.windowStoreIteratorException.expect(NoSuchElementException.class);
        windowStoreIterator.peekNextKey();
    }

    @Test
    public void emptyIteratorNextShouldThrowNoSuchElementException() {
        CompositeReadOnlyWindowStore store = new CompositeReadOnlyWindowStore(new StateStoreProviderStub(false), QueryableStoreTypes.windowStore(), "foo");
        WindowStoreIterator windowStoreIterator = store.fetch("key", 1L, 10L);
        this.windowStoreIteratorException.expect(NoSuchElementException.class);
        windowStoreIterator.next();
    }

    @Test
    public void shouldFetchKeyRangeAcrossStores() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("a", "a", 0L);
        secondUnderlying.put("b", "b", 10L);
        List results = StreamsTestUtils.toList(this.windowStore.fetch("a", "b", 0L, 10L));
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair(new Windowed<String>("a", new TimeWindow(0L, 30000L)), "a"), KeyValue.pair(new Windowed<String>("b", new TimeWindow(10L, 30010L)), "b"))));
    }

    @Test
    public void shouldGetAllAcrossStores() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("a", "a", 0L);
        secondUnderlying.put("b", "b", 10L);
        List results = StreamsTestUtils.toList(this.windowStore.all());
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair(new Windowed<String>("a", new TimeWindow(0L, 30000L)), "a"), KeyValue.pair(new Windowed<String>("b", new TimeWindow(10L, 30010L)), "b"))));
    }

    @Test
    public void shouldFetchAllAcrossStores() {
        ReadOnlyWindowStoreStub<String, String> secondUnderlying = new ReadOnlyWindowStoreStub<String, String>(30000L);
        this.stubProviderTwo.addStore("window-store", secondUnderlying);
        this.underlyingWindowStore.put("a", "a", 0L);
        secondUnderlying.put("b", "b", 10L);
        List results = StreamsTestUtils.toList(this.windowStore.fetchAll(0L, 10L));
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair(new Windowed<String>("a", new TimeWindow(0L, 30000L)), "a"), KeyValue.pair(new Windowed<String>("b", new TimeWindow(10L, 30010L)), "b"))));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNPEIfKeyIsNull() {
        this.windowStore.fetch(null, 0L, 0L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNPEIfFromKeyIsNull() {
        this.windowStore.fetch(null, "a", 0L, 0L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNPEIfToKeyIsNull() {
        this.windowStore.fetch("a", null, 0L, 0L);
    }
}

