/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;

class DelegatingPeekingKeyValueIterator<K, V>
implements KeyValueIterator<K, V>,
PeekingKeyValueIterator<K, V> {
    private final KeyValueIterator<K, V> underlying;
    private final String storeName;
    private KeyValue<K, V> next;
    private volatile boolean open = true;

    public DelegatingPeekingKeyValueIterator(String storeName, KeyValueIterator<K, V> underlying) {
        this.storeName = storeName;
        this.underlying = underlying;
    }

    @Override
    public synchronized K peekNextKey() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next.key;
    }

    @Override
    public synchronized void close() {
        this.underlying.close();
        this.open = false;
    }

    @Override
    public synchronized boolean hasNext() {
        if (!this.open) {
            throw new InvalidStateStoreException(String.format("Store %s has closed", this.storeName));
        }
        if (this.next != null) {
            return true;
        }
        if (!this.underlying.hasNext()) {
            return false;
        }
        this.next = (KeyValue)this.underlying.next();
        return true;
    }

    @Override
    public synchronized KeyValue<K, V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        KeyValue<K, V> result2 = this.next;
        this.next = null;
        return result2;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported in " + this.getClass().getName());
    }

    @Override
    public KeyValue<K, V> peekNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next;
    }
}

