/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DelegatingPeekingKeyValueIteratorTest {
    private final String name = "name";
    private InMemoryKeyValueStore<String, String> store;

    @Before
    public void setUp() {
        this.store = new InMemoryKeyValueStore<String, String>("name", Serdes.String(), Serdes.String());
    }

    @Test
    public void shouldPeekNextKey() {
        this.store.put("A", "A");
        DelegatingPeekingKeyValueIterator<String, String> peekingIterator = new DelegatingPeekingKeyValueIterator<String, String>("name", this.store.all());
        Assert.assertEquals((Object)"A", (Object)peekingIterator.peekNextKey());
        Assert.assertEquals((Object)"A", (Object)peekingIterator.peekNextKey());
        Assert.assertTrue((boolean)peekingIterator.hasNext());
        peekingIterator.close();
    }

    @Test
    public void shouldPeekNext() {
        this.store.put("A", "A");
        DelegatingPeekingKeyValueIterator<String, String> peekingIterator = new DelegatingPeekingKeyValueIterator<String, String>("name", this.store.all());
        Assert.assertEquals(KeyValue.pair("A", "A"), peekingIterator.peekNext());
        Assert.assertEquals(KeyValue.pair("A", "A"), peekingIterator.peekNext());
        Assert.assertTrue((boolean)peekingIterator.hasNext());
        peekingIterator.close();
    }

    @Test
    public void shouldPeekAndIterate() {
        String[] kvs;
        for (String kv : kvs = new String[]{"a", "b", "c", "d", "e", "f"}) {
            this.store.put(kv, kv);
        }
        DelegatingPeekingKeyValueIterator<String, String> peekingIterator = new DelegatingPeekingKeyValueIterator<String, String>("name", this.store.all());
        int index = 0;
        while (peekingIterator.hasNext()) {
            String peekNext = peekingIterator.peekNextKey();
            String key = (String)((KeyValue)peekingIterator.next()).key;
            Assert.assertEquals((Object)kvs[index], (Object)peekNext);
            Assert.assertEquals((Object)kvs[index], (Object)key);
            ++index;
        }
        Assert.assertEquals((long)kvs.length, (long)index);
        peekingIterator.close();
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldThrowNoSuchElementWhenNoMoreItemsLeftAndNextCalled() {
        DelegatingPeekingKeyValueIterator<String, String> peekingIterator = new DelegatingPeekingKeyValueIterator<String, String>("name", this.store.all());
        peekingIterator.next();
        peekingIterator.close();
    }

    @Test(expected=NoSuchElementException.class)
    public void shouldThrowNoSuchElementWhenNoMoreItemsLeftAndPeekNextCalled() {
        DelegatingPeekingKeyValueIterator<String, String> peekingIterator = new DelegatingPeekingKeyValueIterator<String, String>("name", this.store.all());
        peekingIterator.peekNextKey();
        peekingIterator.close();
    }
}

