/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.CacheFunction;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.FilteredCacheIterator;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilteredCacheIteratorTest {
    private static final CacheFunction IDENTITY_FUNCTION = new CacheFunction(){

        @Override
        public Bytes key(Bytes cacheKey) {
            return cacheKey;
        }

        @Override
        public Bytes cacheKey(Bytes key) {
            return key;
        }
    };
    private final InMemoryKeyValueStore<Bytes, LRUCacheEntry> store = new InMemoryKeyValueStore("name", null, null);
    private final KeyValue<Bytes, LRUCacheEntry> firstEntry = KeyValue.pair(Bytes.wrap("a".getBytes()), new LRUCacheEntry("1".getBytes()));
    private final List<KeyValue<Bytes, LRUCacheEntry>> entries = Utils.mkList(this.firstEntry, KeyValue.pair(Bytes.wrap("b".getBytes()), new LRUCacheEntry("2".getBytes())), KeyValue.pair(Bytes.wrap("c".getBytes()), new LRUCacheEntry("3".getBytes())));
    private FilteredCacheIterator allIterator;
    private FilteredCacheIterator firstEntryIterator;

    @Before
    public void before() {
        this.store.putAll(this.entries);
        HasNextCondition allCondition = new HasNextCondition(){

            @Override
            public boolean hasNext(KeyValueIterator<Bytes, ?> iterator) {
                return iterator.hasNext();
            }
        };
        this.allIterator = new FilteredCacheIterator(new DelegatingPeekingKeyValueIterator<Bytes, LRUCacheEntry>("", this.store.all()), allCondition, IDENTITY_FUNCTION);
        HasNextCondition firstEntryCondition = new HasNextCondition(){

            @Override
            public boolean hasNext(KeyValueIterator<Bytes, ?> iterator) {
                return iterator.hasNext() && iterator.peekNextKey().equals(((FilteredCacheIteratorTest)FilteredCacheIteratorTest.this).firstEntry.key);
            }
        };
        this.firstEntryIterator = new FilteredCacheIterator(new DelegatingPeekingKeyValueIterator<Bytes, LRUCacheEntry>("", this.store.all()), firstEntryCondition, IDENTITY_FUNCTION);
    }

    @Test
    public void shouldAllowEntryMatchingHasNextCondition() {
        List<KeyValue<Bytes, LRUCacheEntry>> keyValues = StreamsTestUtils.toList(this.allIterator);
        MatcherAssert.assertThat(keyValues, (Matcher)CoreMatchers.equalTo(this.entries));
    }

    @Test
    public void shouldPeekNextKey() {
        while (this.allIterator.hasNext()) {
            Bytes nextKey = this.allIterator.peekNextKey();
            Object next = this.allIterator.next();
            MatcherAssert.assertThat(((KeyValue)next).key, (Matcher)CoreMatchers.equalTo((Object)nextKey));
        }
    }

    @Test
    public void shouldPeekNext() {
        while (this.allIterator.hasNext()) {
            KeyValue<Bytes, LRUCacheEntry> peeked = this.allIterator.peekNext();
            Object next = this.allIterator.next();
            MatcherAssert.assertThat(peeked, (Matcher)CoreMatchers.equalTo((Object)next));
        }
    }

    @Test
    public void shouldNotHaveNextIfHasNextConditionNotMet() {
        Assert.assertTrue((boolean)this.firstEntryIterator.hasNext());
        this.firstEntryIterator.next();
        Assert.assertFalse((boolean)this.firstEntryIterator.hasNext());
    }

    @Test
    public void shouldFilterEntriesNotMatchingHasNextCondition() {
        List<KeyValue<Bytes, LRUCacheEntry>> keyValues = StreamsTestUtils.toList(this.firstEntryIterator);
        MatcherAssert.assertThat(keyValues, (Matcher)CoreMatchers.equalTo(Utils.mkList(this.firstEntry)));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowUnsupportedOperationExeceptionOnRemove() {
        this.allIterator.remove();
    }
}

