/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.MemoryLRUCache;
import org.apache.kafka.streams.state.internals.StoreChangeLogger;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class InMemoryKeyValueLoggedStore<K, V>
extends WrappedStateStore.AbstractStateStore
implements KeyValueStore<K, V> {
    private final KeyValueStore<K, V> inner;
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private StoreChangeLogger<K, V> changeLogger;

    InMemoryKeyValueLoggedStore(KeyValueStore<K, V> inner, Serde<K> keySerde, Serde<V> valueSerde) {
        super(inner);
        this.inner = inner;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.inner.init(context, root);
        StateSerdes serdes = new StateSerdes(ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.inner.name()), this.keySerde == null ? context.keySerde() : this.keySerde, this.valueSerde == null ? context.valueSerde() : this.valueSerde);
        this.changeLogger = new StoreChangeLogger(this.inner.name(), context, serdes);
        if (this.inner instanceof MemoryLRUCache) {
            ((MemoryLRUCache)this.inner).whenEldestRemoved(new MemoryLRUCache.EldestEntryRemovalListener<K, V>(){

                @Override
                public void apply(K key, V value) {
                    InMemoryKeyValueLoggedStore.this.removed(key);
                }
            });
        }
    }

    @Override
    public long approximateNumEntries() {
        return this.inner.approximateNumEntries();
    }

    @Override
    public V get(K key) {
        return this.inner.get(key);
    }

    @Override
    public void put(K key, V value) {
        this.inner.put(key, value);
        this.changeLogger.logChange(key, value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V originalValue = this.inner.putIfAbsent(key, value);
        if (originalValue == null) {
            this.changeLogger.logChange(key, value);
        }
        return originalValue;
    }

    @Override
    public void putAll(List<KeyValue<K, V>> entries) {
        this.inner.putAll(entries);
        for (KeyValue<K, V> entry : entries) {
            Object key = entry.key;
            this.changeLogger.logChange(key, entry.value);
        }
    }

    @Override
    public V delete(K key) {
        V value = this.inner.delete(key);
        this.removed(key);
        return value;
    }

    protected void removed(K key) {
        this.changeLogger.logChange(key, null);
    }

    @Override
    public KeyValueIterator<K, V> range(K from, K to) {
        return this.inner.range(from, to);
    }

    @Override
    public KeyValueIterator<K, V> all() {
        return this.inner.all();
    }
}

