/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.AbstractKeyValueStoreTest;
import org.junit.Assert;
import org.junit.Test;

public class InMemoryKeyValueLoggedStoreTest
extends AbstractKeyValueStoreTest {
    @Override
    protected <K, V> KeyValueStore<K, V> createKeyValueStore(ProcessorContext context) {
        StoreBuilder<KeyValueStore<?, ?>> storeBuilder = Stores.keyValueStoreBuilder(Stores.inMemoryKeyValueStore("my-store"), context.keySerde(), context.valueSerde()).withLoggingEnabled(Collections.singletonMap("retention.ms", "1000"));
        KeyValueStore<?, ?> store = storeBuilder.build();
        store.init(context, store);
        return store;
    }

    @Test
    public void shouldPutAll() {
        ArrayList entries = new ArrayList();
        entries.add(new KeyValue<Integer, String>(1, "1"));
        entries.add(new KeyValue<Integer, String>(2, "2"));
        this.store.putAll(entries);
        Assert.assertEquals(this.store.get(1), (Object)"1");
        Assert.assertEquals(this.store.get(2), (Object)"2");
    }
}

