/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueLoggedStore;

public class InMemoryKeyValueStore<K, V>
implements KeyValueStore<K, V> {
    private final String name;
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private final NavigableMap<K, V> map;
    private volatile boolean open = false;
    private StateSerdes<K, V> serdes;

    public InMemoryKeyValueStore(String name, Serde<K> keySerde, Serde<V> valueSerde) {
        this.name = name;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.map = new TreeMap();
    }

    public KeyValueStore<K, V> enableLogging() {
        return new InMemoryKeyValueLoggedStore<K, V>(this, this.keySerde, this.valueSerde);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.serdes = new StateSerdes(ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.name), this.keySerde == null ? context.keySerde() : this.keySerde, this.valueSerde == null ? context.valueSerde() : this.valueSerde);
        if (root != null) {
            context.register(root, false, new StateRestoreCallback(){

                @Override
                public void restore(byte[] key, byte[] value) {
                    if (value == null) {
                        InMemoryKeyValueStore.this.delete(InMemoryKeyValueStore.this.serdes.keyFrom(key));
                    } else {
                        InMemoryKeyValueStore.this.put(InMemoryKeyValueStore.this.serdes.keyFrom(key), InMemoryKeyValueStore.this.serdes.valueFrom(value));
                    }
                }
            });
        }
        this.open = true;
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public synchronized V get(K key) {
        return this.map.get(key);
    }

    @Override
    public synchronized void put(K key, V value) {
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, value);
        }
    }

    @Override
    public synchronized V putIfAbsent(K key, V value) {
        V originalValue = this.get(key);
        if (originalValue == null) {
            this.put(key, value);
        }
        return originalValue;
    }

    @Override
    public synchronized void putAll(List<KeyValue<K, V>> entries) {
        for (KeyValue<K, V> entry : entries) {
            this.put(entry.key, entry.value);
        }
    }

    @Override
    public synchronized V delete(K key) {
        return this.map.remove(key);
    }

    @Override
    public synchronized KeyValueIterator<K, V> range(K from, K to) {
        return new DelegatingPeekingKeyValueIterator(this.name, new InMemoryKeyValueIterator(this.map.subMap(from, true, to, true).entrySet().iterator()));
    }

    @Override
    public synchronized KeyValueIterator<K, V> all() {
        TreeMap<K, V> copy = new TreeMap<K, V>(this.map);
        return new DelegatingPeekingKeyValueIterator(this.name, new InMemoryKeyValueIterator(copy.entrySet().iterator()));
    }

    @Override
    public long approximateNumEntries() {
        return this.map.size();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.map.clear();
        this.open = false;
    }

    private static class InMemoryKeyValueIterator<K, V>
    implements KeyValueIterator<K, V> {
        private final Iterator<Map.Entry<K, V>> iter;

        private InMemoryKeyValueIterator(Iterator<Map.Entry<K, V>> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public KeyValue<K, V> next() {
            Map.Entry<K, V> entry = this.iter.next();
            return new KeyValue<K, V>(entry.getKey(), entry.getValue());
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        @Override
        public void close() {
        }

        @Override
        public K peekNextKey() {
            throw new UnsupportedOperationException("peekNextKey() not supported in " + this.getClass().getName());
        }
    }
}

