/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.AbstractKeyValueStoreTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class InMemoryLRUCacheStoreTest
extends AbstractKeyValueStoreTest {
    @Override
    protected <K, V> KeyValueStore<K, V> createKeyValueStore(ProcessorContext context) {
        StoreBuilder<KeyValueStore<?, ?>> storeBuilder = Stores.keyValueStoreBuilder(Stores.lruMap("my-store", 10), context.keySerde(), context.valueSerde());
        KeyValueStore<?, ?> store = storeBuilder.build();
        store.init(context, store);
        return store;
    }

    @Test
    public void shouldPutAllKeyValuePairs() {
        List kvPairs = Arrays.asList(KeyValue.pair(1, "1"), KeyValue.pair(2, "2"), KeyValue.pair(3, "3"));
        this.store.putAll(kvPairs);
        Assert.assertThat((Object)this.store.approximateNumEntries(), (Matcher)CoreMatchers.equalTo((Object)3L));
        for (KeyValue kvPair : kvPairs) {
            Assert.assertThat(this.store.get(kvPair.key), (Matcher)CoreMatchers.equalTo(kvPair.value));
        }
    }

    @Test
    public void shouldUpdateValuesForExistingKeysOnPutAll() {
        List kvPairs = Arrays.asList(KeyValue.pair(1, "1"), KeyValue.pair(2, "2"), KeyValue.pair(3, "3"));
        this.store.putAll(kvPairs);
        List updatedKvPairs = Arrays.asList(KeyValue.pair(1, "ONE"), KeyValue.pair(2, "TWO"), KeyValue.pair(3, "THREE"));
        this.store.putAll(updatedKvPairs);
        Assert.assertThat((Object)this.store.approximateNumEntries(), (Matcher)CoreMatchers.equalTo((Object)3L));
        for (KeyValue kvPair : updatedKvPairs) {
            Assert.assertThat(this.store.get(kvPair.key), (Matcher)CoreMatchers.equalTo(kvPair.value));
        }
    }

    @Test
    public void testEvict() {
        this.store.put(0, "zero");
        this.store.put(1, "one");
        this.store.put(2, "two");
        this.store.put(3, "three");
        this.store.put(4, "four");
        this.store.put(5, "five");
        this.store.put(6, "six");
        this.store.put(7, "seven");
        this.store.put(8, "eight");
        this.store.put(9, "nine");
        Assert.assertEquals((long)10L, (long)this.driver.sizeOf(this.store));
        this.store.put(10, "ten");
        this.store.flush();
        Assert.assertEquals((long)10L, (long)this.driver.sizeOf(this.store));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(0));
        Assert.assertEquals((long)1L, (long)this.driver.numFlushedEntryRemoved());
        this.store.delete(1);
        this.store.flush();
        Assert.assertEquals((long)9L, (long)this.driver.sizeOf(this.store));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(0));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(1));
        Assert.assertEquals((long)2L, (long)this.driver.numFlushedEntryRemoved());
        this.store.put(11, "eleven");
        this.store.flush();
        Assert.assertEquals((long)10L, (long)this.driver.sizeOf(this.store));
        Assert.assertEquals((long)2L, (long)this.driver.numFlushedEntryRemoved());
        this.store.put(2, "two-again");
        this.store.flush();
        Assert.assertEquals((long)10L, (long)this.driver.sizeOf(this.store));
        Assert.assertEquals((long)2L, (long)this.driver.numFlushedEntryRemoved());
        this.store.put(12, "twelve");
        this.store.flush();
        Assert.assertEquals((long)10L, (long)this.driver.sizeOf(this.store));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(0));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(1));
        Assert.assertTrue((boolean)this.driver.flushedEntryRemoved(3));
        Assert.assertEquals((long)3L, (long)this.driver.numFlushedEntryRemoved());
    }

    @Test
    public void testRestoreEvict() {
        this.store.close();
        this.driver.addEntryToRestoreLog(0, "zero");
        this.driver.addEntryToRestoreLog(1, "one");
        this.driver.addEntryToRestoreLog(2, "two");
        this.driver.addEntryToRestoreLog(3, "three");
        this.driver.addEntryToRestoreLog(4, "four");
        this.driver.addEntryToRestoreLog(5, "five");
        this.driver.addEntryToRestoreLog(6, "fix");
        this.driver.addEntryToRestoreLog(7, "seven");
        this.driver.addEntryToRestoreLog(8, "eight");
        this.driver.addEntryToRestoreLog(9, "nine");
        this.driver.addEntryToRestoreLog(10, "ten");
        this.store = this.createKeyValueStore(this.driver.context());
        this.context.restore(this.store.name(), this.driver.restoredEntries());
        Assert.assertEquals((long)0L, (long)this.driver.numFlushedEntryStored());
        Assert.assertEquals((long)0L, (long)this.driver.numFlushedEntryRemoved());
        Assert.assertEquals((long)10L, (long)this.driver.sizeOf(this.store));
    }
}

