/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.Iterator;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionKeySerde;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCacheSessionStoreIterator;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class MergedSortedCacheWrappedSessionStoreIteratorTest {
    private static final SegmentedCacheFunction SINGLE_SEGMENT_CACHE_FUNCTION = new SegmentedCacheFunction(null, -1L){

        @Override
        public long segmentId(Bytes key) {
            return 0L;
        }
    };
    private final Bytes storeKey = Bytes.wrap("a".getBytes());
    private final Bytes cacheKey = Bytes.wrap("b".getBytes());
    private final SessionWindow storeWindow = new SessionWindow(0L, 1L);
    private final Iterator<KeyValue<Windowed<Bytes>, byte[]>> storeKvs = Collections.singleton(KeyValue.pair(new Windowed<Bytes>(this.storeKey, this.storeWindow), this.storeKey.get())).iterator();
    private final SessionWindow cacheWindow = new SessionWindow(10L, 20L);
    private final Iterator<KeyValue<Bytes, LRUCacheEntry>> cacheKvs = Collections.singleton(KeyValue.pair(SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(SessionKeySerde.bytesToBinary(new Windowed<Bytes>(this.cacheKey, this.cacheWindow))), new LRUCacheEntry(this.cacheKey.get()))).iterator();

    @Test
    public void shouldHaveNextFromStore() {
        MergedSortedCacheSessionStoreIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator());
        Assert.assertTrue((boolean)mergeIterator.hasNext());
    }

    @Test
    public void shouldGetNextFromStore() {
        MergedSortedCacheSessionStoreIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator());
        MatcherAssert.assertThat((Object)mergeIterator.next(), (Matcher)CoreMatchers.equalTo(KeyValue.pair(new Windowed<Bytes>(this.storeKey, this.storeWindow), this.storeKey.get())));
    }

    @Test
    public void shouldPeekNextKeyFromStore() {
        MergedSortedCacheSessionStoreIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator());
        MatcherAssert.assertThat(mergeIterator.peekNextKey(), (Matcher)CoreMatchers.equalTo(new Windowed<Bytes>(this.storeKey, this.storeWindow)));
    }

    @Test
    public void shouldHaveNextFromCache() {
        MergedSortedCacheSessionStoreIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs);
        Assert.assertTrue((boolean)mergeIterator.hasNext());
    }

    @Test
    public void shouldGetNextFromCache() {
        MergedSortedCacheSessionStoreIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs);
        MatcherAssert.assertThat((Object)mergeIterator.next(), (Matcher)CoreMatchers.equalTo(KeyValue.pair(new Windowed<Bytes>(this.cacheKey, this.cacheWindow), this.cacheKey.get())));
    }

    @Test
    public void shouldPeekNextKeyFromCache() {
        MergedSortedCacheSessionStoreIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs);
        MatcherAssert.assertThat(mergeIterator.peekNextKey(), (Matcher)CoreMatchers.equalTo(new Windowed<Bytes>(this.cacheKey, this.cacheWindow)));
    }

    @Test
    public void shouldIterateBothStoreAndCache() {
        MergedSortedCacheSessionStoreIterator iterator = this.createIterator(this.storeKvs, this.cacheKvs);
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)CoreMatchers.equalTo(KeyValue.pair(new Windowed<Bytes>(this.storeKey, this.storeWindow), this.storeKey.get())));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)CoreMatchers.equalTo(KeyValue.pair(new Windowed<Bytes>(this.cacheKey, this.cacheWindow), this.cacheKey.get())));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private MergedSortedCacheSessionStoreIterator createIterator(Iterator<KeyValue<Windowed<Bytes>, byte[]>> storeKvs, Iterator<KeyValue<Bytes, LRUCacheEntry>> cacheKvs) {
        DelegatingPeekingKeyValueIterator<Windowed<Bytes>, byte[]> storeIterator = new DelegatingPeekingKeyValueIterator<Windowed<Bytes>, byte[]>("store", new KeyValueIteratorStub(storeKvs));
        DelegatingPeekingKeyValueIterator<Bytes, LRUCacheEntry> cacheIterator = new DelegatingPeekingKeyValueIterator<Bytes, LRUCacheEntry>("cache", new KeyValueIteratorStub(cacheKvs));
        return new MergedSortedCacheSessionStoreIterator(cacheIterator, storeIterator, SINGLE_SEGMENT_CACHE_FUNCTION);
    }
}

