/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCacheWindowStoreIterator;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class MergedSortedCacheWrappedWindowStoreIteratorTest {
    private static final SegmentedCacheFunction SINGLE_SEGMENT_CACHE_FUNCTION = new SegmentedCacheFunction(null, -1L){

        @Override
        public long segmentId(Bytes key) {
            return 0L;
        }
    };
    private final List<KeyValue<Long, byte[]>> windowStoreKvPairs = new ArrayList<KeyValue<Long, byte[]>>();
    private final ThreadCache cache = new ThreadCache(new LogContext("testCache "), 1000000L, new MockStreamsMetrics(new Metrics()));
    private final String namespace = "0.0-one";
    private final StateSerdes<String, String> stateSerdes = new StateSerdes<String, String>("foo", Serdes.String(), Serdes.String());

    @Test
    public void shouldIterateOverValueFromBothIterators() {
        ArrayList<KeyValue<Long, byte[]>> expectedKvPairs = new ArrayList<KeyValue<Long, byte[]>>();
        for (long t = 0L; t < 100L; t += 20L) {
            byte[] v1Bytes = String.valueOf(t).getBytes();
            KeyValue<Long, byte[]> v1 = KeyValue.pair(t, v1Bytes);
            this.windowStoreKvPairs.add(v1);
            expectedKvPairs.add(KeyValue.pair(t, v1Bytes));
            Bytes keyBytes = WindowStoreUtils.toBinaryKey("a", t + 10L, 0, this.stateSerdes);
            byte[] valBytes = String.valueOf(t + 10L).getBytes();
            expectedKvPairs.add(KeyValue.pair(t + 10L, valBytes));
            this.cache.put("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(keyBytes), new LRUCacheEntry(valBytes));
        }
        Bytes fromBytes = WindowStoreUtils.toBinaryKey("a", 0L, 0, this.stateSerdes);
        Bytes toBytes = WindowStoreUtils.toBinaryKey("a", 100L, 0, this.stateSerdes);
        DelegatingPeekingKeyValueIterator<Long, byte[]> storeIterator = new DelegatingPeekingKeyValueIterator<Long, byte[]>("store", new KeyValueIteratorStub(this.windowStoreKvPairs.iterator()));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.range("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(fromBytes), SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(toBytes));
        MergedSortedCacheWindowStoreIterator iterator = new MergedSortedCacheWindowStoreIterator((PeekingKeyValueIterator<Bytes, LRUCacheEntry>)cacheIterator, (KeyValueIterator<Long, byte[]>)storeIterator);
        int index = 0;
        while (iterator.hasNext()) {
            Object next = iterator.next();
            KeyValue expected = (KeyValue)expectedKvPairs.get(index++);
            Assert.assertArrayEquals((byte[])((byte[])expected.value), (byte[])((byte[])((KeyValue)next).value));
            Assert.assertEquals(expected.key, ((KeyValue)next).key);
        }
        iterator.close();
    }

    @Test
    public void shouldPeekNextStoreKey() {
        this.windowStoreKvPairs.add(KeyValue.pair(10L, "a".getBytes()));
        this.cache.put("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(WindowStoreUtils.toBinaryKey("a", 0L, 0, this.stateSerdes)), new LRUCacheEntry("b".getBytes()));
        Bytes fromBytes = WindowStoreUtils.toBinaryKey("a", 0L, 0, this.stateSerdes);
        Bytes toBytes = WindowStoreUtils.toBinaryKey("a", 100L, 0, this.stateSerdes);
        DelegatingPeekingKeyValueIterator<Long, byte[]> storeIterator = new DelegatingPeekingKeyValueIterator<Long, byte[]>("store", new KeyValueIteratorStub(this.windowStoreKvPairs.iterator()));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.range("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(fromBytes), SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(toBytes));
        MergedSortedCacheWindowStoreIterator iterator = new MergedSortedCacheWindowStoreIterator((PeekingKeyValueIterator<Bytes, LRUCacheEntry>)cacheIterator, (KeyValueIterator<Long, byte[]>)storeIterator);
        MatcherAssert.assertThat(iterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)0L));
        iterator.next();
        MatcherAssert.assertThat(iterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)10L));
        iterator.close();
    }

    @Test
    public void shouldPeekNextCacheKey() {
        this.windowStoreKvPairs.add(KeyValue.pair(0L, "a".getBytes()));
        this.cache.put("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(WindowStoreUtils.toBinaryKey("a", 10L, 0, this.stateSerdes)), new LRUCacheEntry("b".getBytes()));
        Bytes fromBytes = WindowStoreUtils.toBinaryKey("a", 0L, 0, this.stateSerdes);
        Bytes toBytes = WindowStoreUtils.toBinaryKey("a", 100L, 0, this.stateSerdes);
        DelegatingPeekingKeyValueIterator<Long, byte[]> storeIterator = new DelegatingPeekingKeyValueIterator<Long, byte[]>("store", new KeyValueIteratorStub(this.windowStoreKvPairs.iterator()));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.range("0.0-one", SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(fromBytes), SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(toBytes));
        MergedSortedCacheWindowStoreIterator iterator = new MergedSortedCacheWindowStoreIterator((PeekingKeyValueIterator<Bytes, LRUCacheEntry>)cacheIterator, (KeyValueIterator<Long, byte[]>)storeIterator);
        MatcherAssert.assertThat(iterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)0L));
        iterator.next();
        MatcherAssert.assertThat(iterator.peekNextKey(), (Matcher)CoreMatchers.equalTo((Object)10L));
        iterator.close();
    }
}

