/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.Iterator;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCacheWindowStoreKeyValueIterator;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class MergedSortedCacheWrappedWindowStoreKeyValueIteratorTest {
    private static final SegmentedCacheFunction SINGLE_SEGMENT_CACHE_FUNCTION = new SegmentedCacheFunction(null, -1L){

        @Override
        public long segmentId(Bytes key) {
            return 0L;
        }
    };
    private static final int WINDOW_SIZE = 10;
    private final String storeKey = "a";
    private final String cacheKey = "b";
    private final TimeWindow storeWindow = new TimeWindow(0L, 1L);
    private final Iterator<KeyValue<Windowed<Bytes>, byte[]>> storeKvs = Collections.singleton(KeyValue.pair(new Windowed<Bytes>(Bytes.wrap("a".getBytes()), this.storeWindow), "a".getBytes())).iterator();
    private final TimeWindow cacheWindow = new TimeWindow(10L, 20L);
    private final Iterator<KeyValue<Bytes, LRUCacheEntry>> cacheKvs = Collections.singleton(KeyValue.pair(SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(WindowStoreUtils.toBinaryKey("b", this.cacheWindow.start(), 0, new StateSerdes<String, String>("dummy", Serdes.String(), Serdes.String()))), new LRUCacheEntry("b".getBytes()))).iterator();
    private Deserializer<String> deserializer = Serdes.String().deserializer();

    @Test
    public void shouldHaveNextFromStore() {
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator());
        Assert.assertTrue((boolean)mergeIterator.hasNext());
    }

    @Test
    public void shouldGetNextFromStore() {
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator());
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)mergeIterator.next()), (Matcher)CoreMatchers.equalTo(KeyValue.pair(new Windowed<String>("a", this.storeWindow), "a")));
    }

    @Test
    public void shouldPeekNextKeyFromStore() {
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator());
        MatcherAssert.assertThat(this.convertWindowedKey((Windowed)mergeIterator.peekNextKey()), (Matcher)CoreMatchers.equalTo(new Windowed<String>("a", this.storeWindow)));
    }

    @Test
    public void shouldHaveNextFromCache() {
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs);
        Assert.assertTrue((boolean)mergeIterator.hasNext());
    }

    @Test
    public void shouldGetNextFromCache() {
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs);
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)mergeIterator.next()), (Matcher)CoreMatchers.equalTo(KeyValue.pair(new Windowed<String>("b", this.cacheWindow), "b")));
    }

    @Test
    public void shouldPeekNextKeyFromCache() {
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs);
        MatcherAssert.assertThat(this.convertWindowedKey((Windowed)mergeIterator.peekNextKey()), (Matcher)CoreMatchers.equalTo(new Windowed<String>("b", this.cacheWindow)));
    }

    @Test
    public void shouldIterateBothStoreAndCache() {
        MergedSortedCacheWindowStoreKeyValueIterator iterator = this.createIterator(this.storeKvs, this.cacheKvs);
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)iterator.next()), (Matcher)CoreMatchers.equalTo(KeyValue.pair(new Windowed<String>("a", this.storeWindow), "a")));
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)iterator.next()), (Matcher)CoreMatchers.equalTo(KeyValue.pair(new Windowed<String>("b", this.cacheWindow), "b")));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private KeyValue<Windowed<String>, String> convertKeyValuePair(KeyValue<Windowed<Bytes>, byte[]> next) {
        String value = this.deserializer.deserialize("", (byte[])next.value);
        return KeyValue.pair(this.convertWindowedKey((Windowed)next.key), value);
    }

    private Windowed<String> convertWindowedKey(Windowed<Bytes> bytesWindowed) {
        String key = this.deserializer.deserialize("", bytesWindowed.key().get());
        return new Windowed<String>(key, bytesWindowed.window());
    }

    private MergedSortedCacheWindowStoreKeyValueIterator createIterator(Iterator<KeyValue<Windowed<Bytes>, byte[]>> storeKvs, Iterator<KeyValue<Bytes, LRUCacheEntry>> cacheKvs) {
        DelegatingPeekingKeyValueIterator<Windowed<Bytes>, byte[]> storeIterator = new DelegatingPeekingKeyValueIterator<Windowed<Bytes>, byte[]>("store", new KeyValueIteratorStub(storeKvs));
        DelegatingPeekingKeyValueIterator<Bytes, LRUCacheEntry> cacheIterator = new DelegatingPeekingKeyValueIterator<Bytes, LRUCacheEntry>("cache", new KeyValueIteratorStub(cacheKvs));
        return new MergedSortedCacheWindowStoreKeyValueIterator(cacheIterator, storeIterator, new StateSerdes<Bytes, byte[]>("name", Serdes.Bytes(), Serdes.ByteArray()), 10L, SINGLE_SEGMENT_CACHE_FUNCTION);
    }
}

