/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.MeteredKeyValueBytesStore;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class MeteredKeyValueBytesStoreTest {
    private final TaskId taskId = new TaskId(0, 0);
    private final Map<String, String> tags = new HashMap<String, String>();
    @Mock(type=MockType.NICE)
    private KeyValueStore<Bytes, byte[]> inner;
    @Mock(type=MockType.NICE)
    private ProcessorContext context;
    private MeteredKeyValueBytesStore<String, String> metered;
    private final String key = "key";
    private final Bytes keyBytes = Bytes.wrap("key".getBytes());
    private final String value = "value";
    private final byte[] valueBytes = "value".getBytes();
    private final Metrics metrics = new Metrics();

    @Before
    public void before() {
        this.metered = new MeteredKeyValueBytesStore<String, String>(this.inner, "scope", (Time)new MockTime(), Serdes.String(), Serdes.String());
        this.tags.put("task-id", this.taskId.toString());
        this.tags.put("scope-id", "metered");
        this.metrics.config().recordLevel(Sensor.RecordingLevel.DEBUG);
        EasyMock.expect((Object)this.context.metrics()).andReturn((Object)new MockStreamsMetrics(this.metrics));
        EasyMock.expect((Object)this.context.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.inner.name()).andReturn((Object)"metered").anyTimes();
    }

    private void init() {
        EasyMock.replay((Object[])new Object[]{this.inner, this.context});
        this.metered.init(this.context, this.metered);
    }

    @Test
    public void shouldWriteBytesToInnerStoreAndRecordPutMetric() {
        this.inner.put((Bytes)EasyMock.eq((Object)this.keyBytes), EasyMock.aryEq((byte[])this.valueBytes));
        EasyMock.expectLastCall();
        this.init();
        this.metered.put("key", "value");
        KafkaMetric metric = this.metric("put-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldGetBytesFromInnerStoreAndReturnGetMetric() {
        EasyMock.expect(this.inner.get(this.keyBytes)).andReturn((Object)this.valueBytes);
        this.init();
        Assert.assertThat((Object)this.metered.get("key"), (Matcher)CoreMatchers.equalTo((Object)"value"));
        KafkaMetric metric = this.metric("get-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldPutIfAbsentAndRecordPutIfAbsentMetric() {
        EasyMock.expect((Object)this.inner.putIfAbsent((Bytes)EasyMock.eq((Object)this.keyBytes), EasyMock.aryEq((byte[])this.valueBytes))).andReturn(null);
        this.init();
        this.metered.putIfAbsent("key", "value");
        KafkaMetric metric = this.metric("put-if-absent-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    private KafkaMetric metric(String name) {
        return this.metrics.metric(new MetricName(name, "stream-scope-metrics", "", this.tags));
    }

    @Test
    public void shouldPutAllToInnerStoreAndRecordPutAllMetric() {
        this.inner.putAll((List)EasyMock.anyObject(List.class));
        EasyMock.expectLastCall();
        this.init();
        this.metered.putAll(Collections.singletonList(KeyValue.pair("key", "value")));
        KafkaMetric metric = this.metric("put-all-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldDeleteFromInnerStoreAndRecordDeleteMetric() {
        EasyMock.expect((Object)this.inner.delete(this.keyBytes)).andReturn((Object)this.valueBytes);
        this.init();
        this.metered.delete("key");
        KafkaMetric metric = this.metric("delete-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldGetRangeFromInnerStoreAndRecordRangeMetric() {
        EasyMock.expect(this.inner.range(this.keyBytes, this.keyBytes)).andReturn(new KeyValueIteratorStub(Collections.singletonList(KeyValue.pair(this.keyBytes, this.valueBytes)).iterator()));
        this.init();
        KeyValueIterator<String, String> iterator = this.metered.range("key", "key");
        Assert.assertThat(((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)"value"));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("range-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldGetAllFromInnerStoreAndRecordAllMetric() {
        EasyMock.expect(this.inner.all()).andReturn(new KeyValueIteratorStub(Collections.singletonList(KeyValue.pair(this.keyBytes, this.valueBytes)).iterator()));
        this.init();
        KeyValueIterator<String, String> iterator = this.metered.all();
        Assert.assertThat(((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)"value"));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric(new MetricName("all-rate", "stream-scope-metrics", "", this.tags));
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    private KafkaMetric metric(MetricName metricName) {
        return this.metrics.metric(metricName);
    }
}

