/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.MeteredSessionStore;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class MeteredSessionStoreTest {
    private final TaskId taskId = new TaskId(0, 0);
    private final Map<String, String> tags = new HashMap<String, String>();
    private final Metrics metrics = new Metrics();
    private MeteredSessionStore<String, String> metered;
    @Mock(type=MockType.NICE)
    private SessionStore<Bytes, byte[]> inner;
    @Mock(type=MockType.NICE)
    private ProcessorContext context;
    private final String key = "a";
    private final byte[] keyBytes = "a".getBytes();
    private final Windowed<Bytes> windowedKeyBytes = new Windowed<Bytes>(Bytes.wrap(this.keyBytes), new SessionWindow(0L, 0L));

    @Before
    public void before() {
        this.metered = new MeteredSessionStore<String, String>(this.inner, "scope", Serdes.String(), Serdes.String(), (Time)new MockTime());
        this.tags.put("task-id", this.taskId.toString());
        this.tags.put("scope-id", "metered");
        this.metrics.config().recordLevel(Sensor.RecordingLevel.DEBUG);
        EasyMock.expect((Object)this.context.metrics()).andReturn((Object)new MockStreamsMetrics(this.metrics));
        EasyMock.expect((Object)this.context.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.inner.name()).andReturn((Object)"metered").anyTimes();
    }

    private void init() {
        EasyMock.replay((Object[])new Object[]{this.inner, this.context});
        this.metered.init(this.context, this.metered);
    }

    @Test
    public void shouldWriteBytesToInnerStoreAndRecordPutMetric() {
        this.inner.put((Windowed)EasyMock.eq(this.windowedKeyBytes), EasyMock.aryEq((byte[])this.keyBytes));
        EasyMock.expectLastCall();
        this.init();
        this.metered.put(new Windowed<String>("a", new SessionWindow(0L, 0L)), "a");
        KafkaMetric metric = this.metric("put-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldFindSessionsFromStoreAndRecordFetchMetric() {
        EasyMock.expect(this.inner.findSessions(Bytes.wrap(this.keyBytes), 0L, 0L)).andReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(this.windowedKeyBytes, this.keyBytes)).iterator()));
        this.init();
        KeyValueIterator<Windowed<String>, String> iterator = this.metered.findSessions("a", 0L, 0L);
        Assert.assertThat(((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)"a"));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldFindSessionRangeFromStoreAndRecordFetchMetric() {
        EasyMock.expect(this.inner.findSessions(Bytes.wrap(this.keyBytes), Bytes.wrap(this.keyBytes), 0L, 0L)).andReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(this.windowedKeyBytes, this.keyBytes)).iterator()));
        this.init();
        KeyValueIterator<Windowed<String>, String> iterator = this.metered.findSessions("a", "a", 0L, 0L);
        Assert.assertThat(((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)"a"));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldRemoveFromStoreAndRecordRemoveMetric() {
        this.inner.remove(this.windowedKeyBytes);
        EasyMock.expectLastCall();
        this.init();
        this.metered.remove(new Windowed<String>("a", new SessionWindow(0L, 0L)));
        KafkaMetric metric = this.metric("remove-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldFetchForKeyAndRecordFetchMetric() {
        EasyMock.expect(this.inner.findSessions(Bytes.wrap(this.keyBytes), 0L, Long.MAX_VALUE)).andReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(this.windowedKeyBytes, this.keyBytes)).iterator()));
        this.init();
        KeyValueIterator<Windowed<String>, String> iterator = this.metered.fetch("a");
        Assert.assertThat(((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)"a"));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldFetchRangeFromStoreAndRecordFetchMetric() {
        EasyMock.expect(this.inner.findSessions(Bytes.wrap(this.keyBytes), Bytes.wrap(this.keyBytes), 0L, Long.MAX_VALUE)).andReturn(new KeyValueIteratorStub(Collections.singleton(KeyValue.pair(this.windowedKeyBytes, this.keyBytes)).iterator()));
        this.init();
        KeyValueIterator<Windowed<String>, String> iterator = this.metered.fetch("a", "a");
        Assert.assertThat(((KeyValue)iterator.next()).value, (Matcher)CoreMatchers.equalTo((Object)"a"));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("fetch-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.inner});
    }

    @Test
    public void shouldRecordRestoreTimeOnInit() {
        this.init();
        KafkaMetric metric = this.metric("restore-rate");
        Assert.assertTrue((metric.value() > 0.0 ? 1 : 0) != 0);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnPutIfKeyIsNull() {
        this.metered.put((Windowed<String>)null, "a");
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnRemoveIfKeyIsNull() {
        this.metered.remove(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnFetchIfKeyIsNull() {
        this.metered.fetch(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnFetchRangeIfFromIsNull() {
        this.metered.fetch(null, "to");
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnFetchRangeIfToIsNull() {
        this.metered.fetch("from", null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnFindSessionsIfKeyIsNull() {
        this.metered.findSessions(null, 0L, 0L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnFindSessionsRangeIfFromIsNull() {
        this.metered.findSessions(null, "a", 0L, 0L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerOnFindSessionsRangeIfToIsNull() {
        this.metered.findSessions("a", null, 0L, 0L);
    }

    private KafkaMetric metric(String name) {
        return this.metrics.metric(new MetricName(name, "stream-scope-metrics", "", this.tags));
    }
}

