/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.RocksDBConfigSetter;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.AbstractKeyValueStoreTest;
import org.junit.Assert;
import org.junit.Test;
import org.rocksdb.Options;

public class RocksDBKeyValueStoreTest
extends AbstractKeyValueStoreTest {
    @Override
    protected <K, V> KeyValueStore<K, V> createKeyValueStore(ProcessorContext context) {
        StoreBuilder<KeyValueStore<?, ?>> storeBuilder = Stores.keyValueStoreBuilder(Stores.persistentKeyValueStore("my-store"), context.keySerde(), context.valueSerde());
        KeyValueStore<?, ?> store = storeBuilder.build();
        store.init(context, store);
        return store;
    }

    @Test
    public void shouldUseCustomRocksDbConfigSetter() {
        Assert.assertTrue((boolean)TheRocksDbConfigSetter.called);
    }

    @Test
    public void shouldPerformRangeQueriesWithCachingDisabled() {
        this.context.setTime(1L);
        this.store.put(1, "hi");
        this.store.put(2, "goodbye");
        KeyValueIterator range = this.store.range(1, 2);
        Assert.assertEquals((Object)"hi", ((KeyValue)range.next()).value);
        Assert.assertEquals((Object)"goodbye", ((KeyValue)range.next()).value);
        Assert.assertFalse((boolean)range.hasNext());
    }

    @Test
    public void shouldPerformAllQueriesWithCachingDisabled() {
        this.context.setTime(1L);
        this.store.put(1, "hi");
        this.store.put(2, "goodbye");
        KeyValueIterator range = this.store.all();
        Assert.assertEquals((Object)"hi", ((KeyValue)range.next()).value);
        Assert.assertEquals((Object)"goodbye", ((KeyValue)range.next()).value);
        Assert.assertFalse((boolean)range.hasNext());
    }

    @Test
    public void shouldCloseOpenIteratorsWhenStoreClosedAndThrowInvalidStateStoreOnHasNextAndNext() {
        this.context.setTime(1L);
        this.store.put(1, "hi");
        this.store.put(2, "goodbye");
        KeyValueIterator iteratorOne = this.store.range(1, 5);
        KeyValueIterator iteratorTwo = this.store.range(1, 4);
        Assert.assertTrue((boolean)iteratorOne.hasNext());
        Assert.assertTrue((boolean)iteratorTwo.hasNext());
        this.store.close();
        try {
            iteratorOne.hasNext();
            Assert.fail((String)"should have thrown InvalidStateStoreException on closed store");
        }
        catch (InvalidStateStoreException invalidStateStoreException) {
            // empty catch block
        }
        try {
            iteratorOne.next();
            Assert.fail((String)"should have thrown InvalidStateStoreException on closed store");
        }
        catch (InvalidStateStoreException invalidStateStoreException) {
            // empty catch block
        }
        try {
            iteratorTwo.hasNext();
            Assert.fail((String)"should have thrown InvalidStateStoreException on closed store");
        }
        catch (InvalidStateStoreException invalidStateStoreException) {
            // empty catch block
        }
        try {
            iteratorTwo.next();
            Assert.fail((String)"should have thrown InvalidStateStoreException on closed store");
        }
        catch (InvalidStateStoreException invalidStateStoreException) {
            // empty catch block
        }
    }

    public static class TheRocksDbConfigSetter
    implements RocksDBConfigSetter {
        static boolean called = false;

        @Override
        public void setConfig(String storeName, Options options, Map<String, Object> configs) {
            called = true;
        }
    }
}

