/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBSessionStore;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.MockProcessorContext;
import org.apache.kafka.test.NoOpRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RocksDBSessionStoreTest {
    private SessionStore<String, Long> sessionStore;
    private MockProcessorContext context;

    @Before
    public void before() {
        SessionKeySchema schema = new SessionKeySchema();
        schema.init("topic");
        RocksDBSegmentedBytesStore bytesStore = new RocksDBSegmentedBytesStore("session-store", 10000L, 3, schema);
        this.sessionStore = new RocksDBSessionStore<String, Long>(bytesStore, Serdes.String(), Serdes.Long());
        this.context = new MockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.Long(), new NoOpRecordCollector(), new ThreadCache(new LogContext("testCache "), 0L, new MockStreamsMetrics(new Metrics())));
        this.sessionStore.init(this.context, this.sessionStore);
    }

    @After
    public void close() {
        this.context.close();
        this.sessionStore.close();
    }

    @Test
    public void shouldPutAndFindSessionsInRange() {
        String key = "a";
        Windowed<String> a1 = new Windowed<String>("a", new SessionWindow(10L, 10L));
        Windowed<String> a2 = new Windowed<String>("a", new SessionWindow(500L, 1000L));
        this.sessionStore.put(a1, 1L);
        this.sessionStore.put(a2, 2L);
        this.sessionStore.put(new Windowed<String>("a", new SessionWindow(1500L, 2000L)), 1L);
        this.sessionStore.put(new Windowed<String>("a", new SessionWindow(2500L, 3000L)), 2L);
        List<KeyValue> expected = Arrays.asList(KeyValue.pair(a1, 1L), KeyValue.pair(a2, 2L));
        KeyValueIterator<Windowed<String>, Long> values = this.sessionStore.findSessions("a", 0L, 1000L);
        Assert.assertEquals(expected, RocksDBSessionStoreTest.toList(values));
    }

    @Test
    public void shouldFetchAllSessionsWithSameRecordKey() {
        List<KeyValue> expected = Arrays.asList(KeyValue.pair(new Windowed<String>("a", new SessionWindow(0L, 0L)), 1L), KeyValue.pair(new Windowed<String>("a", new SessionWindow(10L, 10L)), 2L), KeyValue.pair(new Windowed<String>("a", new SessionWindow(100L, 100L)), 3L), KeyValue.pair(new Windowed<String>("a", new SessionWindow(1000L, 1000L)), 4L));
        for (KeyValue kv : expected) {
            this.sessionStore.put((Windowed)kv.key, (Long)kv.value);
        }
        this.sessionStore.put(new Windowed<String>("aa", new SessionWindow(0L, 0L)), 5L);
        List results = RocksDBSessionStoreTest.toList(this.sessionStore.fetch("a"));
        Assert.assertEquals(expected, results);
    }

    @Test
    public void shouldFindValuesWithinMergingSessionWindowRange() {
        String key = "a";
        this.sessionStore.put(new Windowed<String>("a", new SessionWindow(0L, 0L)), 1L);
        this.sessionStore.put(new Windowed<String>("a", new SessionWindow(1000L, 1000L)), 2L);
        KeyValueIterator<Windowed<String>, Long> results = this.sessionStore.findSessions("a", -1L, 1000L);
        List<KeyValue> expected = Arrays.asList(KeyValue.pair(new Windowed<String>("a", new SessionWindow(0L, 0L)), 1L), KeyValue.pair(new Windowed<String>("a", new SessionWindow(1000L, 1000L)), 2L));
        Assert.assertEquals(expected, RocksDBSessionStoreTest.toList(results));
    }

    @Test
    public void shouldRemove() {
        this.sessionStore.put(new Windowed<String>("a", new SessionWindow(0L, 1000L)), 1L);
        this.sessionStore.put(new Windowed<String>("a", new SessionWindow(1500L, 2500L)), 2L);
        this.sessionStore.remove(new Windowed<String>("a", new SessionWindow(0L, 1000L)));
        Assert.assertFalse((boolean)this.sessionStore.findSessions("a", 0L, 1000L).hasNext());
        Assert.assertTrue((boolean)this.sessionStore.findSessions("a", 1500L, 2500L).hasNext());
    }

    @Test
    public void shouldFindSessionsToMerge() {
        Windowed<String> session1 = new Windowed<String>("a", new SessionWindow(0L, 100L));
        Windowed<String> session2 = new Windowed<String>("a", new SessionWindow(101L, 200L));
        Windowed<String> session3 = new Windowed<String>("a", new SessionWindow(201L, 300L));
        Windowed<String> session4 = new Windowed<String>("a", new SessionWindow(301L, 400L));
        Windowed<String> session5 = new Windowed<String>("a", new SessionWindow(401L, 500L));
        this.sessionStore.put(session1, 1L);
        this.sessionStore.put(session2, 2L);
        this.sessionStore.put(session3, 3L);
        this.sessionStore.put(session4, 4L);
        this.sessionStore.put(session5, 5L);
        KeyValueIterator<Windowed<String>, Long> results = this.sessionStore.findSessions("a", 150L, 300L);
        Assert.assertEquals(session2, ((KeyValue)results.next()).key);
        Assert.assertEquals(session3, ((KeyValue)results.next()).key);
        Assert.assertFalse((boolean)results.hasNext());
    }

    @Test
    public void shouldFetchExactKeys() {
        RocksDBSegmentedBytesStore bytesStore = new RocksDBSegmentedBytesStore("session-store", 0x7A00000000000000L, 2, new SessionKeySchema());
        this.sessionStore = new RocksDBSessionStore<String, Long>(bytesStore, Serdes.String(), Serdes.Long());
        this.sessionStore.init(this.context, this.sessionStore);
        this.sessionStore.put(new Windowed<String>("a", new SessionWindow(0L, 0L)), 1L);
        this.sessionStore.put(new Windowed<String>("aa", new SessionWindow(0L, 0L)), 2L);
        this.sessionStore.put(new Windowed<String>("a", new SessionWindow(10L, 20L)), 3L);
        this.sessionStore.put(new Windowed<String>("aa", new SessionWindow(10L, 20L)), 4L);
        this.sessionStore.put(new Windowed<String>("a", new SessionWindow(8791026472627208190L, 0x79FFFFFFFFFFFFFFL)), 5L);
        KeyValueIterator<Windowed<String>, Long> iterator = this.sessionStore.findSessions("a", 0L, Long.MAX_VALUE);
        ArrayList results = new ArrayList();
        while (iterator.hasNext()) {
            results.add(((KeyValue)iterator.next()).value);
        }
        MatcherAssert.assertThat(results, (Matcher)CoreMatchers.equalTo(Arrays.asList(1L, 3L, 5L)));
        iterator = this.sessionStore.findSessions("aa", 0L, Long.MAX_VALUE);
        results = new ArrayList();
        while (iterator.hasNext()) {
            results.add(((KeyValue)iterator.next()).value);
        }
        MatcherAssert.assertThat(results, (Matcher)CoreMatchers.equalTo(Arrays.asList(2L, 4L)));
        KeyValueIterator<Windowed<String>, Long> rangeIterator = this.sessionStore.findSessions("a", "aa", 0L, Long.MAX_VALUE);
        ArrayList rangeResults = new ArrayList();
        while (rangeIterator.hasNext()) {
            rangeResults.add(((KeyValue)rangeIterator.next()).value);
        }
        MatcherAssert.assertThat(rangeResults, (Matcher)CoreMatchers.equalTo(Arrays.asList(1L, 3L, 2L, 4L, 5L)));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFindSessionsNullKey() {
        this.sessionStore.findSessions(null, 1L, 2L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFindSessionsNullFromKey() {
        this.sessionStore.findSessions(null, "anyKeyTo", 1L, 2L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFindSessionsNullToKey() {
        this.sessionStore.findSessions("anyKeyFrom", null, 1L, 2L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFetchNullFromKey() {
        this.sessionStore.fetch(null, "anyToKey");
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFetchNullToKey() {
        this.sessionStore.fetch("anyFromKey", null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFetchNullKey() {
        this.sessionStore.fetch(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnRemoveNullKey() {
        this.sessionStore.remove(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnPutNullKey() {
        this.sessionStore.put(null, 1L);
    }

    static <K, V> List<KeyValue<Windowed<K>, V>> toList(KeyValueIterator<Windowed<K>, V> iterator) {
        ArrayList<KeyValue<Windowed<K>, V>> results = new ArrayList<KeyValue<Windowed<K>, V>>();
        while (iterator.hasNext()) {
            results.add((KeyValue<Windowed<K>, V>)iterator.next());
        }
        return results;
    }
}

