/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.RocksDBConfigSetter;
import org.apache.kafka.streams.state.internals.RocksDBStore;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.MockProcessorContext;
import org.apache.kafka.test.NoOpRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.rocksdb.Options;

public class RocksDBStoreTest {
    private final File tempDir = TestUtils.tempDirectory();
    private Serializer<String> stringSerializer = new StringSerializer();
    private Deserializer<String> stringDeserializer = new StringDeserializer();
    private RocksDBStore subject;
    private MockProcessorContext context;
    private File dir;

    @Before
    public void setUp() {
        this.subject = new RocksDBStore("test");
        this.dir = TestUtils.tempDirectory();
        this.context = new MockProcessorContext(this.dir, Serdes.String(), Serdes.String(), new NoOpRecordCollector(), new ThreadCache(new LogContext("testCache "), 0L, new MockStreamsMetrics(new Metrics())));
    }

    @After
    public void tearDown() {
        this.subject.close();
    }

    @Test
    public void shouldNotThrowExceptionOnRestoreWhenThereIsPreExistingRocksDbFiles() throws Exception {
        this.subject.init(this.context, this.subject);
        String message = "how can a 4 ounce bird carry a 2lb coconut";
        int intKey = 1;
        for (int i = 0; i < 2000000; ++i) {
            this.subject.put(new Bytes(this.stringSerializer.serialize(null, "theKeyIs" + intKey++)), this.stringSerializer.serialize(null, "how can a 4 ounce bird carry a 2lb coconut"));
        }
        ArrayList<KeyValue<byte[], byte[]>> restoreBytes = new ArrayList<KeyValue<byte[], byte[]>>();
        byte[] restoredKey = "restoredKey".getBytes("UTF-8");
        byte[] restoredValue = "restoredValue".getBytes("UTF-8");
        restoreBytes.add(KeyValue.pair(restoredKey, restoredValue));
        this.context.restore("test", restoreBytes);
        Assert.assertThat((Object)this.stringDeserializer.deserialize(null, this.subject.get(new Bytes(this.stringSerializer.serialize(null, "restoredKey")))), (Matcher)CoreMatchers.equalTo((Object)"restoredValue"));
    }

    @Test
    public void verifyRocksDbConfigSetterIsCalled() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("application.id", "test-application");
        configs.put("bootstrap.servers", "test-server:9092");
        configs.put("rocksdb.config.setter", MockRocksDbConfigSetter.class);
        MockRocksDbConfigSetter.called = false;
        this.subject.openDB(new MockProcessorContext(this.tempDir, new StreamsConfig(configs)));
        Assert.assertTrue((boolean)MockRocksDbConfigSetter.called);
    }

    @Test(expected=ProcessorStateException.class)
    public void shouldThrowProcessorStateExceptionOnOpeningReadOnlyDir() throws IOException {
        File tmpDir = TestUtils.tempDirectory();
        MockProcessorContext tmpContext = new MockProcessorContext(tmpDir, Serdes.String(), Serdes.Long(), new NoOpRecordCollector(), new ThreadCache(new LogContext("testCache "), 0L, new MockStreamsMetrics(new Metrics())));
        tmpDir.setReadOnly();
        this.subject.openDB(tmpContext);
    }

    @Test
    public void shouldPutAll() {
        ArrayList<KeyValue<Bytes, byte[]>> entries = new ArrayList<KeyValue<Bytes, byte[]>>();
        entries.add(new KeyValue<Bytes, byte[]>(new Bytes(this.stringSerializer.serialize(null, "1")), this.stringSerializer.serialize(null, "a")));
        entries.add(new KeyValue<Bytes, byte[]>(new Bytes(this.stringSerializer.serialize(null, "2")), this.stringSerializer.serialize(null, "b")));
        entries.add(new KeyValue<Bytes, byte[]>(new Bytes(this.stringSerializer.serialize(null, "3")), this.stringSerializer.serialize(null, "c")));
        this.subject.init(this.context, this.subject);
        this.subject.putAll((List<KeyValue<Bytes, byte[]>>)entries);
        this.subject.flush();
        Assert.assertEquals((Object)this.stringDeserializer.deserialize(null, this.subject.get(new Bytes(this.stringSerializer.serialize(null, "1")))), (Object)"a");
        Assert.assertEquals((Object)this.stringDeserializer.deserialize(null, this.subject.get(new Bytes(this.stringSerializer.serialize(null, "2")))), (Object)"b");
        Assert.assertEquals((Object)this.stringDeserializer.deserialize(null, this.subject.get(new Bytes(this.stringSerializer.serialize(null, "3")))), (Object)"c");
    }

    @Test
    public void shouldTogglePrepareForBulkloadSetting() {
        this.subject.init(this.context, this.subject);
        RocksDBStore.RocksDBBatchingRestoreCallback restoreListener = (RocksDBStore.RocksDBBatchingRestoreCallback)this.subject.batchingStateRestoreCallback;
        restoreListener.onRestoreStart(null, null, 0L, 0L);
        Assert.assertTrue((String)"Should have set bulk loading to true", (boolean)this.subject.isPrepareForBulkload());
        restoreListener.onRestoreEnd(null, null, 0L);
        Assert.assertFalse((String)"Should have set bulk loading to false", (boolean)this.subject.isPrepareForBulkload());
    }

    @Test
    public void shouldTogglePrepareForBulkloadSettingWhenPrexistingSstFiles() throws Exception {
        List<KeyValue<byte[], byte[]>> entries = this.getKeyValueEntries();
        this.subject.init(this.context, this.subject);
        this.context.restore(this.subject.name(), entries);
        RocksDBStore.RocksDBBatchingRestoreCallback restoreListener = (RocksDBStore.RocksDBBatchingRestoreCallback)this.subject.batchingStateRestoreCallback;
        restoreListener.onRestoreStart(null, null, 0L, 0L);
        Assert.assertTrue((String)"Should have not set bulk loading to true", (boolean)this.subject.isPrepareForBulkload());
        restoreListener.onRestoreEnd(null, null, 0L);
        Assert.assertFalse((String)"Should have set bulk loading to false", (boolean)this.subject.isPrepareForBulkload());
    }

    @Test
    public void shouldRestoreAll() throws Exception {
        List<KeyValue<byte[], byte[]>> entries = this.getKeyValueEntries();
        this.subject.init(this.context, this.subject);
        this.context.restore(this.subject.name(), entries);
        Assert.assertEquals((Object)this.stringDeserializer.deserialize(null, this.subject.get(new Bytes(this.stringSerializer.serialize(null, "1")))), (Object)"a");
        Assert.assertEquals((Object)this.stringDeserializer.deserialize(null, this.subject.get(new Bytes(this.stringSerializer.serialize(null, "2")))), (Object)"b");
        Assert.assertEquals((Object)this.stringDeserializer.deserialize(null, this.subject.get(new Bytes(this.stringSerializer.serialize(null, "3")))), (Object)"c");
    }

    @Test
    public void shouldHandleDeletesOnRestoreAll() throws Exception {
        List<KeyValue<byte[], byte[]>> entries = this.getKeyValueEntries();
        entries.add(new KeyValue<byte[], byte[]>("1".getBytes("UTF-8"), null));
        this.subject.init(this.context, this.subject);
        this.context.restore(this.subject.name(), entries);
        KeyValueIterator<Bytes, byte[]> iterator = this.subject.all();
        HashSet<String> keys = new HashSet<String>();
        while (iterator.hasNext()) {
            keys.add(this.stringDeserializer.deserialize(null, ((Bytes)((KeyValue)iterator.next()).key).get()));
        }
        Assert.assertThat(keys, (Matcher)CoreMatchers.equalTo(Utils.mkSet("2", "3")));
    }

    @Test
    public void shouldHandleDeletesAndPutbackOnRestoreAll() throws Exception {
        ArrayList<KeyValue<byte[], byte[]>> entries = new ArrayList<KeyValue<byte[], byte[]>>();
        entries.add(new KeyValue<byte[], byte[]>("1".getBytes("UTF-8"), "a".getBytes("UTF-8")));
        entries.add(new KeyValue<byte[], byte[]>("2".getBytes("UTF-8"), "b".getBytes("UTF-8")));
        entries.add(new KeyValue<byte[], byte[]>("1".getBytes("UTF-8"), null));
        entries.add(new KeyValue<byte[], byte[]>("3".getBytes("UTF-8"), "c".getBytes("UTF-8")));
        entries.add(new KeyValue<byte[], byte[]>("1".getBytes("UTF-8"), "restored".getBytes("UTF-8")));
        this.subject.init(this.context, this.subject);
        this.context.restore(this.subject.name(), entries);
        KeyValueIterator<Bytes, byte[]> iterator = this.subject.all();
        HashSet<String> keys = new HashSet<String>();
        while (iterator.hasNext()) {
            keys.add(this.stringDeserializer.deserialize(null, ((Bytes)((KeyValue)iterator.next()).key).get()));
        }
        Assert.assertThat(keys, (Matcher)CoreMatchers.equalTo(Utils.mkSet("1", "2", "3")));
        Assert.assertEquals((Object)this.stringDeserializer.deserialize(null, this.subject.get(new Bytes(this.stringSerializer.serialize(null, "1")))), (Object)"restored");
        Assert.assertEquals((Object)this.stringDeserializer.deserialize(null, this.subject.get(new Bytes(this.stringSerializer.serialize(null, "2")))), (Object)"b");
        Assert.assertEquals((Object)this.stringDeserializer.deserialize(null, this.subject.get(new Bytes(this.stringSerializer.serialize(null, "3")))), (Object)"c");
    }

    @Test
    public void shouldRestoreThenDeleteOnRestoreAll() throws Exception {
        List<KeyValue<byte[], byte[]>> entries = this.getKeyValueEntries();
        this.subject.init(this.context, this.subject);
        this.context.restore(this.subject.name(), entries);
        Assert.assertEquals((Object)this.stringDeserializer.deserialize(null, this.subject.get(new Bytes(this.stringSerializer.serialize(null, "1")))), (Object)"a");
        Assert.assertEquals((Object)this.stringDeserializer.deserialize(null, this.subject.get(new Bytes(this.stringSerializer.serialize(null, "2")))), (Object)"b");
        Assert.assertEquals((Object)this.stringDeserializer.deserialize(null, this.subject.get(new Bytes(this.stringSerializer.serialize(null, "3")))), (Object)"c");
        entries.clear();
        entries.add(new KeyValue<byte[], byte[]>("2".getBytes("UTF-8"), "b".getBytes("UTF-8")));
        entries.add(new KeyValue<byte[], byte[]>("3".getBytes("UTF-8"), "c".getBytes("UTF-8")));
        entries.add(new KeyValue<byte[], byte[]>("1".getBytes("UTF-8"), null));
        this.context.restore(this.subject.name(), entries);
        KeyValueIterator<Bytes, byte[]> iterator = this.subject.all();
        HashSet<String> keys = new HashSet<String>();
        while (iterator.hasNext()) {
            keys.add(this.stringDeserializer.deserialize(null, ((Bytes)((KeyValue)iterator.next()).key).get()));
        }
        Assert.assertThat(keys, (Matcher)CoreMatchers.equalTo(Utils.mkSet("2", "3")));
    }

    @Test
    public void shouldThrowNullPointerExceptionOnNullPut() {
        this.subject.init(this.context, this.subject);
        try {
            this.subject.put(null, this.stringSerializer.serialize(null, "someVal"));
            Assert.fail((String)"Should have thrown NullPointerException on null put()");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowNullPointerExceptionOnNullPutAll() {
        this.subject.init(this.context, this.subject);
        try {
            this.subject.put(null, this.stringSerializer.serialize(null, "someVal"));
            Assert.fail((String)"Should have thrown NullPointerException on null put()");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowNullPointerExceptionOnNullGet() {
        this.subject.init(this.context, this.subject);
        try {
            this.subject.get(null);
            Assert.fail((String)"Should have thrown NullPointerException on null get()");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowNullPointerExceptionOnDelete() {
        this.subject.init(this.context, this.subject);
        try {
            this.subject.delete(null);
            Assert.fail((String)"Should have thrown NullPointerException on deleting null key");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowNullPointerExceptionOnRange() {
        this.subject.init(this.context, this.subject);
        try {
            this.subject.range(null, new Bytes(this.stringSerializer.serialize(null, "2")));
            Assert.fail((String)"Should have thrown NullPointerException on deleting null key");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test(expected=ProcessorStateException.class)
    public void shouldThrowProcessorStateExceptionOnPutDeletedDir() throws IOException {
        this.subject.init(this.context, this.subject);
        Utils.delete(this.dir);
        this.subject.put(new Bytes(this.stringSerializer.serialize(null, "anyKey")), this.stringSerializer.serialize(null, "anyValue"));
        this.subject.flush();
    }

    private List<KeyValue<byte[], byte[]>> getKeyValueEntries() throws UnsupportedEncodingException {
        ArrayList<KeyValue<byte[], byte[]>> entries = new ArrayList<KeyValue<byte[], byte[]>>();
        entries.add(new KeyValue<byte[], byte[]>("1".getBytes("UTF-8"), "a".getBytes("UTF-8")));
        entries.add(new KeyValue<byte[], byte[]>("2".getBytes("UTF-8"), "b".getBytes("UTF-8")));
        entries.add(new KeyValue<byte[], byte[]>("3".getBytes("UTF-8"), "c".getBytes("UTF-8")));
        return entries;
    }

    public static class MockRocksDbConfigSetter
    implements RocksDBConfigSetter {
        static boolean called;

        @Override
        public void setConfig(String storeName, Options options, Map<String, Object> configs) {
            called = true;
        }
    }
}

