/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.IOException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.internals.RocksDBStore;

class Segment
extends RocksDBStore
implements Comparable<Segment> {
    public final long id;

    Segment(String segmentName, String windowName, long id) {
        super(segmentName, windowName);
        this.id = id;
    }

    void destroy() throws IOException {
        Utils.delete(this.dbDir);
    }

    @Override
    public int compareTo(Segment segment) {
        return Long.compare(this.id, segment.id);
    }

    @Override
    public void openDB(ProcessorContext context) {
        super.openDB(context);
    }

    public String toString() {
        return "Segment(id=" + this.id + ", name=" + this.name() + ")";
    }
}

