/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Test;

public class SegmentedCacheFunctionTest {
    private static final int SEGMENT_INTERVAL = 17;
    private static final int TIMESTAMP = 736213517;
    private static final Bytes THE_KEY = WindowStoreUtils.toBinaryKey(new byte[]{10, 11, 12}, 736213517L, 42);
    private static final Bytes THE_CACHE_KEY = Bytes.wrap(ByteBuffer.allocate(8 + THE_KEY.get().length).putLong(43306677L).put(THE_KEY.get()).array());
    private final SegmentedCacheFunction cacheFunction = new SegmentedCacheFunction(new WindowKeySchema(), 17L);

    @Test
    public void key() {
        MatcherAssert.assertThat((Object)this.cacheFunction.key(THE_CACHE_KEY), (Matcher)IsEqual.equalTo((Object)THE_KEY));
    }

    @Test
    public void cacheKey() {
        long segmentId = 43306677L;
        Bytes actualCacheKey = this.cacheFunction.cacheKey(THE_KEY);
        ByteBuffer buffer = ByteBuffer.wrap(actualCacheKey.get());
        MatcherAssert.assertThat((Object)buffer.getLong(), (Matcher)IsEqual.equalTo((Object)43306677L));
        byte[] actualKey = new byte[buffer.remaining()];
        buffer.get(actualKey);
        MatcherAssert.assertThat((Object)Bytes.wrap(actualKey), (Matcher)IsEqual.equalTo((Object)THE_KEY));
    }

    @Test
    public void testRoundTripping() {
        MatcherAssert.assertThat((Object)this.cacheFunction.key(this.cacheFunction.cacheKey(THE_KEY)), (Matcher)IsEqual.equalTo((Object)THE_KEY));
        MatcherAssert.assertThat((Object)this.cacheFunction.cacheKey(this.cacheFunction.key(THE_CACHE_KEY)), (Matcher)IsEqual.equalTo((Object)THE_CACHE_KEY));
    }

    @Test
    public void compareSegmentedKeys() {
        MatcherAssert.assertThat((String)"same key in same segment should be ranked the same", (this.cacheFunction.compareSegmentedKeys(this.cacheFunction.cacheKey(THE_KEY), THE_KEY) == 0 ? 1 : 0) != 0);
        Bytes sameKeyInPriorSegment = WindowStoreUtils.toBinaryKey(new byte[]{10, 11, 12}, 1234L, 42);
        MatcherAssert.assertThat((String)"same keys in different segments should be ordered according to segment", (this.cacheFunction.compareSegmentedKeys(this.cacheFunction.cacheKey(sameKeyInPriorSegment), THE_KEY) < 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"same keys in different segments should be ordered according to segment", (this.cacheFunction.compareSegmentedKeys(this.cacheFunction.cacheKey(THE_KEY), sameKeyInPriorSegment) > 0 ? 1 : 0) != 0);
        Bytes lowerKeyInSameSegment = WindowStoreUtils.toBinaryKey(new byte[]{10, 11, 11}, 736213516L, 0);
        MatcherAssert.assertThat((String)"different keys in same segments should be ordered according to key", (this.cacheFunction.compareSegmentedKeys(this.cacheFunction.cacheKey(THE_KEY), lowerKeyInSameSegment) > 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"different keys in same segments should be ordered according to key", (this.cacheFunction.compareSegmentedKeys(this.cacheFunction.cacheKey(lowerKeyInSameSegment), THE_KEY) < 0 ? 1 : 0) != 0);
    }
}

