/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.errors.DefaultProductionExceptionHandler;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.internals.RecordCollectorImpl;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.StoreChangeLogger;
import org.apache.kafka.test.MockProcessorContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class StoreChangeLoggerTest {
    private final String topic = "topic";
    private final Map<Integer, String> logged = new HashMap<Integer, String>();
    private final MockProcessorContext context = new MockProcessorContext(StateSerdes.withBuiltinTypes("topic", Integer.class, String.class), new RecordCollectorImpl(null, "StoreChangeLoggerTest", new LogContext("StoreChangeLoggerTest "), new DefaultProductionExceptionHandler()){

        public <K1, V1> void send(String topic, K1 key, V1 value, Integer partition, Long timestamp, Serializer<K1> keySerializer, Serializer<V1> valueSerializer) {
            StoreChangeLoggerTest.this.logged.put((Integer)key, (String)value);
        }

        public <K1, V1> void send(String topic, K1 key, V1 value, Long timestamp, Serializer<K1> keySerializer, Serializer<V1> valueSerializer, StreamPartitioner<? super K1, ? super V1> partitioner) {
            throw new UnsupportedOperationException();
        }
    });
    private final StoreChangeLogger<Integer, String> changeLogger = new StoreChangeLogger<Integer, String>("topic", this.context, StateSerdes.withBuiltinTypes("topic", Integer.class, String.class));

    @After
    public void after() {
        this.context.close();
    }

    @Test
    public void testAddRemove() {
        this.context.setTime(1L);
        this.changeLogger.logChange(0, "zero");
        this.changeLogger.logChange(1, "one");
        this.changeLogger.logChange(2, "two");
        Assert.assertEquals((Object)"zero", (Object)this.logged.get(0));
        Assert.assertEquals((Object)"one", (Object)this.logged.get(1));
        Assert.assertEquals((Object)"two", (Object)this.logged.get(2));
        this.changeLogger.logChange(0, null);
        Assert.assertNull((Object)this.logged.get(0));
    }
}

