/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.CachingWindowStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingWindowBytesStore;
import org.apache.kafka.streams.state.internals.MeteredWindowStore;
import org.apache.kafka.streams.state.internals.WindowStoreBuilder;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class WindowStoreBuilderTest {
    @Mock(type=MockType.NICE)
    private WindowBytesStoreSupplier supplier;
    @Mock(type=MockType.NICE)
    private WindowStore<Bytes, byte[]> inner;
    private WindowStoreBuilder<String, String> builder;

    @Before
    public void setUp() throws Exception {
        EasyMock.expect(this.supplier.get()).andReturn(this.inner);
        EasyMock.expect((Object)this.supplier.name()).andReturn((Object)"name");
        EasyMock.replay((Object[])new Object[]{this.supplier});
        this.builder = new WindowStoreBuilder<String, String>(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }

    @Test
    public void shouldHaveMeteredStoreAsOuterStore() {
        StateStore store = this.builder.build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredWindowStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreByDefault() {
        StateStore store = this.builder.build();
        StateStore next = ((WrappedStateStore)store).wrappedStore();
        MatcherAssert.assertThat((Object)next, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingWindowBytesStore.class));
    }

    @Test
    public void shouldNotHaveChangeLoggingStoreWhenDisabled() {
        WindowStore store = (WindowStore)this.builder.withLoggingDisabled().build();
        StateStore next = ((WrappedStateStore)((Object)store)).wrappedStore();
        MatcherAssert.assertThat((Object)next, (Matcher)CoreMatchers.equalTo(this.inner));
    }

    @Test
    public void shouldHaveCachingStoreWhenEnabled() {
        WindowStore store = (WindowStore)this.builder.withCachingEnabled().build();
        StateStore wrapped = ((WrappedStateStore)((Object)store)).wrappedStore();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredWindowStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(CachingWindowStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreWhenLoggingEnabled() {
        WindowStore store = (WindowStore)this.builder.withLoggingEnabled(Collections.emptyMap()).build();
        StateStore wrapped = ((WrappedStateStore)((Object)store)).wrappedStore();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredWindowStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingWindowBytesStore.class));
        MatcherAssert.assertThat((Object)((WrappedStateStore)wrapped).wrappedStore(), (Matcher)CoreMatchers.equalTo(this.inner));
    }

    @Test
    public void shouldHaveCachingAndChangeLoggingWhenBothEnabled() {
        WindowStore store = (WindowStore)this.builder.withLoggingEnabled(Collections.emptyMap()).withCachingEnabled().build();
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)((Object)store)).wrappedStore();
        WrappedStateStore changeLogging = (WrappedStateStore)caching.wrappedStore();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredWindowStore.class));
        MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachingWindowStore.class));
        MatcherAssert.assertThat((Object)changeLogging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingWindowBytesStore.class));
        MatcherAssert.assertThat((Object)changeLogging.wrappedStore(), (Matcher)CoreMatchers.equalTo(this.inner));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfInnerIsNull() {
        new WindowStoreBuilder<String, String>(null, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfKeySerdeIsNull() {
        new WindowStoreBuilder(this.supplier, null, Serdes.String(), (Time)new MockTime());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfValueSerdeIsNull() {
        new WindowStoreBuilder(this.supplier, Serdes.String(), null, (Time)new MockTime());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfTimeIsNull() {
        new WindowStoreBuilder<String, String>(this.supplier, Serdes.String(), Serdes.String(), null);
    }
}

